/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InstallationTemplate {
    private String mBody;
    private Set<String> mTags = new HashSet<String>();
    private Map<String, String> mHeaders = new HashMap<String, String>();

    public String getBody() {
        return this.mBody;
    }

    public void setBody(String value) {
        this.mBody = value;
    }

    public void addTag(String tag) {
        this.mTags.add(tag);
    }

    public void addTags(List<String> tags) {
        this.mTags.addAll(tags);
    }

    public void removeTag(String tag) {
        this.mTags.remove(tag);
    }

    public void removeTags(List<String> tags) {
        this.mTags.removeAll(tags);
    }

    public Iterable<String> getTags() {
        return this.mTags;
    }

    public void clearTags() {
        this.mTags = new HashSet<String>();
    }

    public void setHeader(String name, String value) {
        this.mHeaders.put(name, value);
    }

    public void removeHeader(String name) {
        this.mHeaders.remove(name);
    }

    static JSONObject serialize(String name, InstallationTemplate installationTemplate) {
        JSONObject templateObject = new JSONObject();
        try {
            templateObject.put("name", (Object)name);
            templateObject.put("body", (Object)installationTemplate.getBody());
            JSONObject headers = new JSONObject();
            for (Map.Entry<String, String> header : installationTemplate.getHeaders().entrySet()) {
                headers.put(header.getKey(), (Object)header.getValue());
            }
            templateObject.put("headers", (Object)headers);
            JSONArray tagsArray = new JSONArray();
            for (String tag : installationTemplate.getTags()) {
                tagsArray.put((Object)tag);
            }
            templateObject.put("tags", (Object)tagsArray);
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid template, unable to serialize", ex);
        }
        return templateObject;
    }

    static InstallationTemplate deserialize(JSONObject installationTemplate) throws JSONException {
        InstallationTemplate template = new InstallationTemplate();
        template.setBody(installationTemplate.getString("body"));
        if (installationTemplate.has("tags")) {
            JSONArray tags = installationTemplate.getJSONArray("tags");
            for (int tagKey = 0; tagKey < tags.length(); ++tagKey) {
                template.addTag(tags.getString(tagKey));
            }
        }
        if (installationTemplate.has("tags")) {
            JSONObject headers = installationTemplate.getJSONObject("headers");
            Iterator headersIterators = headers.keys();
            while (headersIterators.hasNext()) {
                String headerKey = (String)headersIterators.next();
                template.setHeader(headerKey, headers.getString(headerKey));
            }
        }
        return template;
    }

    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.mHeaders);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InstallationTemplate)) {
            return false;
        }
        InstallationTemplate castedObj = (InstallationTemplate)obj;
        return this.mBody.equals(castedObj.mBody) && this.mTags.equals(castedObj.mTags) && this.mHeaders.equals(castedObj.mHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.mBody, this.mTags, this.mHeaders);
    }
}

