/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging;

import com.microsoft.windowsazure.messaging.Utils;
import java.net.URI;

public class ConnectionString {
    public static String createUsingSharedAccessKey(URI endPoint, String keyName, String accessSecret) {
        if (endPoint == null) {
            throw new IllegalArgumentException("endPoint");
        }
        if (Utils.isNullOrWhiteSpace(keyName)) {
            throw new IllegalArgumentException("keyName");
        }
        if (Utils.isNullOrWhiteSpace(accessSecret)) {
            throw new IllegalArgumentException("accessSecret");
        }
        return String.format("Endpoint=%s;SharedAccessKeyName=%s;SharedAccessKey=%s", endPoint.toString(), keyName, accessSecret);
    }

    public static String createUsingSharedAccessKeyWithFullAccess(URI endPoint, String fullAccessSecret) {
        if (Utils.isNullOrWhiteSpace(fullAccessSecret)) {
            throw new IllegalArgumentException("fullAccessSecret");
        }
        return ConnectionString.createUsingSharedAccessKey(endPoint, "DefaultFullSharedAccessSignature", fullAccessSecret);
    }

    public static String createUsingSharedAccessKeyWithListenAccess(URI endPoint, String listenAccessSecret) {
        if (Utils.isNullOrWhiteSpace(listenAccessSecret)) {
            throw new IllegalArgumentException("listenAccessSecret");
        }
        return ConnectionString.createUsingSharedAccessKey(endPoint, "DefaultListenSharedAccessSignature", listenAccessSecret);
    }
}

