/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging;

import android.os.Build;
import android.util.Base64;
import com.microsoft.windowsazure.messaging.ConnectionStringParser;
import com.microsoft.windowsazure.messaging.NotificationHubException;
import com.microsoft.windowsazure.messaging.NotificationHubResourceNotFoundException;
import com.microsoft.windowsazure.messaging.NotificationHubUnauthorizedException;
import com.microsoft.windowsazure.messaging.PnsSpecificRegistrationFactory;
import com.microsoft.windowsazure.messaging.RegistrationGoneException;
import com.microsoft.windowsazure.messaging.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class Connection {
    private static final String SHARED_ACCESS_KEY_NAME = "SharedAccessKeyName";
    private static final String SHARED_ACCESS_KEY = "SharedAccessKey";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String UTC_TIME_ZONE = "UTC";
    private static final String UTF8_ENCODING = "UTF-8";
    private static final String ENDPOINT_KEY = "Endpoint";
    private static final int EXPIRE_MINUTES = 5;
    private static final String SDK_VERSION = "2014-09";
    private static final String API_VERSION_KEY = "api-version";
    private static final String API_VERSION = "2014-09";
    private Map<String, String> mConnectionData;

    public Connection(String connectionString) {
        this.mConnectionData = ConnectionStringParser.parse(connectionString);
    }

    public String executeRequest(String resource, String content, String contentType, String method, AbstractMap.SimpleEntry<String, String> ... extraHeaders) throws Exception {
        return this.executeRequest(resource, content, contentType, method, (String)null, extraHeaders);
    }

    public String executeRequest(String resource, String content, String contentType, String method, String targetHeaderName, AbstractMap.SimpleEntry<String, String> ... extraHeaders) throws Exception {
        URI endpointURI = URI.create(this.mConnectionData.get(ENDPOINT_KEY));
        String scheme = endpointURI.getScheme();
        String url = "https" + endpointURI.toString().substring(scheme.length());
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + resource;
        url = this.AddApiVersionToUrl(url);
        URL wrappedUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)wrappedUrl.openConnection();
        conn.setRequestMethod(method);
        conn.setRequestProperty("Content-Type", contentType);
        if (extraHeaders != null) {
            for (AbstractMap.SimpleEntry<String, String> header : extraHeaders) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        return this.executeRequest(conn, targetHeaderName, content);
    }

    private String AddApiVersionToUrl(String url) {
        URI uri = URI.create(url);
        url = uri.getQuery() == null ? url + "?" : url + "&";
        url = url + API_VERSION_KEY + "=" + "2014-09";
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeRequest(HttpURLConnection conn, String targetHeaderName, String postContent) throws Exception {
        String content;
        int status;
        this.addAuthorizationHeader(conn);
        String headerValue = null;
        boolean noHeaderButExpected = false;
        try {
            conn.setRequestProperty("User-Agent", this.getUserAgent());
            if (Utils.isNullOrWhiteSpace(postContent)) {
                conn.connect();
            } else {
                conn.setDoOutput(true);
                OutputStream os = conn.getOutputStream();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, UTF8_ENCODING));
                writer.write(postContent);
                writer.flush();
                writer.close();
                os.close();
            }
            status = conn.getResponseCode();
            content = this.getResponseContent(conn);
            if (targetHeaderName != null) {
                if (conn.getHeaderField(targetHeaderName) == null) {
                    noHeaderButExpected = true;
                } else {
                    headerValue = conn.getHeaderField(targetHeaderName);
                }
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        if (status >= 200 && status < 300) {
            if (noHeaderButExpected) {
                throw new NotificationHubException("The '" + targetHeaderName + "' header does not present in collection", status);
            }
            return targetHeaderName == null ? content : headerValue;
        }
        if (status == 404) {
            throw new NotificationHubResourceNotFoundException();
        }
        if (status == 401) {
            throw new NotificationHubUnauthorizedException();
        }
        if (status == 410) {
            throw new RegistrationGoneException();
        }
        throw new NotificationHubException(content, status);
    }

    private String getResponseContent(HttpURLConnection conn) throws IOException {
        try {
            InputStream instream = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(instream));
            StringBuilder sb = new StringBuilder();
            String content = reader.readLine();
            if (content == null) {
                return null;
            }
            while (content != null) {
                sb.append(content);
                sb.append('\n');
                content = reader.readLine();
            }
            return sb.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void addAuthorizationHeader(HttpURLConnection conn) throws InvalidKeyException {
        String token = this.generateAuthToken(conn.getURL().toString());
        conn.setRequestProperty(AUTHORIZATION_HEADER, token);
    }

    private String generateAuthToken(String url) throws InvalidKeyException {
        String keyName = this.mConnectionData.get(SHARED_ACCESS_KEY_NAME);
        if (Utils.isNullOrWhiteSpace(keyName)) {
            throw new AssertionError((Object)SHARED_ACCESS_KEY_NAME);
        }
        String key = this.mConnectionData.get(SHARED_ACCESS_KEY);
        if (Utils.isNullOrWhiteSpace(key)) {
            throw new AssertionError((Object)SHARED_ACCESS_KEY);
        }
        try {
            url = URLEncoder.encode(url, UTF8_ENCODING).toLowerCase(Locale.ENGLISH);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Calendar expireDate = Calendar.getInstance(TimeZone.getTimeZone(UTC_TIME_ZONE));
        expireDate.add(12, 5);
        long expires = expireDate.getTimeInMillis() / 1000L;
        String toSign = url + '\n' + expires;
        byte[] bytesToSign = toSign.getBytes();
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        SecretKeySpec secret = new SecretKeySpec(key.getBytes(), mac.getAlgorithm());
        mac.init(secret);
        byte[] signedHash = mac.doFinal(bytesToSign);
        String base64Signature = Base64.encodeToString((byte[])signedHash, (int)0);
        base64Signature = base64Signature.trim();
        try {
            base64Signature = URLEncoder.encode(base64Signature, UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String token = "SharedAccessSignature sr=" + url + "&sig=" + base64Signature + "&se=" + expires + "&skn=" + keyName;
        return token;
    }

    private String getUserAgent() {
        String userAgent = String.format("NOTIFICATIONHUBS/%s (api-origin=%s; os=%s; os_version=%s;)", "2014-09", PnsSpecificRegistrationFactory.getInstance().getAPIOrigin(), "Android", Build.VERSION.RELEASE);
        return userAgent;
    }
}

