/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging;

import android.net.http.AndroidHttpClient;
import android.os.Build;
import android.util.Base64;
import com.microsoft.windowsazure.messaging.ConnectionStringParser;
import com.microsoft.windowsazure.messaging.NotificationHubException;
import com.microsoft.windowsazure.messaging.NotificationHubResourceNotFoundException;
import com.microsoft.windowsazure.messaging.NotificationHubUnauthorizedException;
import com.microsoft.windowsazure.messaging.PnsSpecificRegistrationFactory;
import com.microsoft.windowsazure.messaging.RegistrationGoneException;
import com.microsoft.windowsazure.messaging.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

class Connection {
    private static final String SHARED_ACCESS_KEY_NAME = "SharedAccessKeyName";
    private static final String SHARED_ACCESS_KEY = "SharedAccessKey";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String UTC_TIME_ZONE = "UTC";
    private static final String UTF8_ENCODING = "UTF-8";
    private static final String ENDPOINT_KEY = "Endpoint";
    private static final int EXPIRE_MINUTES = 5;
    private static final String SDK_VERSION = "2014-09";
    private static final String API_VERSION_KEY = "api-version";
    private static final String API_VERSION = "2014-09";
    private Map<String, String> mConnectionData;

    public Connection(String connectionString) {
        this.mConnectionData = ConnectionStringParser.parse(connectionString);
    }

    public String executeRequest(String resource, String content, String contentType, String method, Header ... extraHeaders) throws Exception {
        return this.executeRequest(resource, content, contentType, method, (String)null, extraHeaders);
    }

    public String executeRequest(String resource, String content, String contentType, String method, String targetHeaderName, Header ... extraHeaders) throws Exception {
        URI endpointURI = URI.create(this.mConnectionData.get(ENDPOINT_KEY));
        String scheme = endpointURI.getScheme();
        String url = "https" + endpointURI.toString().substring(scheme.length());
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + resource;
        url = this.AddApiVersionToUrl(url);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest(method, url);
        if (!Utils.isNullOrWhiteSpace(content)) {
            request.setEntity((HttpEntity)new StringEntity(content, UTF8_ENCODING));
        }
        request.addHeader("Content-Type", contentType);
        EntityEnclosingRequestWrapper wrapper = new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request);
        if (extraHeaders != null) {
            for (Header header : extraHeaders) {
                wrapper.addHeader(header);
            }
        }
        return this.executeRequest((HttpUriRequest)wrapper, targetHeaderName);
    }

    private String AddApiVersionToUrl(String url) {
        URI uri = URI.create(url);
        url = uri.getQuery() == null ? url + "?" : url + "&";
        url = url + API_VERSION_KEY + "=" + "2014-09";
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeRequest(HttpUriRequest request, String targetHeaderName) throws Exception {
        String content;
        int status;
        this.addAuthorizationHeader(request);
        String headerValue = null;
        boolean noHeaderButExpected = false;
        try (AndroidHttpClient client = null;){
            client = AndroidHttpClient.newInstance((String)this.getUserAgent());
            HttpResponse response = client.execute(request);
            status = response.getStatusLine().getStatusCode();
            content = this.getResponseContent(response);
            if (targetHeaderName != null) {
                if (!response.containsHeader(targetHeaderName)) {
                    noHeaderButExpected = true;
                } else {
                    headerValue = response.getFirstHeader(targetHeaderName).getValue();
                }
            }
        }
        if (status >= 200 && status < 300) {
            if (noHeaderButExpected) {
                throw new NotificationHubException("The '" + targetHeaderName + "' header does not present in collection", status);
            }
            return targetHeaderName == null ? content : headerValue;
        }
        if (status == 404) {
            throw new NotificationHubResourceNotFoundException();
        }
        if (status == 401) {
            throw new NotificationHubUnauthorizedException();
        }
        if (status == 410) {
            throw new RegistrationGoneException();
        }
        throw new NotificationHubException(content, status);
    }

    private String getResponseContent(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream instream = entity.getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(instream));
            StringBuilder sb = new StringBuilder();
            String content = reader.readLine();
            while (content != null) {
                sb.append(content);
                sb.append('\n');
                content = reader.readLine();
            }
            return sb.toString();
        }
        return null;
    }

    private void addAuthorizationHeader(HttpUriRequest request) throws InvalidKeyException {
        String token = this.generateAuthToken(request.getURI().toString());
        request.addHeader(AUTHORIZATION_HEADER, token);
    }

    private String generateAuthToken(String url) throws InvalidKeyException {
        String keyName = this.mConnectionData.get(SHARED_ACCESS_KEY_NAME);
        if (Utils.isNullOrWhiteSpace(keyName)) {
            throw new AssertionError((Object)SHARED_ACCESS_KEY_NAME);
        }
        String key = this.mConnectionData.get(SHARED_ACCESS_KEY);
        if (Utils.isNullOrWhiteSpace(key)) {
            throw new AssertionError((Object)SHARED_ACCESS_KEY);
        }
        try {
            url = URLEncoder.encode(url, UTF8_ENCODING).toLowerCase(Locale.ENGLISH);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        Calendar expireDate = Calendar.getInstance(TimeZone.getTimeZone(UTC_TIME_ZONE));
        expireDate.add(12, 5);
        long expires = expireDate.getTimeInMillis() / 1000L;
        String toSign = url + '\n' + expires;
        byte[] bytesToSign = toSign.getBytes();
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        SecretKeySpec secret = new SecretKeySpec(key.getBytes(), mac.getAlgorithm());
        mac.init(secret);
        byte[] signedHash = mac.doFinal(bytesToSign);
        String base64Signature = Base64.encodeToString((byte[])signedHash, (int)0);
        base64Signature = base64Signature.trim();
        try {
            base64Signature = URLEncoder.encode(base64Signature, UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String token = "SharedAccessSignature sr=" + url + "&sig=" + base64Signature + "&se=" + expires + "&skn=" + keyName;
        return token;
    }

    private String getUserAgent() {
        String userAgent = String.format("NOTIFICATIONHUBS/%s (api-origin=%s; os=%s; os_version=%s;)", "2014-09", PnsSpecificRegistrationFactory.getInstance().getAPIOrigin(), "Android", Build.VERSION.RELEASE);
        return userAgent;
    }
}

