// Generated by delombok at Thu Feb 27 18:19:39 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Map;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotNull;

/**
 * Object containing parameters for On-Behalf-Of flow. Can be used as parameter to
 * {@link ConfidentialClientApplication#acquireToken(OnBehalfOfParameters)}
 * <p>
 * For more details, see https://aka.ms/msal4j-on-behalf-of
 */
public class OnBehalfOfParameters implements IAcquireTokenParameters {
    @NonNull
    private Set<String> scopes;
    /**
     * Indicates whether the request should skip looking into the token cache. Be default it is
     * set to false.
     */
    private Boolean skipCache;
    @NonNull
    private IUserAssertion userAssertion;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Adds additional parameters to the token request
     */
    private Map<String, String> extraQueryParameters;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;

    private static OnBehalfOfParametersBuilder builder() {
        return new OnBehalfOfParametersBuilder();
    }

    /**
     * Builder for {@link OnBehalfOfParameters}
     *
     * @param scopes        scopes application is requesting access to
     * @param userAssertion {@link UserAssertion} created from access token received
     * @return builder that can be used to construct OnBehalfOfParameters
     */
    public static OnBehalfOfParametersBuilder builder(Set<String> scopes, UserAssertion userAssertion) {
        validateNotNull("scopes", scopes);
        return builder().scopes(scopes).userAssertion(userAssertion);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$skipCache() {
        return false;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class OnBehalfOfParametersBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean skipCache$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean skipCache$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IUserAssertion userAssertion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraQueryParameters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tenant;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        OnBehalfOfParametersBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OnBehalfOfParameters.OnBehalfOfParametersBuilder scopes(@NonNull final Set<String> scopes) {
            if (scopes == null) {
                throw new java.lang.NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        /**
         * Indicates whether the request should skip looking into the token cache. Be default it is
         * set to false.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OnBehalfOfParameters.OnBehalfOfParametersBuilder skipCache(final Boolean skipCache) {
            this.skipCache$value = skipCache;
            skipCache$set = true;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OnBehalfOfParameters.OnBehalfOfParametersBuilder userAssertion(@NonNull final IUserAssertion userAssertion) {
            if (userAssertion == null) {
                throw new java.lang.NullPointerException("userAssertion is marked non-null but is null");
            }
            this.userAssertion = userAssertion;
            return this;
        }

        /**
         * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OnBehalfOfParameters.OnBehalfOfParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        /**
         * Adds additional headers to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OnBehalfOfParameters.OnBehalfOfParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        /**
         * Adds additional parameters to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OnBehalfOfParameters.OnBehalfOfParametersBuilder extraQueryParameters(final Map<String, String> extraQueryParameters) {
            this.extraQueryParameters = extraQueryParameters;
            return this;
        }

        /**
         * Overrides the tenant value in the authority URL for this request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OnBehalfOfParameters.OnBehalfOfParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OnBehalfOfParameters build() {
            Boolean skipCache$value = this.skipCache$value;
            if (!this.skipCache$set) skipCache$value = OnBehalfOfParameters.$default$skipCache();
            return new OnBehalfOfParameters(this.scopes, skipCache$value, this.userAssertion, this.claims, this.extraHttpHeaders, this.extraQueryParameters, this.tenant);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "OnBehalfOfParameters.OnBehalfOfParametersBuilder(scopes=" + this.scopes + ", skipCache$value=" + this.skipCache$value + ", userAssertion=" + this.userAssertion + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ")";
        }
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Indicates whether the request should skip looking into the token cache. Be default it is
     * set to false.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean skipCache() {
        return this.skipCache;
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IUserAssertion userAssertion() {
        return this.userAssertion;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Adds additional parameters to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String tenant() {
        return this.tenant;
    }

    /**
     * Creates a new {@code OnBehalfOfParameters} instance.
     *
     * @param scopes
     * @param skipCache Indicates whether the request should skip looking into the token cache. Be default it is
     * set to false.
     * @param userAssertion
     * @param claims Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     * @param extraHttpHeaders Adds additional headers to the token request
     * @param extraQueryParameters Adds additional parameters to the token request
     * @param tenant Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private OnBehalfOfParameters(@NonNull final Set<String> scopes, final Boolean skipCache, @NonNull final IUserAssertion userAssertion, final ClaimsRequest claims, final Map<String, String> extraHttpHeaders, final Map<String, String> extraQueryParameters, final String tenant) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked non-null but is null");
        }
        if (userAssertion == null) {
            throw new java.lang.NullPointerException("userAssertion is marked non-null but is null");
        }
        this.scopes = scopes;
        this.skipCache = skipCache;
        this.userAssertion = userAssertion;
        this.claims = claims;
        this.extraHttpHeaders = extraHttpHeaders;
        this.extraQueryParameters = extraQueryParameters;
        this.tenant = tenant;
    }
}
