// Generated by delombok at Thu Feb 27 18:19:39 UTC 2025
package com.microsoft.aad.msal4j;

/**
 * Exception type thrown when service returns throttling instruction:
 * Retry-After header, 429 or 5xx statuses.
 */
public class MsalThrottlingException extends MsalServiceException {
    /**
     * how long to wait before repeating request
     */
    private long retryInMs;

    /**
     * Constructor for MsalThrottlingException class
     *
     * @param retryInMs
     */
    public MsalThrottlingException(long retryInMs) {
        super("Request was throttled according to instructions from STS. Retry in " + retryInMs + " ms.", AuthenticationErrorCode.THROTTLED_REQUEST);
        this.retryInMs = retryInMs;
    }

    /**
     * how long to wait before repeating request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public long retryInMs() {
        return this.retryInMs;
    }
}
