// Generated by delombok at Thu Feb 27 18:19:39 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import org.slf4j.LoggerFactory;
import java.util.concurrent.CompletableFuture;

/**
 * Class to be used to acquire tokens for managed identity.
 * For details see {@link IManagedIdentityApplication}
 * <p>
 * Conditionally thread-safe
 */
public class ManagedIdentityApplication extends AbstractApplicationBase implements IManagedIdentityApplication {
    private final ManagedIdentityId managedIdentityId;
    static TokenCache sharedTokenCache = new TokenCache();
    //Deprecated the field in favor of the static getManagedIdentitySource method
    @Deprecated
    ManagedIdentitySourceType managedIdentitySource = ManagedIdentityClient.getManagedIdentitySource();
    static IEnvironmentVariables environmentVariables;

    static void setEnvironmentVariables(IEnvironmentVariables environmentVariables) {
        ManagedIdentityApplication.environmentVariables = environmentVariables;
    }

    private ManagedIdentityApplication(Builder builder) {
        super(builder);
        super.tokenCache = sharedTokenCache;
        super.serviceBundle = new ServiceBundle(builder.executorService, new TelemetryManager(telemetryConsumer, builder.onlySendFailureTelemetry), new HttpHelperManagedIdentity(builder.httpClient == null ? new DefaultHttpClient(builder.proxy, builder.sslSocketFactory, builder.connectTimeoutForDefaultHttpClient, builder.readTimeoutForDefaultHttpClient) : builder.httpClient));
        log = LoggerFactory.getLogger(ManagedIdentityApplication.class);
        this.managedIdentityId = builder.managedIdentityId;
        this.tenant = Constants.MANAGED_IDENTITY_DEFAULT_TENTANT;
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireTokenForManagedIdentity(ManagedIdentityParameters managedIdentityParameters) throws Exception {
        RequestContext requestContext = new RequestContext(this, managedIdentityId.getIdType() == ManagedIdentityIdType.SYSTEM_ASSIGNED ? PublicApi.ACQUIRE_TOKEN_BY_SYSTEM_ASSIGNED_MANAGED_IDENTITY : PublicApi.ACQUIRE_TOKEN_BY_USER_ASSIGNED_MANAGED_IDENTITY, managedIdentityParameters);
        ManagedIdentityRequest managedIdentityRequest = new ManagedIdentityRequest(this, requestContext);
        return this.executeRequest(managedIdentityRequest);
    }

    /**
     * Creates instance of Builder of ManagedIdentityApplication
     *
     * @param managedIdentityId ManagedIdentityId to specify if System Assigned or User Assigned
     *                          and provide id if it is user assigned.
     * @return instance of Builder of ManagedIdentityApplication
     */
    public static Builder builder(ManagedIdentityId managedIdentityId) {
        return new Builder(managedIdentityId);
    }


    public static class Builder extends AbstractApplicationBase.Builder<Builder> {
        private String resource;
        private ManagedIdentityId managedIdentityId;

        private Builder(ManagedIdentityId managedIdentityId) {
            super(managedIdentityId.getIdType() == ManagedIdentityIdType.SYSTEM_ASSIGNED ? "system_assigned_managed_identity" : managedIdentityId.getUserAssignedId());
            this.managedIdentityId = managedIdentityId;
        }

        public Builder resource(String resource) {
            this.resource = resource;
            return self();
        }

        @Override
        public ManagedIdentityApplication build() {
            return new ManagedIdentityApplication(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    /**
     * Returns a {@link ManagedIdentitySourceType} value, which is based primarily on environment variables set on the system.
     *
     * @return ManagedIdentitySourceType enum for source type
     */
    public static ManagedIdentitySourceType getManagedIdentitySource() {
        return ManagedIdentityClient.getManagedIdentitySource();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ManagedIdentityId getManagedIdentityId() {
        return this.managedIdentityId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static TokenCache getSharedTokenCache() {
        return ManagedIdentityApplication.sharedTokenCache;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    static IEnvironmentVariables getEnvironmentVariables() {
        return ManagedIdentityApplication.environmentVariables;
    }
}
