/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.ClaimsRequest;
import com.microsoft.aad.msal4j.IAcquireTokenParameters;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public class AuthorizationCodeParameters
implements IAcquireTokenParameters {
    @NonNull
    private String authorizationCode;
    @NonNull
    private URI redirectUri;
    private Set<String> scopes;
    private ClaimsRequest claims;
    private String codeVerifier;
    private Map<String, String> extraHttpHeaders;
    private Map<String, String> extraQueryParameters;
    private String tenant;

    private static AuthorizationCodeParametersBuilder builder() {
        return new AuthorizationCodeParametersBuilder();
    }

    public static AuthorizationCodeParametersBuilder builder(String authorizationCode, URI redirectUri) {
        ParameterValidationUtils.validateNotBlank("authorizationCode", authorizationCode);
        return AuthorizationCodeParameters.builder().authorizationCode(authorizationCode).redirectUri(redirectUri);
    }

    @NonNull
    @Generated
    public String authorizationCode() {
        return this.authorizationCode;
    }

    @NonNull
    @Generated
    public URI redirectUri() {
        return this.redirectUri;
    }

    @Override
    @Generated
    public Set<String> scopes() {
        return this.scopes;
    }

    @Override
    @Generated
    public ClaimsRequest claims() {
        return this.claims;
    }

    @Generated
    public String codeVerifier() {
        return this.codeVerifier;
    }

    @Override
    @Generated
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    @Override
    @Generated
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    @Override
    @Generated
    public String tenant() {
        return this.tenant;
    }

    @Generated
    private AuthorizationCodeParameters(@NonNull String authorizationCode, @NonNull URI redirectUri, Set<String> scopes, ClaimsRequest claims, String codeVerifier, Map<String, String> extraHttpHeaders, Map<String, String> extraQueryParameters, String tenant) {
        if (authorizationCode == null) {
            throw new NullPointerException("authorizationCode is marked non-null but is null");
        }
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked non-null but is null");
        }
        this.authorizationCode = authorizationCode;
        this.redirectUri = redirectUri;
        this.scopes = scopes;
        this.claims = claims;
        this.codeVerifier = codeVerifier;
        this.extraHttpHeaders = extraHttpHeaders;
        this.extraQueryParameters = extraQueryParameters;
        this.tenant = tenant;
    }

    @Generated
    public static class AuthorizationCodeParametersBuilder {
        @Generated
        private String authorizationCode;
        @Generated
        private URI redirectUri;
        @Generated
        private Set<String> scopes;
        @Generated
        private ClaimsRequest claims;
        @Generated
        private String codeVerifier;
        @Generated
        private Map<String, String> extraHttpHeaders;
        @Generated
        private Map<String, String> extraQueryParameters;
        @Generated
        private String tenant;

        @Generated
        AuthorizationCodeParametersBuilder() {
        }

        @Generated
        public AuthorizationCodeParametersBuilder authorizationCode(@NonNull String authorizationCode) {
            if (authorizationCode == null) {
                throw new NullPointerException("authorizationCode is marked non-null but is null");
            }
            this.authorizationCode = authorizationCode;
            return this;
        }

        @Generated
        public AuthorizationCodeParametersBuilder redirectUri(@NonNull URI redirectUri) {
            if (redirectUri == null) {
                throw new NullPointerException("redirectUri is marked non-null but is null");
            }
            this.redirectUri = redirectUri;
            return this;
        }

        @Generated
        public AuthorizationCodeParametersBuilder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @Generated
        public AuthorizationCodeParametersBuilder claims(ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        @Generated
        public AuthorizationCodeParametersBuilder codeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
            return this;
        }

        @Generated
        public AuthorizationCodeParametersBuilder extraHttpHeaders(Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        @Generated
        public AuthorizationCodeParametersBuilder extraQueryParameters(Map<String, String> extraQueryParameters) {
            this.extraQueryParameters = extraQueryParameters;
            return this;
        }

        @Generated
        public AuthorizationCodeParametersBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        @Generated
        public AuthorizationCodeParameters build() {
            return new AuthorizationCodeParameters(this.authorizationCode, this.redirectUri, this.scopes, this.claims, this.codeVerifier, this.extraHttpHeaders, this.extraQueryParameters, this.tenant);
        }

        @Generated
        public String toString() {
            return "AuthorizationCodeParameters.AuthorizationCodeParametersBuilder(authorizationCode=" + this.authorizationCode + ", redirectUri=" + this.redirectUri + ", scopes=" + this.scopes + ", claims=" + this.claims + ", codeVerifier=" + this.codeVerifier + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ")";
        }
    }
}

