// Generated by delombok at Fri Feb 07 19:13:00 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import java.util.Map;
import java.util.Set;

/**
 * Object containing parameters for managed identity flow. Can be used as parameter to
 * {@link ManagedIdentityApplication#acquireTokenForManagedIdentity(ManagedIdentityParameters)}
 */
public class ManagedIdentityParameters implements IAcquireTokenParameters {
    String resource;
    boolean forceRefresh;

    @Override
    public Set<String> scopes() {
        return null;
    }

    @Override
    public ClaimsRequest claims() {
        return null;
    }

    @Override
    public Map<String, String> extraHttpHeaders() {
        return null;
    }

    @Override
    public String tenant() {
        return Constants.MANAGED_IDENTITY_DEFAULT_TENTANT;
    }

    @Override
    public Map<String, String> extraQueryParameters() {
        return null;
    }

    private static ManagedIdentityParametersBuilder builder() {
        return new ManagedIdentityParametersBuilder();
    }

    /**
     * Builder for {@link ManagedIdentityParameters}
     * @param resource scopes application is requesting access to
     * @return builder that can be used to construct ManagedIdentityParameters
     */
    public static ManagedIdentityParametersBuilder builder(String resource) {
        return builder().resource(resource);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class ManagedIdentityParametersBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String resource;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean forceRefresh;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        ManagedIdentityParametersBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ManagedIdentityParameters.ManagedIdentityParametersBuilder resource(final String resource) {
            this.resource = resource;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ManagedIdentityParameters.ManagedIdentityParametersBuilder forceRefresh(final boolean forceRefresh) {
            this.forceRefresh = forceRefresh;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ManagedIdentityParameters build() {
            return new ManagedIdentityParameters(this.resource, this.forceRefresh);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ManagedIdentityParameters.ManagedIdentityParametersBuilder(resource=" + this.resource + ", forceRefresh=" + this.forceRefresh + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean forceRefresh() {
        return this.forceRefresh;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private ManagedIdentityParameters(final String resource, final boolean forceRefresh) {
        this.resource = resource;
        this.forceRefresh = forceRefresh;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String resource() {
        return this.resource;
    }
}
