// Generated by delombok at Fri Feb 07 19:13:00 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.NonNull;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotNull;

/**
 * Object containing parameters for interactive requests. Can be used as parameter to
 * {@link PublicClientApplication#acquireToken(InteractiveRequestParameters)}.
 * <p>
 * For more details, see https://aka.ms/msal4j-interactive-request.
 */
public class InteractiveRequestParameters implements IAcquireTokenParameters {
    /**
     * Redirect URI where MSAL will listen to for the authorization code returned by Azure AD.
     * Should be a loopback address with a port specified (for example, http://localhost:3671). If no
     * port is specified, MSAL will find an open port. For more information, see
     * https://aka.ms/msal4j-interactive-request.
     */
    @NonNull
    private URI redirectUri;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Scopes that the application is requesting access to and the user will consent to.
     */
    private Set<String> scopes;
    /**
     * Indicate the type of user interaction that is required.
     */
    private Prompt prompt;
    /**
     * Can be used to pre-fill the username/email address field of the sign-in page for the user,
     * if you know the username/email address ahead of time. Often apps use this parameter during
     * re-authentication, having already extracted the username from a previous sign-in using the
     * preferred_username claim.
     */
    private String loginHint;
    /**
     * Provides a hint about the tenant or domain that the user should use to sign in. The value
     * of the domain hint is a registered domain for the tenant.
     */
    private String domainHint;
    /**
     * Sets {@link SystemBrowserOptions} to be used by the PublicClientApplication
     */
    private SystemBrowserOptions systemBrowserOptions;
    private String claimsChallenge;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Adds additional query parameters to the token request
     */
    private Map<String, String> extraQueryParameters;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;
    /**
     * The amount of time in seconds that the library will wait for an authentication result. 120 seconds is the default timeout,
     * unless overridden here with some other positive integer
     *
     * If this timeout is set to 0 or less it will be ignored, and the library will use a 1 second timeout instead
     */
    private int httpPollingTimeoutInSeconds;
    /**
     * If set to true, the authorization result will contain the authority for the user's home cloud, and this authority
     * will be used for the token request instead of the authority set in the application.
     */
    private boolean instanceAware;
    /**
     * The parent window handle used to open UI elements with the correct parent
     *
     *
     * For browser scenarios and Windows console applications, this value should not need to be set
     *
     * For Windows console applications, MSAL Java will attempt to discover the console's window handle if this parameter is not set
     *
     * For scenarios where MSAL Java is responsible for opening UI elements (such as when using MSALRuntime), this parameter is required and an exception will be thrown if not set
     */
    private long windowHandle;
    private PopParameters proofOfPossession;

    private static InteractiveRequestParametersBuilder builder() {
        return new InteractiveRequestParametersBuilder();
    }

    public static InteractiveRequestParametersBuilder builder(URI redirectUri) {
        validateNotNull("redirect_uri", redirectUri);
        return builder().redirectUri(redirectUri);
    }

    //This Builder class is used to override Lombok's default setter behavior for any fields defined in it
    public static class InteractiveRequestParametersBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private URI redirectUri;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Prompt prompt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String loginHint;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String domainHint;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SystemBrowserOptions systemBrowserOptions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String claimsChallenge;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraQueryParameters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tenant;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean httpPollingTimeoutInSeconds$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int httpPollingTimeoutInSeconds$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean instanceAware;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private long windowHandle;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PopParameters proofOfPossession;

        /**
         * Sets the PopParameters for this request, allowing the request to retrieve proof-of-possession tokens rather than bearer tokens
         *
         * For more information, see {@link PopParameters} and https://aka.ms/msal4j-pop
         *
         * @param httpMethod a valid HTTP method, such as "GET" or "POST"
         * @param uri the URI on the downstream protected API which the application is trying to access, e.g. https://graph.microsoft.com/beta/me/profile
         * @param nonce a string obtained by calling the resource (e.g. Microsoft Graph) un-authenticated and parsing the WWW-Authenticate header associated with pop authentication scheme and extracting the nonce parameter, or, on subsequent calls, by parsing the Autheticate-Info header and extracting the nextnonce parameter.
         */
        public InteractiveRequestParametersBuilder proofOfPossession(HttpMethod httpMethod, URI uri, String nonce) {
            this.proofOfPossession = new PopParameters(httpMethod, uri, nonce);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        InteractiveRequestParametersBuilder() {
        }

        /**
         * Redirect URI where MSAL will listen to for the authorization code returned by Azure AD.
         * Should be a loopback address with a port specified (for example, http://localhost:3671). If no
         * port is specified, MSAL will find an open port. For more information, see
         * https://aka.ms/msal4j-interactive-request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder redirectUri(@NonNull final URI redirectUri) {
            if (redirectUri == null) {
                throw new java.lang.NullPointerException("redirectUri is marked non-null but is null");
            }
            this.redirectUri = redirectUri;
            return this;
        }

        /**
         * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        /**
         * Scopes that the application is requesting access to and the user will consent to.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        /**
         * Indicate the type of user interaction that is required.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder prompt(final Prompt prompt) {
            this.prompt = prompt;
            return this;
        }

        /**
         * Can be used to pre-fill the username/email address field of the sign-in page for the user,
         * if you know the username/email address ahead of time. Often apps use this parameter during
         * re-authentication, having already extracted the username from a previous sign-in using the
         * preferred_username claim.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder loginHint(final String loginHint) {
            this.loginHint = loginHint;
            return this;
        }

        /**
         * Provides a hint about the tenant or domain that the user should use to sign in. The value
         * of the domain hint is a registered domain for the tenant.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder domainHint(final String domainHint) {
            this.domainHint = domainHint;
            return this;
        }

        /**
         * Sets {@link SystemBrowserOptions} to be used by the PublicClientApplication
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder systemBrowserOptions(final SystemBrowserOptions systemBrowserOptions) {
            this.systemBrowserOptions = systemBrowserOptions;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder claimsChallenge(final String claimsChallenge) {
            this.claimsChallenge = claimsChallenge;
            return this;
        }

        /**
         * Adds additional headers to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        /**
         * Adds additional query parameters to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder extraQueryParameters(final Map<String, String> extraQueryParameters) {
            this.extraQueryParameters = extraQueryParameters;
            return this;
        }

        /**
         * Overrides the tenant value in the authority URL for this request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        /**
         * The amount of time in seconds that the library will wait for an authentication result. 120 seconds is the default timeout,
         * unless overridden here with some other positive integer
         *
         * If this timeout is set to 0 or less it will be ignored, and the library will use a 1 second timeout instead
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder httpPollingTimeoutInSeconds(final int httpPollingTimeoutInSeconds) {
            this.httpPollingTimeoutInSeconds$value = httpPollingTimeoutInSeconds;
            httpPollingTimeoutInSeconds$set = true;
            return this;
        }

        /**
         * If set to true, the authorization result will contain the authority for the user's home cloud, and this authority
         * will be used for the token request instead of the authority set in the application.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder instanceAware(final boolean instanceAware) {
            this.instanceAware = instanceAware;
            return this;
        }

        /**
         * The parent window handle used to open UI elements with the correct parent
         *
         *
         * For browser scenarios and Windows console applications, this value should not need to be set
         *
         * For Windows console applications, MSAL Java will attempt to discover the console's window handle if this parameter is not set
         *
         * For scenarios where MSAL Java is responsible for opening UI elements (such as when using MSALRuntime), this parameter is required and an exception will be thrown if not set
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters.InteractiveRequestParametersBuilder windowHandle(final long windowHandle) {
            this.windowHandle = windowHandle;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public InteractiveRequestParameters build() {
            int httpPollingTimeoutInSeconds$value = this.httpPollingTimeoutInSeconds$value;
            if (!this.httpPollingTimeoutInSeconds$set) httpPollingTimeoutInSeconds$value = InteractiveRequestParameters.$default$httpPollingTimeoutInSeconds();
            return new InteractiveRequestParameters(this.redirectUri, this.claims, this.scopes, this.prompt, this.loginHint, this.domainHint, this.systemBrowserOptions, this.claimsChallenge, this.extraHttpHeaders, this.extraQueryParameters, this.tenant, httpPollingTimeoutInSeconds$value, this.instanceAware, this.windowHandle, this.proofOfPossession);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "InteractiveRequestParameters.InteractiveRequestParametersBuilder(redirectUri=" + this.redirectUri + ", claims=" + this.claims + ", scopes=" + this.scopes + ", prompt=" + this.prompt + ", loginHint=" + this.loginHint + ", domainHint=" + this.domainHint + ", systemBrowserOptions=" + this.systemBrowserOptions + ", claimsChallenge=" + this.claimsChallenge + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ", httpPollingTimeoutInSeconds$value=" + this.httpPollingTimeoutInSeconds$value + ", instanceAware=" + this.instanceAware + ", windowHandle=" + this.windowHandle + ", proofOfPossession=" + this.proofOfPossession + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static int $default$httpPollingTimeoutInSeconds() {
        return 120;
    }

    /**
     * Redirect URI where MSAL will listen to for the authorization code returned by Azure AD.
     * Should be a loopback address with a port specified (for example, http://localhost:3671). If no
     * port is specified, MSAL will find an open port. For more information, see
     * https://aka.ms/msal4j-interactive-request.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public URI redirectUri() {
        return this.redirectUri;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Scopes that the application is requesting access to and the user will consent to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Indicate the type of user interaction that is required.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Prompt prompt() {
        return this.prompt;
    }

    /**
     * Can be used to pre-fill the username/email address field of the sign-in page for the user,
     * if you know the username/email address ahead of time. Often apps use this parameter during
     * re-authentication, having already extracted the username from a previous sign-in using the
     * preferred_username claim.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String loginHint() {
        return this.loginHint;
    }

    /**
     * Provides a hint about the tenant or domain that the user should use to sign in. The value
     * of the domain hint is a registered domain for the tenant.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String domainHint() {
        return this.domainHint;
    }

    /**
     * Sets {@link SystemBrowserOptions} to be used by the PublicClientApplication
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SystemBrowserOptions systemBrowserOptions() {
        return this.systemBrowserOptions;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String claimsChallenge() {
        return this.claimsChallenge;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Adds additional query parameters to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String tenant() {
        return this.tenant;
    }

    /**
     * The amount of time in seconds that the library will wait for an authentication result. 120 seconds is the default timeout,
     * unless overridden here with some other positive integer
     *
     * If this timeout is set to 0 or less it will be ignored, and the library will use a 1 second timeout instead
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int httpPollingTimeoutInSeconds() {
        return this.httpPollingTimeoutInSeconds;
    }

    /**
     * If set to true, the authorization result will contain the authority for the user's home cloud, and this authority
     * will be used for the token request instead of the authority set in the application.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean instanceAware() {
        return this.instanceAware;
    }

    /**
     * The parent window handle used to open UI elements with the correct parent
     *
     *
     * For browser scenarios and Windows console applications, this value should not need to be set
     *
     * For Windows console applications, MSAL Java will attempt to discover the console's window handle if this parameter is not set
     *
     * For scenarios where MSAL Java is responsible for opening UI elements (such as when using MSALRuntime), this parameter is required and an exception will be thrown if not set
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public long windowHandle() {
        return this.windowHandle;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PopParameters proofOfPossession() {
        return this.proofOfPossession;
    }

    /**
     * Creates a new {@code InteractiveRequestParameters} instance.
     *
     * @param redirectUri Redirect URI where MSAL will listen to for the authorization code returned by Azure AD.
     * Should be a loopback address with a port specified (for example, http://localhost:3671). If no
     * port is specified, MSAL will find an open port. For more information, see
     * https://aka.ms/msal4j-interactive-request.
     * @param claims Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     * @param scopes Scopes that the application is requesting access to and the user will consent to.
     * @param prompt Indicate the type of user interaction that is required.
     * @param loginHint Can be used to pre-fill the username/email address field of the sign-in page for the user,
     * if you know the username/email address ahead of time. Often apps use this parameter during
     * re-authentication, having already extracted the username from a previous sign-in using the
     * preferred_username claim.
     * @param domainHint Provides a hint about the tenant or domain that the user should use to sign in. The value
     * of the domain hint is a registered domain for the tenant.
     * @param systemBrowserOptions Sets {@link SystemBrowserOptions} to be used by the PublicClientApplication
     * @param claimsChallenge
     * @param extraHttpHeaders Adds additional headers to the token request
     * @param extraQueryParameters Adds additional query parameters to the token request
     * @param tenant Overrides the tenant value in the authority URL for this request
     * @param httpPollingTimeoutInSeconds The amount of time in seconds that the library will wait for an authentication result. 120 seconds is the default timeout,
     * unless overridden here with some other positive integer
     *
     * If this timeout is set to 0 or less it will be ignored, and the library will use a 1 second timeout instead
     * @param instanceAware If set to true, the authorization result will contain the authority for the user's home cloud, and this authority
     * will be used for the token request instead of the authority set in the application.
     * @param windowHandle The parent window handle used to open UI elements with the correct parent
     *
     *
     * For browser scenarios and Windows console applications, this value should not need to be set
     *
     * For Windows console applications, MSAL Java will attempt to discover the console's window handle if this parameter is not set
     *
     * For scenarios where MSAL Java is responsible for opening UI elements (such as when using MSALRuntime), this parameter is required and an exception will be thrown if not set
     * @param proofOfPossession
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private InteractiveRequestParameters(@NonNull final URI redirectUri, final ClaimsRequest claims, final Set<String> scopes, final Prompt prompt, final String loginHint, final String domainHint, final SystemBrowserOptions systemBrowserOptions, final String claimsChallenge, final Map<String, String> extraHttpHeaders, final Map<String, String> extraQueryParameters, final String tenant, final int httpPollingTimeoutInSeconds, final boolean instanceAware, final long windowHandle, final PopParameters proofOfPossession) {
        if (redirectUri == null) {
            throw new java.lang.NullPointerException("redirectUri is marked non-null but is null");
        }
        this.redirectUri = redirectUri;
        this.claims = claims;
        this.scopes = scopes;
        this.prompt = prompt;
        this.loginHint = loginHint;
        this.domainHint = domainHint;
        this.systemBrowserOptions = systemBrowserOptions;
        this.claimsChallenge = claimsChallenge;
        this.extraHttpHeaders = extraHttpHeaders;
        this.extraQueryParameters = extraQueryParameters;
        this.tenant = tenant;
        this.httpPollingTimeoutInSeconds = httpPollingTimeoutInSeconds;
        this.instanceAware = instanceAware;
        this.windowHandle = windowHandle;
        this.proofOfPossession = proofOfPossession;
    }

    /**
     * Redirect URI where MSAL will listen to for the authorization code returned by Azure AD.
     * Should be a loopback address with a port specified (for example, http://localhost:3671). If no
     * port is specified, MSAL will find an open port. For more information, see
     * https://aka.ms/msal4j-interactive-request.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    InteractiveRequestParameters redirectUri(@NonNull final URI redirectUri) {
        if (redirectUri == null) {
            throw new java.lang.NullPointerException("redirectUri is marked non-null but is null");
        }
        this.redirectUri = redirectUri;
        return this;
    }
}
