// Generated by delombok at Fri Feb 07 19:13:00 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Map;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotNull;

/**
 * Object containing parameters for client credential flow. Can be used as parameter to
 * {@link ConfidentialClientApplication#acquireToken(ClientCredentialParameters)}
 */
public class ClientCredentialParameters implements IAcquireTokenParameters {
    /**
     * Scopes for which the application is requesting access to.
     */
    @NonNull
    private Set<String> scopes;
    /**
     * Indicates whether the request should skip looking into the token cache. Be default it is
     * set to false.
     */
    private Boolean skipCache;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Adds additional query parameters to the token request
     */
    private Map<String, String> extraQueryParameters;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;
    /**
     * Overrides the client credentials for this request
     */
    private IClientCredential clientCredential;

    private static ClientCredentialParametersBuilder builder() {
        return new ClientCredentialParametersBuilder();
    }

    /**
     * Builder for {@link ClientCredentialParameters}
     *
     * @param scopes scopes application is requesting access to
     * @return builder that can be used to construct ClientCredentialParameters
     */
    public static ClientCredentialParametersBuilder builder(Set<String> scopes) {
        validateNotNull("scopes", scopes);
        return builder().scopes(scopes);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$skipCache() {
        return false;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class ClientCredentialParametersBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean skipCache$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean skipCache$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraQueryParameters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tenant;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IClientCredential clientCredential;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        ClientCredentialParametersBuilder() {
        }

        /**
         * Scopes for which the application is requesting access to.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ClientCredentialParameters.ClientCredentialParametersBuilder scopes(@NonNull final Set<String> scopes) {
            if (scopes == null) {
                throw new java.lang.NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        /**
         * Indicates whether the request should skip looking into the token cache. Be default it is
         * set to false.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ClientCredentialParameters.ClientCredentialParametersBuilder skipCache(final Boolean skipCache) {
            this.skipCache$value = skipCache;
            skipCache$set = true;
            return this;
        }

        /**
         * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ClientCredentialParameters.ClientCredentialParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        /**
         * Adds additional headers to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ClientCredentialParameters.ClientCredentialParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        /**
         * Adds additional query parameters to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ClientCredentialParameters.ClientCredentialParametersBuilder extraQueryParameters(final Map<String, String> extraQueryParameters) {
            this.extraQueryParameters = extraQueryParameters;
            return this;
        }

        /**
         * Overrides the tenant value in the authority URL for this request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ClientCredentialParameters.ClientCredentialParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        /**
         * Overrides the client credentials for this request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ClientCredentialParameters.ClientCredentialParametersBuilder clientCredential(final IClientCredential clientCredential) {
            this.clientCredential = clientCredential;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ClientCredentialParameters build() {
            Boolean skipCache$value = this.skipCache$value;
            if (!this.skipCache$set) skipCache$value = ClientCredentialParameters.$default$skipCache();
            return new ClientCredentialParameters(this.scopes, skipCache$value, this.claims, this.extraHttpHeaders, this.extraQueryParameters, this.tenant, this.clientCredential);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ClientCredentialParameters.ClientCredentialParametersBuilder(scopes=" + this.scopes + ", skipCache$value=" + this.skipCache$value + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ", clientCredential=" + this.clientCredential + ")";
        }
    }

    /**
     * Scopes for which the application is requesting access to.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Indicates whether the request should skip looking into the token cache. Be default it is
     * set to false.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean skipCache() {
        return this.skipCache;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Adds additional query parameters to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String tenant() {
        return this.tenant;
    }

    /**
     * Overrides the client credentials for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IClientCredential clientCredential() {
        return this.clientCredential;
    }

    /**
     * Creates a new {@code ClientCredentialParameters} instance.
     *
     * @param scopes Scopes for which the application is requesting access to.
     * @param skipCache Indicates whether the request should skip looking into the token cache. Be default it is
     * set to false.
     * @param claims Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     * @param extraHttpHeaders Adds additional headers to the token request
     * @param extraQueryParameters Adds additional query parameters to the token request
     * @param tenant Overrides the tenant value in the authority URL for this request
     * @param clientCredential Overrides the client credentials for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private ClientCredentialParameters(@NonNull final Set<String> scopes, final Boolean skipCache, final ClaimsRequest claims, final Map<String, String> extraHttpHeaders, final Map<String, String> extraQueryParameters, final String tenant, final IClientCredential clientCredential) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked non-null but is null");
        }
        this.scopes = scopes;
        this.skipCache = skipCache;
        this.claims = claims;
        this.extraHttpHeaders = extraHttpHeaders;
        this.extraQueryParameters = extraQueryParameters;
        this.tenant = tenant;
        this.clientCredential = clientCredential;
    }
}
