// Generated by delombok at Fri Feb 07 19:13:00 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import java.io.Serializable;

/**
 * Contains metadata and additional context for the contents of an AuthenticationResult
 */
public class AuthenticationResultMetadata implements Serializable {
    /**
     * The source of the tokens in the {@link AuthenticationResult}, see {@link TokenSource} for possible values
     */
    private TokenSource tokenSource;
    /**
     * When the token should be proactively refreshed. May be null or 0 if proactive refresh is not used
     */
    private Long refreshOn;
    /**
     * Specifies the reason for refreshing the access token, see {@link CacheRefreshReason} for possible values. Will be {@link CacheRefreshReason#NOT_APPLICABLE} if the token was returned from the cache or if the API used to fetch the token does not attempt to read the cache.
     */
    private CacheRefreshReason cacheRefreshReason;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static CacheRefreshReason $default$cacheRefreshReason() {
        return CacheRefreshReason.NOT_APPLICABLE;
    }

    /**
     * Creates a new {@code AuthenticationResultMetadata} instance.
     *
     * @param tokenSource The source of the tokens in the {@link AuthenticationResult}, see {@link TokenSource} for possible values
     * @param refreshOn When the token should be proactively refreshed. May be null or 0 if proactive refresh is not used
     * @param cacheRefreshReason Specifies the reason for refreshing the access token, see {@link CacheRefreshReason} for possible values. Will be {@link CacheRefreshReason#NOT_APPLICABLE} if the token was returned from the cache or if the API used to fetch the token does not attempt to read the cache.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    AuthenticationResultMetadata(final TokenSource tokenSource, final Long refreshOn, final CacheRefreshReason cacheRefreshReason) {
        this.tokenSource = tokenSource;
        this.refreshOn = refreshOn;
        this.cacheRefreshReason = cacheRefreshReason;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class AuthenticationResultMetadataBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private TokenSource tokenSource;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long refreshOn;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean cacheRefreshReason$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CacheRefreshReason cacheRefreshReason$value;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        AuthenticationResultMetadataBuilder() {
        }

        /**
         * The source of the tokens in the {@link AuthenticationResult}, see {@link TokenSource} for possible values
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthenticationResultMetadata.AuthenticationResultMetadataBuilder tokenSource(final TokenSource tokenSource) {
            this.tokenSource = tokenSource;
            return this;
        }

        /**
         * When the token should be proactively refreshed. May be null or 0 if proactive refresh is not used
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthenticationResultMetadata.AuthenticationResultMetadataBuilder refreshOn(final Long refreshOn) {
            this.refreshOn = refreshOn;
            return this;
        }

        /**
         * Specifies the reason for refreshing the access token, see {@link CacheRefreshReason} for possible values. Will be {@link CacheRefreshReason#NOT_APPLICABLE} if the token was returned from the cache or if the API used to fetch the token does not attempt to read the cache.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthenticationResultMetadata.AuthenticationResultMetadataBuilder cacheRefreshReason(final CacheRefreshReason cacheRefreshReason) {
            this.cacheRefreshReason$value = cacheRefreshReason;
            cacheRefreshReason$set = true;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthenticationResultMetadata build() {
            CacheRefreshReason cacheRefreshReason$value = this.cacheRefreshReason$value;
            if (!this.cacheRefreshReason$set) cacheRefreshReason$value = AuthenticationResultMetadata.$default$cacheRefreshReason();
            return new AuthenticationResultMetadata(this.tokenSource, this.refreshOn, cacheRefreshReason$value);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AuthenticationResultMetadata.AuthenticationResultMetadataBuilder(tokenSource=" + this.tokenSource + ", refreshOn=" + this.refreshOn + ", cacheRefreshReason$value=" + this.cacheRefreshReason$value + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AuthenticationResultMetadata.AuthenticationResultMetadataBuilder builder() {
        return new AuthenticationResultMetadata.AuthenticationResultMetadataBuilder();
    }

    /**
     * The source of the tokens in the {@link AuthenticationResult}, see {@link TokenSource} for possible values
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TokenSource tokenSource() {
        return this.tokenSource;
    }

    /**
     * When the token should be proactively refreshed. May be null or 0 if proactive refresh is not used
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long refreshOn() {
        return this.refreshOn;
    }

    /**
     * Specifies the reason for refreshing the access token, see {@link CacheRefreshReason} for possible values. Will be {@link CacheRefreshReason#NOT_APPLICABLE} if the token was returned from the cache or if the API used to fetch the token does not attempt to read the cache.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CacheRefreshReason cacheRefreshReason() {
        return this.cacheRefreshReason;
    }

    /**
     * The source of the tokens in the {@link AuthenticationResult}, see {@link TokenSource} for possible values
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    AuthenticationResultMetadata tokenSource(final TokenSource tokenSource) {
        this.tokenSource = tokenSource;
        return this;
    }

    /**
     * When the token should be proactively refreshed. May be null or 0 if proactive refresh is not used
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    AuthenticationResultMetadata refreshOn(final Long refreshOn) {
        this.refreshOn = refreshOn;
        return this;
    }

    /**
     * Specifies the reason for refreshing the access token, see {@link CacheRefreshReason} for possible values. Will be {@link CacheRefreshReason#NOT_APPLICABLE} if the token was returned from the cache or if the API used to fetch the token does not attempt to read the cache.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    AuthenticationResultMetadata cacheRefreshReason(final CacheRefreshReason cacheRefreshReason) {
        this.cacheRefreshReason = cacheRefreshReason;
        return this;
    }
}
