// Generated by delombok at Thu Oct 26 22:50:01 UTC 2023
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import java.util.UUID;

class RequestContext {
    private String telemetryRequestId;
    private String clientId;
    private String correlationId;
    private PublicApi publicApi;
    private String applicationName;
    private String applicationVersion;
    private String authority;
    private IAcquireTokenParameters apiParameters;
    private IClientApplicationBase clientApplication;
    private UserIdentifier userIdentifier;

    public RequestContext(AbstractClientApplicationBase clientApplication, PublicApi publicApi, IAcquireTokenParameters apiParameters) {
        this.clientApplication = clientApplication;
        this.clientId = StringHelper.isBlank(clientApplication.clientId()) ? "unset_client_id" : clientApplication.clientId();
        this.correlationId = StringHelper.isBlank(clientApplication.correlationId()) ? generateNewCorrelationId() : clientApplication.correlationId();
        this.applicationVersion = clientApplication.applicationVersion();
        this.applicationName = clientApplication.applicationName();
        this.publicApi = publicApi;
        this.authority = clientApplication.authority();
        this.apiParameters = apiParameters;
    }

    public RequestContext(AbstractClientApplicationBase clientApplication, PublicApi publicApi, IAcquireTokenParameters apiParameters, UserIdentifier userIdentifier) {
        this(clientApplication, publicApi, apiParameters);
        this.userIdentifier = userIdentifier;
    }

    private static String generateNewCorrelationId() {
        return UUID.randomUUID().toString();
    }

    @java.lang.SuppressWarnings("all")
    String telemetryRequestId() {
        return this.telemetryRequestId;
    }

    @java.lang.SuppressWarnings("all")
    String clientId() {
        return this.clientId;
    }

    @java.lang.SuppressWarnings("all")
    String correlationId() {
        return this.correlationId;
    }

    @java.lang.SuppressWarnings("all")
    PublicApi publicApi() {
        return this.publicApi;
    }

    @java.lang.SuppressWarnings("all")
    String applicationName() {
        return this.applicationName;
    }

    @java.lang.SuppressWarnings("all")
    String applicationVersion() {
        return this.applicationVersion;
    }

    @java.lang.SuppressWarnings("all")
    String authority() {
        return this.authority;
    }

    @java.lang.SuppressWarnings("all")
    IAcquireTokenParameters apiParameters() {
        return this.apiParameters;
    }

    @java.lang.SuppressWarnings("all")
    IClientApplicationBase clientApplication() {
        return this.clientApplication;
    }

    @java.lang.SuppressWarnings("all")
    UserIdentifier userIdentifier() {
        return this.userIdentifier;
    }

    @java.lang.SuppressWarnings("all")
    RequestContext telemetryRequestId(final String telemetryRequestId) {
        this.telemetryRequestId = telemetryRequestId;
        return this;
    }
}
