/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.DeviceCode;
import com.microsoft.aad.msal4j.DeviceCodeAuthorizationGrant;
import com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import com.microsoft.aad.msal4j.HttpHelper;
import com.microsoft.aad.msal4j.HttpMethod;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.JsonHelper;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.RequestContext;
import com.microsoft.aad.msal4j.ServiceBundle;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeviceCodeFlowRequest
extends MsalRequest {
    private final Logger log = LoggerFactory.getLogger(DeviceCodeFlowRequest.class);
    private AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference;
    private DeviceCodeFlowParameters parameters;
    private String scopesStr;

    DeviceCodeFlowRequest(DeviceCodeFlowParameters parameters, AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference, PublicClientApplication application, RequestContext requestContext) {
        super(application, null, requestContext);
        this.parameters = parameters;
        this.scopesStr = String.join((CharSequence)" ", parameters.scopes());
        this.futureReference = futureReference;
    }

    DeviceCode acquireDeviceCode(String url, String clientId, Map<String, String> clientDataHeaders, ServiceBundle serviceBundle) throws Exception {
        String urlWithQueryParams = this.createQueryParamsAndAppendToURL(url, clientId);
        Map<String, String> headers = this.appendToHeaders(clientDataHeaders);
        String json = HttpHelper.executeHttpRequest(this.log, HttpMethod.GET, urlWithQueryParams, headers, null, this.requestContext(), serviceBundle);
        return this.parseJsonToDeviceCodeAndSetParameters(json, headers, clientId);
    }

    void createAuthenticationGrant(DeviceCode deviceCode) {
        this.msalAuthorizationGrant = new DeviceCodeAuthorizationGrant(deviceCode, deviceCode.scopes());
    }

    private String createQueryParamsAndAppendToURL(String url, String clientId) {
        HashMap<String, List<String>> queryParameters = new HashMap<String, List<String>>();
        queryParameters.put("client_id", Collections.singletonList(clientId));
        String scopesParam = "openid profile offline_access " + this.scopesStr;
        queryParameters.put("scope", Collections.singletonList(scopesParam));
        url = url + "?" + URLUtils.serializeParameters(queryParameters);
        return url;
    }

    private Map<String, String> appendToHeaders(Map<String, String> clientDataHeaders) {
        HashMap<String, String> headers = new HashMap<String, String>(clientDataHeaders);
        headers.put("Accept", "application/json");
        return headers;
    }

    private DeviceCode parseJsonToDeviceCodeAndSetParameters(String json, Map<String, String> headers, String clientId) {
        DeviceCode result = JsonHelper.convertJsonToObject(json, DeviceCode.class);
        result.correlationId(headers.get("client-request-id"));
        result.clientId(clientId);
        result.scopes(this.scopesStr);
        return result;
    }

    Logger log() {
        return this.log;
    }

    AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference() {
        return this.futureReference;
    }

    DeviceCodeFlowParameters parameters() {
        return this.parameters;
    }

    String scopesStr() {
        return this.scopesStr;
    }
}

