// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

package com.microsoft.aad.msal4j;

import com.google.gson.annotations.SerializedName;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;

@Accessors(fluent = true)
@Getter
@Setter
class RefreshTokenCacheEntity extends Credential {

    @SerializedName("credential_type")
    private String credentialType;

    @SerializedName("family_id")
    private String family_id;

    boolean isFamilyRT(){
        return !StringHelper.isBlank(family_id);
    }

    String getKey(){
        List<String> keyParts = new ArrayList<>();

        keyParts.add(homeAccountId);
        keyParts.add(environment);
        keyParts.add(credentialType);

        if(isFamilyRT()){
            keyParts.add(family_id);
        }
        else{
            keyParts.add(clientId);
        }

        // realm
        keyParts.add("");
        // target
        keyParts.add("");

        return String.join(Constants.CACHE_KEY_SEPARATOR, keyParts).toLowerCase();
    }
}
