/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.javamsalruntime;

import com.microsoft.azure.javamsalruntime.Account;
import com.microsoft.azure.javamsalruntime.AuthParameters;
import com.microsoft.azure.javamsalruntime.Callbacks;
import com.microsoft.azure.javamsalruntime.ErrorHelper;
import com.microsoft.azure.javamsalruntime.LogCallbackHandle;
import com.microsoft.azure.javamsalruntime.MsalInteropException;
import com.microsoft.azure.javamsalruntime.MsalRuntimeFuture;
import com.microsoft.azure.javamsalruntime.MsalRuntimeLibrary;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsalRuntimeInterop {
    private static final Logger LOG = LoggerFactory.getLogger(MsalRuntimeInterop.class);
    private static final String MSALRUNTIME_DLL_PATH = "external-dlls/MSALRuntimeDlls/";
    public static final MsalRuntimeLibrary MSALRUNTIME_LIBRARY;
    public static final ErrorHelper ERROR_HELPER;
    private static LogCallbackHandle logCallbackHandle;
    private static Callbacks.LogCallback logCallback;

    public void startupMsalRuntime() {
        ERROR_HELPER.checkMsalRuntimeError(MSALRUNTIME_LIBRARY.MSALRUNTIME_Startup());
        LOG.info("MSALRuntime startup API called successfully.");
    }

    public static void shutdownMsalRuntime() {
        LOG.info("Shutting down MSALRuntime.");
        for (Map.Entry<Integer, MsalRuntimeFuture> entry : MsalRuntimeFuture.msalRuntimeFutures.entrySet()) {
            entry.getValue().completeExceptionally(new MsalInteropException("MSALRuntime shutdown API called before operation could complete", "msalruntime_shutdown"));
            entry.getValue().handle.release();
            MsalRuntimeFuture.msalRuntimeFutures.entrySet().remove(entry);
        }
        if (logCallbackHandle != null) {
            logCallbackHandle.release();
        }
        MSALRUNTIME_LIBRARY.MSALRUNTIME_Shutdown();
        LOG.info("MSALRuntime shutdown API called successfully.");
    }

    public MsalRuntimeFuture readAccountById(String accountId, String correlationId) {
        MsalRuntimeFuture msalRuntimeFuture = new MsalRuntimeFuture(new Callbacks.ReadAccountResultCallback());
        msalRuntimeFuture.callback = new Callbacks.ReadAccountResultCallback();
        ERROR_HELPER.checkMsalRuntimeError(MSALRUNTIME_LIBRARY.MSALRUNTIME_ReadAccountByIdAsync(new WString(accountId), new WString(correlationId), (Callbacks.ReadAccountResultCallback)msalRuntimeFuture.callback, msalRuntimeFuture.msalRuntimeFuturesKey, msalRuntimeFuture.handle));
        return msalRuntimeFuture;
    }

    public MsalRuntimeFuture signIn(long windowHandle, AuthParameters authParameters, String correlationId, String loginHint) {
        MsalRuntimeFuture msalRuntimeFuture = new MsalRuntimeFuture(new Callbacks.AuthResultCallback());
        windowHandle = this.checkWindowHandle(windowHandle);
        ERROR_HELPER.checkMsalRuntimeError(MSALRUNTIME_LIBRARY.MSALRUNTIME_SignInAsync(windowHandle, authParameters.getHandle().value(), new WString(correlationId), new WString(loginHint == null ? "" : loginHint), (Callbacks.AuthResultCallback)msalRuntimeFuture.callback, msalRuntimeFuture.msalRuntimeFuturesKey, msalRuntimeFuture.handle));
        return msalRuntimeFuture;
    }

    public MsalRuntimeFuture signInSilently(AuthParameters authParameters, String correlationId) {
        MsalRuntimeFuture msalRuntimeFuture = new MsalRuntimeFuture(new Callbacks.AuthResultCallback());
        ERROR_HELPER.checkMsalRuntimeError(MSALRUNTIME_LIBRARY.MSALRUNTIME_SignInSilentlyAsync(authParameters.getHandle().value(), new WString(correlationId), (Callbacks.AuthResultCallback)msalRuntimeFuture.callback, msalRuntimeFuture.msalRuntimeFuturesKey, msalRuntimeFuture.handle));
        return msalRuntimeFuture;
    }

    public MsalRuntimeFuture signInInteractively(long windowHandle, AuthParameters authParameters, String correlationId, String loginHint) {
        MsalRuntimeFuture msalRuntimeFuture = new MsalRuntimeFuture(new Callbacks.AuthResultCallback());
        windowHandle = this.checkWindowHandle(windowHandle);
        ERROR_HELPER.checkMsalRuntimeError(MSALRUNTIME_LIBRARY.MSALRUNTIME_SignInInteractivelyAsync(windowHandle, authParameters.getHandle().value(), new WString(correlationId), new WString(loginHint == null ? "" : loginHint), (Callbacks.AuthResultCallback)msalRuntimeFuture.callback, msalRuntimeFuture.msalRuntimeFuturesKey, msalRuntimeFuture.handle));
        return msalRuntimeFuture;
    }

    public MsalRuntimeFuture acquireTokenSilently(AuthParameters authParameters, String correlationId, Account account) {
        if (account.getHandle() == null) {
            throw new MsalInteropException("Account handle is null, sign in or account discovery failed. Cannot retrieve tokens.", "msalruntime_account_error");
        }
        MsalRuntimeFuture msalRuntimeFuture = new MsalRuntimeFuture(new Callbacks.AuthResultCallback());
        ERROR_HELPER.checkMsalRuntimeError(MSALRUNTIME_LIBRARY.MSALRUNTIME_AcquireTokenSilentlyAsync(authParameters.getHandle().value(), new WString(correlationId), account.getHandle().value(), (Callbacks.AuthResultCallback)msalRuntimeFuture.callback, msalRuntimeFuture.msalRuntimeFuturesKey, msalRuntimeFuture.handle));
        return msalRuntimeFuture;
    }

    public MsalRuntimeFuture acquireTokenInteractively(long windowHandle, AuthParameters authParameters, String correlationId, Account account) {
        if (account.getHandle() == null) {
            throw new MsalInteropException("Account handle is null, sign in or account discovery failed. Cannot retrieve tokens.", "msalruntime_account_error");
        }
        MsalRuntimeFuture msalRuntimeFuture = new MsalRuntimeFuture(new Callbacks.AuthResultCallback());
        windowHandle = this.checkWindowHandle(windowHandle);
        ERROR_HELPER.checkMsalRuntimeError(MSALRUNTIME_LIBRARY.MSALRUNTIME_AcquireTokenInteractivelyAsync(windowHandle, authParameters.getHandle().value(), new WString(correlationId), account.getHandle().value(), (Callbacks.AuthResultCallback)msalRuntimeFuture.callback, msalRuntimeFuture.msalRuntimeFuturesKey, msalRuntimeFuture.handle));
        return msalRuntimeFuture;
    }

    public MsalRuntimeFuture signOutSilently(String clientId, String correlationId, Account account) {
        if (account.getHandle() == null) {
            throw new MsalInteropException("Account handle is null, cannot sign out.", "msalruntime_account_error");
        }
        MsalRuntimeFuture msalRuntimeFuture = new MsalRuntimeFuture(new Callbacks.SignOutResultCallback());
        ERROR_HELPER.checkMsalRuntimeError(MSALRUNTIME_LIBRARY.MSALRUNTIME_SignOutSilentlyAsync(new WString(clientId), new WString(correlationId), account.getHandle().value(), (Callbacks.SignOutResultCallback)msalRuntimeFuture.callback, msalRuntimeFuture.msalRuntimeFuturesKey, msalRuntimeFuture.handle));
        return msalRuntimeFuture;
    }

    public static synchronized void enableLogging(boolean enableLogging) {
        if (enableLogging) {
            if (logCallbackHandle == null) {
                LogCallbackHandle handle = new LogCallbackHandle();
                ERROR_HELPER.checkMsalRuntimeError(MSALRUNTIME_LIBRARY.MSALRUNTIME_RegisterLogCallback(logCallback, null, handle));
                logCallbackHandle = handle;
            }
        } else {
            logCallbackHandle.release();
            logCallbackHandle = null;
        }
    }

    public static synchronized void enableLoggingPii(boolean enablePIILogging) {
        if (enablePIILogging) {
            MSALRUNTIME_LIBRARY.MSALRUNTIME_SetIsPiiEnabled(1);
        } else {
            MSALRUNTIME_LIBRARY.MSALRUNTIME_SetIsPiiEnabled(0);
        }
    }

    long checkWindowHandle(long windowHandle) {
        if (windowHandle == 0L) {
            try {
                return Pointer.nativeValue((Pointer)User32.INSTANCE.GetAncestor(Kernel32.INSTANCE.GetConsoleWindow(), 3).getPointer());
            }
            catch (NullPointerException e) {
                throw new MsalInteropException("Window handle not provided, and could not retrieve console's window handle. Window handles must be provided if the application is not running in a Windows terminal.", "msalruntime_client_error");
            }
        }
        return windowHandle;
    }

    static MsalRuntimeLibrary loadMsalRuntimeLibrary() {
        try {
            if (Platform.isWindows()) {
                if (Platform.is64Bit()) {
                    if (Platform.isARM()) {
                        System.setProperty("jna.library.path", MsalRuntimeInterop.class.getClassLoader().getResource(MSALRUNTIME_DLL_PATH).toString());
                        return (MsalRuntimeLibrary)Native.load((String)"external-dlls/MSALRuntimeDlls/msalruntime_arm64.dll", MsalRuntimeLibrary.class);
                    }
                    System.setProperty("jna.library.path", MsalRuntimeInterop.class.getClassLoader().getResource(MSALRUNTIME_DLL_PATH).toString());
                    return (MsalRuntimeLibrary)Native.load((String)"external-dlls/MSALRuntimeDlls/msalruntime.dll", MsalRuntimeLibrary.class);
                }
                System.setProperty("jna.library.path", MsalRuntimeInterop.class.getClassLoader().getResource(MSALRUNTIME_DLL_PATH).toString());
                return (MsalRuntimeLibrary)Native.load((String)"external-dlls/MSALRuntimeDlls/msalruntime_x86.dll", MsalRuntimeLibrary.class);
            }
            throw new MsalInteropException("Could not detect platform, or platform was not supported.", "msalruntime_initialization_error");
        }
        catch (UnsatisfiedLinkError e) {
            throw new MsalInteropException("Could not find or load MSALRuntime dll.", "msalruntime_initialization_error");
        }
    }

    static {
        logCallback = new Callbacks.LogCallback();
        LOG.info("Setting up MSALRuntime.");
        MSALRUNTIME_LIBRARY = MsalRuntimeInterop.loadMsalRuntimeLibrary();
        ERROR_HELPER = new ErrorHelper();
        Runtime.getRuntime().addShutdownHook(new Thread(MsalRuntimeInterop::shutdownMsalRuntime));
    }
}

