/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.DoesServiceRequest;
import com.microsoft.azure.storage.IPRange;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.SharedAccessProtocols;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageLocation;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.blob.BlobAttributes;
import com.microsoft.azure.storage.blob.BlobEncryptionPolicy;
import com.microsoft.azure.storage.blob.BlobInputStream;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequest;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.BlobResponse;
import com.microsoft.azure.storage.blob.BlobType;
import com.microsoft.azure.storage.blob.CloudAppendBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.CloudPageBlob;
import com.microsoft.azure.storage.blob.CopyState;
import com.microsoft.azure.storage.blob.DeleteSnapshotsOption;
import com.microsoft.azure.storage.blob.LeaseAction;
import com.microsoft.azure.storage.blob.LeaseStatus;
import com.microsoft.azure.storage.blob.ListBlobItem;
import com.microsoft.azure.storage.blob.PremiumPageBlobTier;
import com.microsoft.azure.storage.blob.SharedAccessBlobHeaders;
import com.microsoft.azure.storage.blob.SharedAccessBlobPolicy;
import com.microsoft.azure.storage.core.BaseResponse;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.Logger;
import com.microsoft.azure.storage.core.NetworkInputStream;
import com.microsoft.azure.storage.core.PathUtility;
import com.microsoft.azure.storage.core.RequestLocationMode;
import com.microsoft.azure.storage.core.SharedAccessSignatureHelper;
import com.microsoft.azure.storage.core.StorageCredentialsHelper;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.StreamMd5AndLength;
import com.microsoft.azure.storage.core.UriQueryBuilder;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.core.WrappedByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public abstract class CloudBlob
implements ListBlobItem {
    HashMap<String, String> metadata = new HashMap();
    BlobProperties properties;
    private StorageUri storageUri;
    String snapshotID;
    private CloudBlobContainer container;
    protected CloudBlobDirectory parent;
    private String name;
    protected int streamWriteSizeInBytes = 0x400000;
    protected int streamMinimumReadSizeInBytes = 0x400000;
    protected CloudBlobClient blobServiceClient;

    protected CloudBlob(BlobType type, String blobName, String snapshotID, CloudBlobContainer container) throws URISyntaxException {
        Utility.assertNotNullOrEmpty("blobName", blobName);
        Utility.assertNotNull("container", container);
        this.storageUri = PathUtility.appendPathToUri(container.getStorageUri(), blobName);
        this.name = blobName;
        this.blobServiceClient = container.getServiceClient();
        this.container = container;
        this.snapshotID = snapshotID;
        this.properties = new BlobProperties(type);
    }

    protected CloudBlob(BlobType type, StorageUri uri, String snapshotID, StorageCredentials credentials) throws StorageException {
        this.properties = new BlobProperties(type);
        this.parseQueryAndVerify(uri, credentials);
        if (snapshotID != null) {
            if (this.snapshotID != null) {
                throw new IllegalArgumentException("Snapshot query parameter is already defined in the blob URI. Either pass in a snapshotTime parameter or use a full URL with a snapshot query parameter.");
            }
            this.snapshotID = snapshotID;
        }
    }

    protected CloudBlob(CloudBlob otherBlob) {
        this.properties = new BlobProperties(otherBlob.properties);
        if (otherBlob.metadata != null) {
            this.metadata = new HashMap();
            for (String key : otherBlob.metadata.keySet()) {
                this.metadata.put(key, otherBlob.metadata.get(key));
            }
        }
        this.snapshotID = otherBlob.snapshotID;
        this.storageUri = otherBlob.storageUri;
        this.container = otherBlob.container;
        this.parent = otherBlob.parent;
        this.blobServiceClient = otherBlob.blobServiceClient;
        this.name = otherBlob.name;
        this.setStreamMinimumReadSizeInBytes(otherBlob.getStreamMinimumReadSizeInBytes());
        this.setStreamWriteSizeInBytes(otherBlob.getStreamWriteSizeInBytes());
    }

    @DoesServiceRequest
    public final void abortCopy(String copyId) throws StorageException {
        this.abortCopy(copyId, null, null, null);
    }

    @DoesServiceRequest
    public final void abortCopy(String copyId, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.abortCopyImpl(copyId, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> abortCopyImpl(final String copyId, final AccessCondition accessCondition, final BlobRequestOptions options) {
        Utility.assertNotNull("copyId", copyId);
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.abortCopy(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, copyId);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudBlob parentObject, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public final String acquireLease() throws StorageException {
        return this.acquireLease(null, null);
    }

    @DoesServiceRequest
    public final String acquireLease(Integer leaseTimeInSeconds, String proposedLeaseId) throws StorageException {
        return this.acquireLease(leaseTimeInSeconds, proposedLeaseId, null, null, null);
    }

    @DoesServiceRequest
    public final String acquireLease(Integer leaseTimeInSeconds, String proposedLeaseId, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.acquireLeaseImpl(leaseTimeInSeconds, proposedLeaseId, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, String> acquireLeaseImpl(final Integer leaseTimeInSeconds, final String proposedLeaseId, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, String> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, String>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.leaseBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, LeaseAction.ACQUIRE, leaseTimeInSeconds, proposedLeaseId, null);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public String preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                CloudBlob.this.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.properties.setLeaseStatus(LeaseStatus.LOCKED);
                return BlobResponse.getLeaseID(this.getConnection());
            }
        };
        return putRequest;
    }

    protected final void assertCorrectBlobType() throws StorageException {
        if (this instanceof CloudBlockBlob && this.properties.getBlobType() != BlobType.BLOCK_BLOB) {
            throw new StorageException("IncorrectBlobType", String.format("Incorrect Blob type, please use the correct Blob type to access a blob on the server. Expected %s, actual %s.", new Object[]{BlobType.BLOCK_BLOB, this.properties.getBlobType()}), 306, null, null);
        }
        if (this instanceof CloudPageBlob && this.properties.getBlobType() != BlobType.PAGE_BLOB) {
            throw new StorageException("IncorrectBlobType", String.format("Incorrect Blob type, please use the correct Blob type to access a blob on the server. Expected %s, actual %s.", new Object[]{BlobType.PAGE_BLOB, this.properties.getBlobType()}), 306, null, null);
        }
        if (this instanceof CloudAppendBlob && this.properties.getBlobType() != BlobType.APPEND_BLOB) {
            throw new StorageException("IncorrectBlobType", String.format("Incorrect Blob type, please use the correct Blob type to access a blob on the server. Expected %s, actual %s.", new Object[]{BlobType.APPEND_BLOB, this.properties.getBlobType()}), 306, null, null);
        }
    }

    protected void assertNoWriteOperationForSnapshot() {
        if (this.isSnapshot()) {
            throw new IllegalArgumentException("Cannot perform this operation on a blob representing a snapshot.");
        }
    }

    @DoesServiceRequest
    public final long breakLease(Integer breakPeriodInSeconds) throws StorageException {
        return this.breakLease(breakPeriodInSeconds, null, null, null);
    }

    @DoesServiceRequest
    public final long breakLease(Integer breakPeriodInSeconds, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (breakPeriodInSeconds != null) {
            Utility.assertGreaterThanOrEqual("breakPeriodInSeconds", breakPeriodInSeconds.intValue(), 0L);
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.breakLeaseImpl(breakPeriodInSeconds, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Long> breakLeaseImpl(final Integer breakPeriodInSeconds, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Long> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Long>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.leaseBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, LeaseAction.BREAK, null, null, breakPeriodInSeconds);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Long preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return -1L;
                }
                CloudBlob.this.updateEtagAndLastModifiedFromResponse(this.getConnection());
                String leaseTime = BlobResponse.getLeaseTime(this.getConnection());
                blob.properties.setLeaseStatus(LeaseStatus.UNLOCKED);
                return Utility.isNullOrEmpty(leaseTime) ? -1L : Long.parseLong(leaseTime);
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public final String changeLease(String proposedLeaseId, AccessCondition accessCondition) throws StorageException {
        return this.changeLease(proposedLeaseId, accessCondition, null, null);
    }

    @DoesServiceRequest
    public final String changeLease(String proposedLeaseId, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("accessCondition", accessCondition);
        Utility.assertNotNullOrEmpty("leaseID", accessCondition.getLeaseID());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.changeLeaseImpl(proposedLeaseId, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, String> changeLeaseImpl(final String proposedLeaseId, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, String> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, String>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.leaseBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, LeaseAction.CHANGE, null, proposedLeaseId, null);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public String preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                CloudBlob.this.updateEtagAndLastModifiedFromResponse(this.getConnection());
                return BlobResponse.getLeaseID(this.getConnection());
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public final String startCopy(URI source) throws StorageException {
        return this.startCopy(source, null, null, null, null);
    }

    @DoesServiceRequest
    public final String startCopy(URI source, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.startCopy(source, null, sourceAccessCondition, destinationAccessCondition, options, opContext);
    }

    @DoesServiceRequest
    protected final String startCopy(URI source, PremiumPageBlobTier premiumPageBlobTier, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.startCopyImpl(source, false, premiumPageBlobTier, sourceAccessCondition, destinationAccessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    protected StorageRequest<CloudBlobClient, CloudBlob, String> startCopyImpl(final URI source, final boolean incrementalCopy, final PremiumPageBlobTier premiumPageBlobTier, final AccessCondition sourceAccessCondition, final AccessCondition destinationAccessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, String> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, String>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.copyFrom(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, sourceAccessCondition, destinationAccessCondition, source.toASCIIString(), blob.snapshotID, incrementalCopy, premiumPageBlobTier);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                BlobRequest.addMetadata(connection, blob.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public String preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.properties.setCopyState(BlobResponse.getCopyState(this.getConnection()));
                blob.properties.setPremiumPageBlobTier(premiumPageBlobTier);
                if (premiumPageBlobTier != null) {
                    blob.properties.setBlobTierInferredTier(false);
                }
                return blob.properties.getCopyState().getCopyId();
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public final CloudBlob createSnapshot() throws StorageException {
        return this.createSnapshot(null, null, null, null);
    }

    @DoesServiceRequest
    public final CloudBlob createSnapshot(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.createSnapshot(null, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    public final CloudBlob createSnapshot(HashMap<String, String> metadata, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.createSnapshotImpl(metadata, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, CloudBlob> createSnapshotImpl(final HashMap<String, String> metadata, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, CloudBlob> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, CloudBlob>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.snapshot(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                if (metadata != null) {
                    BlobRequest.addMetadata(connection, metadata, context);
                }
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public CloudBlob preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                CloudBlob snapshot = null;
                String snapshotTime = BlobResponse.getSnapshotTime(this.getConnection());
                if (blob instanceof CloudBlockBlob) {
                    snapshot = new CloudBlockBlob(blob.getName(), snapshotTime, CloudBlob.this.getContainer());
                } else if (blob instanceof CloudPageBlob) {
                    snapshot = new CloudPageBlob(blob.getName(), snapshotTime, CloudBlob.this.getContainer());
                } else if (blob instanceof CloudAppendBlob) {
                    snapshot = new CloudAppendBlob(blob.getName(), snapshotTime, CloudBlob.this.getContainer());
                }
                snapshot.setProperties(blob.properties);
                snapshot.setMetadata(metadata != null ? metadata : blob.metadata);
                snapshot.updateEtagAndLastModifiedFromResponse(this.getConnection());
                return snapshot;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public final void delete() throws StorageException {
        this.delete(DeleteSnapshotsOption.NONE, null, null, null);
    }

    @DoesServiceRequest
    public final void delete(DeleteSnapshotsOption deleteSnapshotsOption, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("deleteSnapshotsOption", (Object)deleteSnapshotsOption);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.deleteImpl(deleteSnapshotsOption, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final boolean deleteIfExists() throws StorageException {
        return this.deleteIfExists(DeleteSnapshotsOption.NONE, null, null, null);
    }

    @DoesServiceRequest
    public final boolean deleteIfExists(DeleteSnapshotsOption deleteSnapshotsOption, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        boolean exists = this.exists(true, accessCondition, options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient), opContext);
        if (exists) {
            try {
                this.delete(deleteSnapshotsOption, accessCondition, options, opContext);
                return true;
            }
            catch (StorageException e) {
                if (e.getHttpStatusCode() == 404 && "BlobNotFound".equals(e.getErrorCode())) {
                    return false;
                }
                throw e;
            }
        }
        return false;
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> deleteImpl(final DeleteSnapshotsOption deleteSnapshotsOption, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> deleteRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.deleteBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.snapshotID, deleteSnapshotsOption);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Void preProcessResponse(CloudBlob parentObject, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return null;
            }
        };
        return deleteRequest;
    }

    @DoesServiceRequest
    public final void download(OutputStream outStream) throws StorageException {
        this.download(outStream, null, null, null);
    }

    @DoesServiceRequest
    public final void download(OutputStream outStream, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadToStreamImpl(null, null, outStream, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void downloadRange(long offset, Long length, OutputStream outStream) throws StorageException {
        this.downloadRange(offset, length, outStream, null, null, null);
    }

    @DoesServiceRequest
    public final void downloadRange(long offset, Long length, OutputStream outStream, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (offset < 0L || length != null && length <= 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        if (options.getUseTransactionalContentMD5().booleanValue() && length != null && length > 0x400000L) {
            throw new IllegalArgumentException("Cannot specify x-ms-range-get-content-md5 header on ranges larger than 4 MB. Either use a BlobReadStream via openRead, or disable TransactionalMD5 via the BlobRequestOptions.");
        }
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadToStreamImpl(offset, length, outStream, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void downloadAttributes() throws StorageException {
        this.downloadAttributes(null, null, null);
    }

    @DoesServiceRequest
    public final void downloadAttributes(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadAttributesImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> downloadAttributesImpl(final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> getRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.getBlobProperties(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.snapshotID);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                BlobAttributes retrievedAttributes = BlobResponse.getBlobAttributes(this.getConnection(), blob.getStorageUri(), blob.snapshotID);
                if (retrievedAttributes.getProperties().getBlobType() != blob.properties.getBlobType()) {
                    throw new StorageException("IncorrectBlobType", String.format("Incorrect Blob type, please use the correct Blob type to access a blob on the server. Expected %s, actual %s.", new Object[]{blob.properties.getBlobType(), retrievedAttributes.getProperties().getBlobType()}), 306, null, null);
                }
                blob.properties = retrievedAttributes.getProperties();
                blob.metadata = retrievedAttributes.getMetadata();
                return null;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    private final StorageRequest<CloudBlobClient, CloudBlob, Integer> downloadToStreamImpl(Long offset, Long length, final OutputStream userStream, final AccessCondition accessCondition, final BlobRequestOptions options, OperationContext opContext) {
        options.assertPolicyIfRequired();
        final Long userSpecifiedLength = length;
        final long startingOffset = offset == null ? 0L : offset;
        final boolean isRangeGet = offset != null;
        int discardFirst = 0;
        Long endOffset = null;
        boolean bufferIV = false;
        if (isRangeGet && options.getEncryptionPolicy() != null) {
            if (length != null) {
                endOffset = offset + length - 1L;
                endOffset = endOffset + (15L - endOffset % 16L);
            }
            discardFirst = (int)(offset % 16L);
            if ((offset = Long.valueOf(offset - (long)discardFirst)) > 15L) {
                offset = offset - 16L;
                bufferIV = true;
            }
            if (endOffset != null) {
                length = endOffset - offset + 1L;
            }
        }
        final Long offsetFinal = offset;
        final Long lengthFinal = length;
        final int discardFirstFinal = discardFirst;
        final Long endOffsetFinal = endOffset;
        final boolean bufferIVFinal = bufferIV;
        StorageRequest<CloudBlobClient, CloudBlob, Integer> getRequest = new StorageRequest<CloudBlobClient, CloudBlob, Integer>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                if (this.getOffset() == null) {
                    this.setOffset(offsetFinal);
                }
                if (this.getLength() == null) {
                    this.setLength(lengthFinal);
                }
                AccessCondition tempCondition = this.getETagLockCondition() != null ? this.getETagLockCondition() : accessCondition;
                return BlobRequest.getBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, tempCondition, blob.snapshotID, this.getOffset(), this.getLength(), options.getUseTransactionalContentMD5() != false && !this.getArePropertiesPopulated());
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Integer preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 206 && this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                if (!this.getArePropertiesPopulated()) {
                    BlobAttributes retrievedAttributes = BlobResponse.getBlobAttributes(this.getConnection(), blob.getStorageUri(), blob.snapshotID);
                    blob.properties = retrievedAttributes.getProperties();
                    blob.metadata = retrievedAttributes.getMetadata();
                    String contentMD5 = this.getConnection().getHeaderField("Content-MD5");
                    if (!options.getDisableContentMD5Validation().booleanValue() && options.getUseTransactionalContentMD5().booleanValue() && Utility.isNullOrEmpty(contentMD5)) {
                        throw new StorageException("MissingContentMD5Header", "ContentMD5 header is missing in the response.", 306, null, null);
                    }
                    this.setContentMD5(contentMD5);
                    this.setLockedETag(blob.properties.getEtag());
                    this.setArePropertiesPopulated(true);
                }
                this.setRequestLocationMode(this.getResult().getTargetLocation() == StorageLocation.PRIMARY ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.SECONDARY_ONLY);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer postProcessResponse(HttpURLConnection connection, CloudBlob blob, CloudBlobClient client, OperationContext context, Integer storageObject) throws Exception {
                Boolean validateMD5 = options.getDisableContentMD5Validation() == false && !Utility.isNullOrEmpty(this.getContentMD5());
                String contentLength = connection.getHeaderField("Content-Length");
                long expectedLength = Long.parseLong(contentLength);
                Logger.info(context, String.format("Creating a NetworkInputStream and expecting to read %s bytes.", expectedLength));
                NetworkInputStream streamRef = new NetworkInputStream(connection.getInputStream(), expectedLength);
                OutputStream outStream = userStream;
                try {
                    if (options.getEncryptionPolicy() != null) {
                        outStream = BlobEncryptionPolicy.wrapUserStreamWithDecryptStream(blob, userStream, options, blob.metadata, blob.properties.getLength(), isRangeGet, endOffsetFinal, userSpecifiedLength, discardFirstFinal, bufferIVFinal);
                    }
                    StreamMd5AndLength descriptor = Utility.writeToOutputStream(streamRef, outStream, -1L, false, validateMD5, context, options, true, this, this.getCurrentDescriptor());
                    if (validateMD5.booleanValue() && !this.getContentMD5().equals(descriptor.getMd5())) {
                        throw new StorageException("InvalidMd5", String.format("Blob hash mismatch (integrity check failed), Expected value is %s, retrieved %s.", this.getContentMD5(), descriptor.getMd5()), 306, null, null);
                    }
                }
                finally {
                    streamRef.close();
                    if (options.getEncryptionPolicy() != null) {
                        outStream.close();
                    }
                }
                return null;
            }

            @Override
            public void recoveryAction(OperationContext context) throws IOException {
                if (this.getETagLockCondition() == null && !Utility.isNullOrEmpty(this.getLockedETag())) {
                    AccessCondition etagLockCondition = new AccessCondition();
                    etagLockCondition.setIfMatch(this.getLockedETag());
                    if (accessCondition != null) {
                        etagLockCondition.setLeaseID(accessCondition.getLeaseID());
                    }
                    this.setETagLockCondition(etagLockCondition);
                }
                if (this.getCurrentRequestByteCount() > 0L) {
                    this.setOffset(startingOffset + this.getCurrentRequestByteCount());
                    if (lengthFinal != null) {
                        this.setLength(lengthFinal - this.getCurrentRequestByteCount());
                    }
                }
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    protected final int downloadRangeInternal(long blobOffset, Long length, byte[] buffer, int bufferOffset, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (bufferOffset < 0 || blobOffset < 0L || length != null && length <= 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if ((options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient)).getUseTransactionalContentMD5().booleanValue() && length != null && length > 0x400000L) {
            throw new IllegalArgumentException("Cannot specify x-ms-range-get-content-md5 header on ranges larger than 4 MB. Either use a BlobReadStream via openRead, or disable TransactionalMD5 via the BlobRequestOptions.");
        }
        WrappedByteArrayOutputStream outputStream = new WrappedByteArrayOutputStream(buffer, bufferOffset);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadToStreamImpl(blobOffset, length, outputStream, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
        return outputStream.getPosition();
    }

    @DoesServiceRequest
    public final int downloadRangeToByteArray(long offset, Long length, byte[] buffer, int bufferOffset) throws StorageException {
        return this.downloadRangeToByteArray(offset, length, buffer, bufferOffset, null, null, null);
    }

    @DoesServiceRequest
    public final int downloadRangeToByteArray(long offset, Long length, byte[] buffer, int bufferOffset, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("buffer", buffer);
        if (length != null && length + (long)bufferOffset > (long)buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        return this.downloadRangeInternal(offset, length, buffer, bufferOffset, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    public final int downloadToByteArray(byte[] buffer, int bufferOffset) throws StorageException {
        return this.downloadToByteArray(buffer, bufferOffset, null, null, null);
    }

    @DoesServiceRequest
    public final int downloadToByteArray(byte[] buffer, int bufferOffset, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("buffer", buffer);
        if (bufferOffset < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bufferOffset >= buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        WrappedByteArrayOutputStream outputStream = new WrappedByteArrayOutputStream(buffer, bufferOffset);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadToStreamImpl(null, null, outputStream, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
        return outputStream.getPosition();
    }

    public void uploadFromByteArray(byte[] buffer, int offset, int length) throws StorageException, IOException {
        this.uploadFromByteArray(buffer, offset, length, null, null, null);
    }

    public void uploadFromByteArray(byte[] buffer, int offset, int length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, offset, length);
        this.upload(inputStream, length, accessCondition, options, opContext);
        inputStream.close();
    }

    public void uploadFromFile(String path) throws StorageException, IOException {
        this.uploadFromFile(path, null, null, null);
    }

    public void uploadFromFile(String path, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        File file = new File(path);
        long fileLength = file.length();
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        this.upload(inputStream, fileLength, accessCondition, options, opContext);
        ((InputStream)inputStream).close();
    }

    public void downloadToFile(String path) throws StorageException, IOException {
        this.downloadToFile(path, null, null, null);
    }

    public void downloadToFile(String path, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(path));
        try {
            this.download(outputStream, accessCondition, options, opContext);
            ((OutputStream)outputStream).close();
        }
        catch (StorageException e) {
            this.deleteEmptyFileOnException(outputStream, path);
            throw e;
        }
        catch (IOException e) {
            this.deleteEmptyFileOnException(outputStream, path);
            throw e;
        }
    }

    private void deleteEmptyFileOnException(OutputStream outputStream, String path) {
        try {
            outputStream.close();
            File fileToDelete = new File(path);
            fileToDelete.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @DoesServiceRequest
    public final boolean exists() throws StorageException {
        return this.exists(null, null, null);
    }

    @DoesServiceRequest
    public final boolean exists(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.exists(false, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    private final boolean exists(boolean primaryOnly, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.existsImpl(primaryOnly, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Boolean> existsImpl(final boolean primaryOnly, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Boolean> getRequest = new StorageRequest<CloudBlobClient, CloudBlob, Boolean>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(primaryOnly ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.getBlobProperties(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.snapshotID);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Boolean preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() == 200) {
                    BlobAttributes retrievedAttributes = BlobResponse.getBlobAttributes(this.getConnection(), blob.getStorageUri(), blob.snapshotID);
                    blob.properties = retrievedAttributes.getProperties();
                    blob.metadata = retrievedAttributes.getMetadata();
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return getRequest;
    }

    public String generateSharedAccessSignature(SharedAccessBlobPolicy policy, String groupPolicyIdentifier) throws InvalidKeyException, StorageException {
        return this.generateSharedAccessSignature(policy, null, groupPolicyIdentifier);
    }

    public String generateSharedAccessSignature(SharedAccessBlobPolicy policy, SharedAccessBlobHeaders headers, String groupPolicyIdentifier) throws InvalidKeyException, StorageException {
        return this.generateSharedAccessSignature(policy, headers, groupPolicyIdentifier, null, null);
    }

    public String generateSharedAccessSignature(SharedAccessBlobPolicy policy, SharedAccessBlobHeaders headers, String groupPolicyIdentifier, IPRange ipRange, SharedAccessProtocols protocols) throws InvalidKeyException, StorageException {
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.blobServiceClient.getCredentials())) {
            throw new IllegalArgumentException("Cannot create Shared Access Signature unless the Account Key credentials are used by the ServiceClient.");
        }
        if (this.isSnapshot()) {
            throw new IllegalArgumentException("Cannot create Shared Access Signature via references to blob snapshots. Please perform the given operation on the root blob instead.");
        }
        String resourceName = this.getCanonicalName(true);
        String signature = SharedAccessSignatureHelper.generateSharedAccessSignatureHashForBlobAndFile(policy, headers, groupPolicyIdentifier, resourceName, ipRange, protocols, this.blobServiceClient);
        UriQueryBuilder builder = SharedAccessSignatureHelper.generateSharedAccessSignatureForBlobAndFile(policy, headers, groupPolicyIdentifier, "b", ipRange, protocols, signature);
        return builder.toString();
    }

    String getCanonicalName(boolean ignoreSnapshotTime) {
        StringBuilder canonicalName = new StringBuilder("/");
        canonicalName.append("blob");
        if (this.blobServiceClient.isUsePathStyleUris()) {
            canonicalName.append(this.getUri().getRawPath());
        } else {
            canonicalName.append(PathUtility.getCanonicalPathFromCredentials(this.blobServiceClient.getCredentials(), this.getUri().getRawPath()));
        }
        if (!ignoreSnapshotTime && this.snapshotID != null) {
            canonicalName.append("?snapshot=");
            canonicalName.append(this.snapshotID);
        }
        return canonicalName.toString();
    }

    @Override
    public final CloudBlobContainer getContainer() throws StorageException, URISyntaxException {
        if (this.container == null) {
            StorageUri containerURI = PathUtility.getContainerURI(this.getStorageUri(), this.blobServiceClient.isUsePathStyleUris());
            this.container = new CloudBlobContainer(containerURI, this.blobServiceClient.getCredentials());
        }
        return this.container;
    }

    public final HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public final CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
        String parentName;
        if (this.parent == null && (parentName = CloudBlob.getParentNameFromURI(this.getStorageUri(), this.blobServiceClient.getDirectoryDelimiter(), this.getContainer())) != null) {
            StorageUri parentURI = PathUtility.appendPathToUri(this.container.getStorageUri(), parentName);
            this.parent = new CloudBlobDirectory(parentURI, parentName, this.blobServiceClient, this.getContainer());
        }
        return this.parent;
    }

    public final BlobProperties getProperties() {
        return this.properties;
    }

    public CopyState getCopyState() {
        return this.properties.getCopyState();
    }

    public final StorageUri getSnapshotQualifiedStorageUri() throws URISyntaxException, StorageException {
        if (this.isSnapshot()) {
            return PathUtility.addToQuery(this.getStorageUri(), String.format("snapshot=%s", this.snapshotID));
        }
        return this.getStorageUri();
    }

    public final URI getSnapshotQualifiedUri() throws URISyntaxException, StorageException {
        if (this.isSnapshot()) {
            return PathUtility.addToQuery(this.getUri(), String.format("snapshot=%s", this.snapshotID));
        }
        return this.getUri();
    }

    @Deprecated
    public final StorageUri getQualifiedStorageUri() throws URISyntaxException, StorageException {
        if (this.isSnapshot()) {
            StorageUri snapshotQualifiedUri = PathUtility.addToQuery(this.getStorageUri(), String.format("snapshot=%s", this.snapshotID));
            return this.blobServiceClient.getCredentials().transformUri(snapshotQualifiedUri);
        }
        return this.blobServiceClient.getCredentials().transformUri(this.getStorageUri());
    }

    @Deprecated
    public final URI getQualifiedUri() throws URISyntaxException, StorageException {
        if (this.isSnapshot()) {
            return PathUtility.addToQuery(this.getUri(), String.format("snapshot=%s", this.snapshotID));
        }
        return this.blobServiceClient.getCredentials().transformUri(this.getUri());
    }

    public final CloudBlobClient getServiceClient() {
        return this.blobServiceClient;
    }

    public final String getSnapshotID() {
        return this.snapshotID;
    }

    @Override
    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    public final int getStreamWriteSizeInBytes() {
        return this.streamWriteSizeInBytes;
    }

    public final int getStreamMinimumReadSizeInBytes() {
        return this.streamMinimumReadSizeInBytes;
    }

    protected final StorageUri getTransformedAddress(OperationContext opContext) throws URISyntaxException, StorageException {
        return this.blobServiceClient.getCredentials().transformUri(this.getStorageUri(), opContext);
    }

    @Override
    public final URI getUri() {
        return this.storageUri.getPrimaryUri();
    }

    public final boolean isSnapshot() {
        return this.snapshotID != null;
    }

    @DoesServiceRequest
    public final BlobInputStream openInputStream() throws StorageException {
        return this.openInputStream(null, null, null);
    }

    @DoesServiceRequest
    public final BlobInputStream openInputStream(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.assertNoWriteOperationForSnapshot();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient, false);
        return new BlobInputStream(this, accessCondition, options, opContext);
    }

    private void parseQueryAndVerify(StorageUri completeUri, StorageCredentials credentials) throws StorageException {
        Utility.assertNotNull("completeUri", completeUri);
        if (!completeUri.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Address %s is a relative address. Only absolute addresses are permitted.", completeUri.toString()));
        }
        this.storageUri = PathUtility.stripURIQueryAndFragment(completeUri);
        HashMap<String, String[]> queryParameters = PathUtility.parseQueryString(completeUri.getQuery());
        String[] snapshotIDs = queryParameters.get("snapshot");
        if (snapshotIDs != null && snapshotIDs.length > 0) {
            this.snapshotID = snapshotIDs[0];
        }
        StorageCredentialsSharedAccessSignature parsedCredentials = SharedAccessSignatureHelper.parseQuery(queryParameters);
        if (credentials != null && parsedCredentials != null) {
            throw new IllegalArgumentException("Cannot provide credentials as part of the address and as constructor parameter. Either pass in the address or use a different constructor.");
        }
        try {
            boolean usePathStyleUris = Utility.determinePathStyleFromUri(this.storageUri.getPrimaryUri());
            this.blobServiceClient = new CloudBlobClient(PathUtility.getServiceClientBaseAddress(this.getStorageUri(), usePathStyleUris), credentials != null ? credentials : parsedCredentials);
            this.name = PathUtility.getBlobNameFromURI(this.storageUri.getPrimaryUri(), usePathStyleUris);
        }
        catch (URISyntaxException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    @DoesServiceRequest
    public final void releaseLease(AccessCondition accessCondition) throws StorageException {
        this.releaseLease(accessCondition, null, null);
    }

    @DoesServiceRequest
    public final void releaseLease(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("accessCondition", accessCondition);
        Utility.assertNotNullOrEmpty("leaseID", accessCondition.getLeaseID());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.releaseLeaseImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> releaseLeaseImpl(final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.leaseBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, LeaseAction.RELEASE, null, null, null);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                CloudBlob.this.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.properties.setLeaseStatus(LeaseStatus.UNLOCKED);
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public final void renewLease(AccessCondition accessCondition) throws StorageException {
        this.renewLease(accessCondition, null, null);
    }

    @DoesServiceRequest
    public final void renewLease(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("accessCondition", accessCondition);
        Utility.assertNotNullOrEmpty("leaseID", accessCondition.getLeaseID());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.renewLeaseImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> renewLeaseImpl(final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.leaseBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, LeaseAction.RENEW, null, null, null);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                CloudBlob.this.updateEtagAndLastModifiedFromResponse(this.getConnection());
                return null;
            }
        };
        return putRequest;
    }

    protected final void setContainer(CloudBlobContainer container) {
        this.container = container;
    }

    public final void setMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    protected final void setProperties(BlobProperties properties) {
        this.properties = properties;
    }

    protected final void setSnapshotID(String snapshotID) {
        this.snapshotID = snapshotID;
    }

    protected void setStorageUri(StorageUri storageUri) {
        this.storageUri = storageUri;
    }

    public abstract void setStreamWriteSizeInBytes(int var1);

    public void setStreamMinimumReadSizeInBytes(int minimumReadSize) {
        if (minimumReadSize < 16384) {
            throw new IllegalArgumentException("MinimumReadSize");
        }
        this.streamMinimumReadSizeInBytes = minimumReadSize;
    }

    protected void updateEtagAndLastModifiedFromResponse(HttpURLConnection request) {
        this.getProperties().setEtag(request.getHeaderField("ETag"));
        if (0L != request.getLastModified()) {
            Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
            lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
            lastModifiedCalendar.setTime(new Date(request.getLastModified()));
            this.getProperties().setLastModified(lastModifiedCalendar.getTime());
        }
    }

    protected void updateLengthFromResponse(HttpURLConnection request) {
        String xContentLengthHeader = request.getHeaderField("x-ms-blob-content-length");
        if (!Utility.isNullOrEmpty(xContentLengthHeader)) {
            this.getProperties().setLength(Long.parseLong(xContentLengthHeader));
        }
    }

    @DoesServiceRequest
    public abstract void upload(InputStream var1, long var2) throws StorageException, IOException;

    @DoesServiceRequest
    public abstract void upload(InputStream var1, long var2, AccessCondition var4, BlobRequestOptions var5, OperationContext var6) throws StorageException, IOException;

    @DoesServiceRequest
    public final void uploadMetadata() throws StorageException {
        this.uploadMetadata(null, null, null);
    }

    @DoesServiceRequest
    public final void uploadMetadata(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.uploadMetadataImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> uploadMetadataImpl(final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.setBlobMetadata(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                BlobRequest.addMetadata(connection, blob.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                this.getResult().setRequestServiceEncrypted(BaseResponse.isServerRequestEncrypted(this.getConnection()));
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public final void uploadProperties() throws StorageException {
        this.uploadProperties(null, null, null);
    }

    @DoesServiceRequest
    public final void uploadProperties(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.uploadPropertiesImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> uploadPropertiesImpl(final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.setBlobProperties(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.properties);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                return null;
            }
        };
        return putRequest;
    }

    protected static String getParentNameFromURI(StorageUri resourceAddress, String delimiter, CloudBlobContainer container) throws URISyntaxException {
        String parentName;
        Utility.assertNotNull("resourceAddress", resourceAddress);
        Utility.assertNotNull("container", container);
        Utility.assertNotNullOrEmpty("delimiter", delimiter);
        String containerName = container.getName() + "/";
        String relativeURIString = Utility.safeRelativize(container.getStorageUri().getPrimaryUri(), resourceAddress.getPrimaryUri());
        if (relativeURIString.endsWith(delimiter)) {
            relativeURIString = relativeURIString.substring(0, relativeURIString.length() - delimiter.length());
        }
        if (Utility.isNullOrEmpty(relativeURIString)) {
            parentName = null;
        } else {
            int lastDelimiterDex = relativeURIString.lastIndexOf(delimiter);
            if (lastDelimiterDex < 0) {
                parentName = "";
            } else {
                parentName = relativeURIString.substring(0, lastDelimiterDex + delimiter.length());
                if (parentName != null && parentName.equals(containerName)) {
                    parentName = "";
                }
            }
        }
        return parentName;
    }
}

