/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.core.Utility;
import java.net.HttpURLConnection;
import java.util.Date;

public final class AccessCondition {
    private String leaseID = null;
    private String ifMatchETag = null;
    private String ifNoneMatchETag = null;
    private Date ifModifiedSinceDate = null;
    private Date ifUnmodifiedSinceDate = null;
    private Long ifSequenceNumberLessThanOrEqual = null;
    private Long ifSequenceNumberLessThan = null;
    private Long ifSequenceNumberEqual = null;

    public static AccessCondition generateEmptyCondition() {
        return new AccessCondition();
    }

    public static AccessCondition generateIfMatchCondition(String etag) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.setIfMatch(etag);
        return retCondition;
    }

    public static AccessCondition generateIfModifiedSinceCondition(Date lastMotified) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.ifModifiedSinceDate = lastMotified;
        return retCondition;
    }

    public static AccessCondition generateIfNoneMatchCondition(String etag) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.setIfNoneMatch(etag);
        return retCondition;
    }

    public static AccessCondition generateIfNotModifiedSinceCondition(Date lastMotified) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.ifUnmodifiedSinceDate = lastMotified;
        return retCondition;
    }

    public static AccessCondition generateIfSequenceNumberLessThanOrEqualCondition(long sequenceNumber) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.ifSequenceNumberLessThanOrEqual = sequenceNumber;
        return retCondition;
    }

    public static AccessCondition generateIfSequenceNumberLessThanCondition(long sequenceNumber) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.ifSequenceNumberLessThan = sequenceNumber;
        return retCondition;
    }

    public static AccessCondition generateIfSequenceNumberEqualCondition(long sequenceNumber) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.ifSequenceNumberEqual = sequenceNumber;
        return retCondition;
    }

    public static AccessCondition generateLeaseCondition(String leaseID) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.leaseID = leaseID;
        return retCondition;
    }

    public void applyConditionToRequest(HttpURLConnection request) {
        this.applyLeaseConditionToRequest(request);
        if (this.ifModifiedSinceDate != null) {
            request.setRequestProperty("If-Modified-Since", Utility.getGMTTime(this.ifModifiedSinceDate));
        }
        if (this.ifUnmodifiedSinceDate != null) {
            request.setRequestProperty("If-Unmodified-Since", Utility.getGMTTime(this.ifUnmodifiedSinceDate));
        }
        if (!Utility.isNullOrEmpty(this.ifMatchETag)) {
            request.setRequestProperty("If-Match", this.ifMatchETag);
        }
        if (!Utility.isNullOrEmpty(this.ifNoneMatchETag)) {
            request.setRequestProperty("If-None-Match", this.ifNoneMatchETag);
        }
    }

    public void applySourceConditionToRequest(HttpURLConnection request) {
        if (!Utility.isNullOrEmpty(this.leaseID)) {
            throw new IllegalArgumentException("A lease condition cannot be specified on the source of a copy.");
        }
        if (this.ifModifiedSinceDate != null) {
            request.setRequestProperty("x-ms-source-if-modified-since", Utility.getGMTTime(this.ifModifiedSinceDate));
        }
        if (this.ifUnmodifiedSinceDate != null) {
            request.setRequestProperty("x-ms-source-if-unmodified-since", Utility.getGMTTime(this.ifUnmodifiedSinceDate));
        }
        if (!Utility.isNullOrEmpty(this.ifMatchETag)) {
            request.setRequestProperty("x-ms-source-if-match", this.ifMatchETag);
        }
        if (!Utility.isNullOrEmpty(this.ifNoneMatchETag)) {
            request.setRequestProperty("x-ms-source-if-none-match", this.ifNoneMatchETag);
        }
    }

    public void applyLeaseConditionToRequest(HttpURLConnection request) {
        if (!Utility.isNullOrEmpty(this.leaseID)) {
            request.setRequestProperty("x-ms-lease-id", this.leaseID);
        }
    }

    public void applySequenceConditionToRequest(HttpURLConnection request) {
        if (this.ifSequenceNumberLessThanOrEqual != null) {
            request.setRequestProperty("x-ms-if-sequence-number-le", this.ifSequenceNumberLessThanOrEqual.toString());
        }
        if (this.ifSequenceNumberLessThan != null) {
            request.setRequestProperty("x-ms-if-sequence-number-lt", this.ifSequenceNumberLessThan.toString());
        }
        if (this.ifSequenceNumberEqual != null) {
            request.setRequestProperty("x-ms-if-sequence-number-eq", this.ifSequenceNumberEqual.toString());
        }
    }

    public String getIfMatch() {
        return this.ifMatchETag;
    }

    public Date getIfModifiedSinceDate() {
        return this.ifModifiedSinceDate;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatchETag;
    }

    public Date getIfUnmodifiedSinceDate() {
        return this.ifUnmodifiedSinceDate;
    }

    public String getLeaseID() {
        return this.leaseID;
    }

    public Long getIfSequenceNumberLessThanOrEqual() {
        return this.ifSequenceNumberLessThanOrEqual;
    }

    public Long getIfSequenceNumberLessThan() {
        return this.ifSequenceNumberLessThan;
    }

    public Long getIfSequenceNumberEqual() {
        return this.ifSequenceNumberEqual;
    }

    public void setIfMatch(String etag) {
        this.ifMatchETag = AccessCondition.normalizeEtag(etag);
    }

    public void setIfModifiedSinceDate(Date ifModifiedSinceDate) {
        this.ifModifiedSinceDate = ifModifiedSinceDate;
    }

    public void setIfNoneMatch(String etag) {
        this.ifNoneMatchETag = AccessCondition.normalizeEtag(etag);
    }

    public void setIfUnmodifiedSinceDate(Date ifUnmodifiedSinceDate) {
        this.ifUnmodifiedSinceDate = ifUnmodifiedSinceDate;
    }

    public void setLeaseID(String leaseID) {
        this.leaseID = leaseID;
    }

    public void setIfSequenceNumberLessThanOrEqual(Long sequenceNumber) {
        this.ifSequenceNumberLessThanOrEqual = sequenceNumber;
    }

    public void setIfSequenceNumberLessThan(Long sequenceNumber) {
        this.ifSequenceNumberLessThan = sequenceNumber;
    }

    public void setIfSequenceNumberEqual(Long sequenceNumber) {
        this.ifSequenceNumberEqual = sequenceNumber;
    }

    public boolean verifyConditional(String etag, Date lastModified) {
        if (this.ifModifiedSinceDate != null && !lastModified.after(this.ifModifiedSinceDate)) {
            return false;
        }
        if (this.ifUnmodifiedSinceDate != null && lastModified.after(this.ifUnmodifiedSinceDate)) {
            return false;
        }
        if (!(Utility.isNullOrEmpty(this.ifMatchETag) || this.ifMatchETag.equals(etag) || this.ifMatchETag.equals("*"))) {
            return false;
        }
        return Utility.isNullOrEmpty(this.ifNoneMatchETag) || !this.ifNoneMatchETag.equals(etag);
    }

    private static String normalizeEtag(String inTag) {
        if (Utility.isNullOrEmpty(inTag) || inTag.equals("*")) {
            return inTag;
        }
        if (inTag.startsWith("\"") && inTag.endsWith("\"")) {
            return inTag;
        }
        return String.format("\"%s\"", inTag);
    }
}

