/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.file;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.DoesServiceRequest;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultContinuationType;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.LazySegmentedIterable;
import com.microsoft.azure.storage.core.ListResponse;
import com.microsoft.azure.storage.core.ListingContext;
import com.microsoft.azure.storage.core.PathUtility;
import com.microsoft.azure.storage.core.RequestLocationMode;
import com.microsoft.azure.storage.core.SegmentedStorageRequest;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.file.CloudFile;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.file.CloudFileShare;
import com.microsoft.azure.storage.file.FileDirectoryProperties;
import com.microsoft.azure.storage.file.FileListHandler;
import com.microsoft.azure.storage.file.FileRequest;
import com.microsoft.azure.storage.file.FileRequestOptions;
import com.microsoft.azure.storage.file.FileResponse;
import com.microsoft.azure.storage.file.ListFileItem;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;

public final class CloudFileDirectory
implements ListFileItem {
    private CloudFileShare share;
    private CloudFileDirectory parent;
    private CloudFileClient fileServiceClient;
    private StorageUri storageUri;
    private String name;
    private FileDirectoryProperties properties;

    public CloudFileDirectory(URI directoryAbsoluteUri, CloudFileClient client) throws StorageException, URISyntaxException {
        this(new StorageUri(directoryAbsoluteUri), client);
    }

    public CloudFileDirectory(StorageUri directoryAbsoluteUri, CloudFileClient client) throws StorageException, URISyntaxException {
        Utility.assertNotNull("directoryAbsoluteUri", directoryAbsoluteUri);
        this.fileServiceClient = client;
        this.storageUri = directoryAbsoluteUri;
        this.properties = new FileDirectoryProperties();
        this.parseQueryAndVerify(directoryAbsoluteUri, client, client == null ? Utility.determinePathStyleFromUri(this.storageUri.getPrimaryUri()) : client.isUsePathStyleUris());
    }

    protected CloudFileDirectory(StorageUri uri, String directoryName, CloudFileShare share) {
        Utility.assertNotNull("uri", uri);
        Utility.assertNotNull("directoryName", directoryName);
        Utility.assertNotNull("share", share);
        this.name = directoryName;
        this.fileServiceClient = share.getServiceClient();
        this.share = share;
        this.storageUri = uri;
        this.properties = new FileDirectoryProperties();
    }

    @DoesServiceRequest
    public void create() throws StorageException {
        this.create(null, null);
    }

    @DoesServiceRequest
    public void create(FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.createDirectoryImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileDirectory, Void> createDirectoryImpl(final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileDirectory, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileDirectory, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileDirectory directory, OperationContext context) throws Exception {
                HttpURLConnection request = FileRequest.createDirectory(directory.getTransformedAddress().getUri(this.getCurrentLocation()), options, context);
                return request;
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public Void preProcessResponse(CloudFileDirectory directory, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                FileDirectoryProperties properties = FileResponse.getFileDirectoryProperties(this.getConnection());
                directory.properties = properties;
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public boolean createIfNotExists() throws StorageException {
        return this.createIfNotExists(null, null);
    }

    @DoesServiceRequest
    public boolean createIfNotExists(FileRequestOptions options, OperationContext opContext) throws StorageException {
        boolean exists = this.exists(true, null, options = FileRequestOptions.applyDefaults(options, this.fileServiceClient), opContext);
        if (exists) {
            return false;
        }
        try {
            this.create(options, opContext);
            return true;
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 409 && "ResourceAlreadyExists".equals(e.getErrorCode())) {
                return false;
            }
            throw e;
        }
    }

    @DoesServiceRequest
    public void delete() throws StorageException {
        this.delete(null, null, null);
    }

    @DoesServiceRequest
    public void delete(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.deleteDirectoryImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileDirectory, Void> deleteDirectoryImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileDirectory, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileDirectory, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileDirectory directory, OperationContext context) throws Exception {
                return FileRequest.deleteDirectory(directory.getStorageUri().getPrimaryUri(), options, context, accessCondition);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public Void preProcessResponse(CloudFileDirectory directory, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public boolean deleteIfExists() throws StorageException {
        return this.deleteIfExists(null, null, null);
    }

    @DoesServiceRequest
    public boolean deleteIfExists(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        boolean exists = this.exists(true, accessCondition, options = FileRequestOptions.applyDefaults(options, this.fileServiceClient), opContext);
        if (exists) {
            try {
                this.delete(accessCondition, options, opContext);
                return true;
            }
            catch (StorageException e) {
                if (e.getHttpStatusCode() == 404 && "ResourceNotFound".equals(e.getErrorCode())) {
                    return false;
                }
                throw e;
            }
        }
        return false;
    }

    @DoesServiceRequest
    public boolean exists() throws StorageException {
        return this.exists(null, null, null);
    }

    @DoesServiceRequest
    public boolean exists(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        return this.exists(false, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    private boolean exists(boolean primaryOnly, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this.fileServiceClient);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.existsImpl(primaryOnly, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileDirectory, Boolean> existsImpl(final boolean primaryOnly, final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileDirectory, Boolean> getRequest = new StorageRequest<CloudFileClient, CloudFileDirectory, Boolean>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(primaryOnly ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileDirectory directory, OperationContext context) throws Exception {
                return FileRequest.getDirectoryProperties(directory.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public Boolean preProcessResponse(CloudFileDirectory directory, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() == 200) {
                    directory.updatePropertiesFromResponse(this.getConnection());
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return getRequest;
    }

    private void updatePropertiesFromResponse(HttpURLConnection request) {
        this.getProperties().setEtag(request.getHeaderField("ETag"));
        if (0L != request.getLastModified()) {
            Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
            lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
            lastModifiedCalendar.setTime(new Date(request.getLastModified()));
            this.getProperties().setLastModified(lastModifiedCalendar.getTime());
        }
    }

    @DoesServiceRequest
    public void downloadAttributes() throws StorageException {
        this.downloadAttributes(null, null, null);
    }

    @DoesServiceRequest
    public void downloadAttributes(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.downloadAttributesImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileDirectory, Void> downloadAttributesImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileDirectory, Void> getRequest = new StorageRequest<CloudFileClient, CloudFileDirectory, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileDirectory directory, OperationContext context) throws Exception {
                return FileRequest.getDirectoryProperties(directory.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public Void preProcessResponse(CloudFileDirectory directory, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                FileDirectoryProperties properties = FileResponse.getFileDirectoryProperties(this.getConnection());
                directory.properties = properties;
                return null;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public Iterable<ListFileItem> listFilesAndDirectories() {
        return this.listFilesAndDirectories(null, null);
    }

    @DoesServiceRequest
    public Iterable<ListFileItem> listFilesAndDirectories(FileRequestOptions options, OperationContext opContext) {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this.fileServiceClient);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        return new LazySegmentedIterable<CloudFileClient, CloudFileDirectory, ListFileItem>(this.listFilesAndDirectoriesSegmentedImpl(-1, options, segmentedRequest), this.fileServiceClient, this, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public ResultSegment<ListFileItem> listFilesAndDirectoriesSegmented() throws StorageException {
        return this.listFilesAndDirectoriesSegmented(0, null, null, null);
    }

    public ResultSegment<ListFileItem> listFilesAndDirectoriesSegmented(int maxResults, ResultContinuation continuationToken, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this.fileServiceClient);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.FILE);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.listFilesAndDirectoriesSegmentedImpl(maxResults, options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileDirectory, ResultSegment<ListFileItem>> listFilesAndDirectoriesSegmentedImpl(final int maxResults, final FileRequestOptions options, final SegmentedStorageRequest segmentedRequest) {
        Utility.assertContinuationType(segmentedRequest.getToken(), ResultContinuationType.FILE);
        final ListingContext listingContext = new ListingContext(null, maxResults);
        StorageRequest<CloudFileClient, CloudFileDirectory, ResultSegment<ListFileItem>> getRequest = new StorageRequest<CloudFileClient, CloudFileDirectory, ResultSegment<ListFileItem>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileDirectory directory, OperationContext context) throws Exception {
                listingContext.setMarker(segmentedRequest.getToken() != null ? segmentedRequest.getToken().getNextMarker() : null);
                return FileRequest.listFilesAndDirectories(directory.getUri(), options, context, listingContext);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public ResultSegment<ListFileItem> preProcessResponse(CloudFileDirectory directory, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ResultSegment<ListFileItem> postProcessResponse(HttpURLConnection connection, CloudFileDirectory directory, CloudFileClient client, OperationContext context, ResultSegment<ListFileItem> storageObject) throws Exception {
                ListResponse<ListFileItem> response = FileListHandler.getFileAndDirectoryList(this.getConnection().getInputStream(), directory);
                ResultContinuation newToken = null;
                if (response.getNextMarker() != null) {
                    newToken = new ResultContinuation();
                    newToken.setNextMarker(response.getNextMarker());
                    newToken.setContinuationType(ResultContinuationType.FILE);
                    newToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                ResultSegment<ListFileItem> resSegment = new ResultSegment<ListFileItem>(response.getResults(), maxResults, newToken);
                segmentedRequest.setToken(resSegment.getContinuationToken());
                return resSegment;
            }
        };
        return getRequest;
    }

    public CloudFile getFileReference(String fileName) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("fileName", fileName);
        StorageUri subdirectoryUri = PathUtility.appendPathToUri(this.storageUri, fileName);
        return new CloudFile(subdirectoryUri, this.fileServiceClient, this.getShare());
    }

    public CloudFileDirectory getSubDirectoryReference(String itemName) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("itemName", itemName);
        StorageUri subdirectoryUri = PathUtility.appendPathToUri(this.storageUri, itemName);
        return new CloudFileDirectory(subdirectoryUri, itemName, this.getShare());
    }

    @Override
    public URI getUri() {
        return this.storageUri.getPrimaryUri();
    }

    @Override
    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    public CloudFileClient getServiceClient() {
        return this.fileServiceClient;
    }

    public String getName() {
        return this.name;
    }

    public FileDirectoryProperties getProperties() {
        return this.properties;
    }

    @Override
    public CloudFileDirectory getParent() throws URISyntaxException, StorageException {
        String parentName;
        if (this.parent == null && (parentName = CloudFile.getParentNameFromURI(this.getStorageUri(), this.getShare())) != null) {
            StorageUri parentURI = PathUtility.appendPathToUri(this.getShare().getStorageUri(), parentName);
            this.parent = new CloudFileDirectory(parentURI, this.getServiceClient());
        }
        return this.parent;
    }

    @Override
    public CloudFileShare getShare() throws StorageException, URISyntaxException {
        if (this.share == null) {
            this.share = this.fileServiceClient.getShareReference(PathUtility.getShareNameFromUri(this.getUri(), this.fileServiceClient.isUsePathStyleUris()));
        }
        return this.share;
    }

    protected final void setShare(CloudFileShare share) {
        this.share = share;
    }

    protected final void setProperties(FileDirectoryProperties properties) {
        this.properties = properties;
    }

    protected void setStorageUri(StorageUri storageUri) {
        this.storageUri = storageUri;
    }

    private void parseQueryAndVerify(StorageUri completeUri, CloudFileClient existingClient, boolean usePathStyleUri) throws StorageException, URISyntaxException {
        Utility.assertNotNull("completeUri", completeUri);
        if (!completeUri.isAbsolute()) {
            String errorMessage = String.format("Address %s is a relative address. Only absolute addresses are permitted.", completeUri.toString());
            throw new IllegalArgumentException(errorMessage);
        }
        this.storageUri = PathUtility.stripURIQueryAndFragment(completeUri);
        this.fileServiceClient = existingClient == null ? new CloudFileClient(PathUtility.getServiceClientBaseAddress(this.storageUri, usePathStyleUri), null) : existingClient;
        this.name = PathUtility.getFileNameFromURI(completeUri.getPrimaryUri(), usePathStyleUri);
    }

    private StorageUri getTransformedAddress() throws URISyntaxException, StorageException {
        return this.fileServiceClient.getCredentials().transformUri(this.storageUri);
    }
}

