/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.analytics.CloudAnalyticsClient;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.core.StorageCredentialsHelper;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.queue.CloudQueueClient;
import com.microsoft.azure.storage.table.CloudTableClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class CloudStorageAccount {
    protected static final String ACCOUNT_KEY_NAME = "AccountKey";
    protected static final String ACCOUNT_NAME_NAME = "AccountName";
    private static final String BLOB_BASE_DNS_NAME = "blob.core.windows.net";
    private static final String SECONDARY_LOCATION_ACCOUNT_SUFFIX = "-secondary";
    protected static final String BLOB_ENDPOINT_NAME = "BlobEndpoint";
    private static final String DEFAULT_ENDPOINTS_PROTOCOL_NAME = "DefaultEndpointsProtocol";
    private static final String DEVELOPMENT_STORAGE_PRIMARY_ENDPOINT_FORMAT = "%s://%s:%s/%s";
    private static final String DEVELOPMENT_STORAGE_SECONDARY_ENDPOINT_FORMAT = "%s://%s:%s/%s-secondary";
    private static final String DEVELOPMENT_STORAGE_PROXY_URI_NAME = "DevelopmentStorageProxyUri";
    private static final String DEVSTORE_ACCOUNT_KEY = "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
    private static final String DEVSTORE_ACCOUNT_NAME = "devstoreaccount1";
    private static final String FILE_BASE_DNS_NAME = "file.core.windows.net";
    private static final String FILE_ENDPOINT_NAME = "FileEndpoint";
    private static final String PRIMARY_ENDPOINT_FORMAT = "%s://%s.%s";
    private static final String SECONDARY_ENDPOINT_FORMAT = "%s://%s%s.%s";
    protected static final String QUEUE_BASE_DNS_NAME = "queue.core.windows.net";
    protected static final String QUEUE_ENDPOINT_NAME = "QueueEndpoint";
    protected static final String SHARED_ACCESS_SIGNATURE_NAME = "SharedAccessSignature";
    protected static final String TABLE_BASE_DNS_NAME = "table.core.windows.net";
    protected static final String TABLE_ENDPOINT_NAME = "TableEndpoint";
    private static final String USE_DEVELOPMENT_STORAGE_NAME = "UseDevelopmentStorage";
    private final StorageUri blobStorageUri;
    private final StorageUri fileStorageUri;
    private final StorageUri queueStorageUri;
    private final StorageUri tableStorageUri;
    private StorageCredentials credentials;
    private boolean isBlobEndpointDefault = false;
    private boolean isFileEndpointDefault = false;
    private boolean isQueueEndpointDefault = false;
    private boolean isTableEndpointDefault = false;
    private boolean isDevStoreAccount = false;

    private static StorageUri getDefaultStorageUri(HashMap<String, String> settings, String serviceDNS) throws URISyntaxException {
        String scheme = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) != null ? settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) : "http";
        String accountName = settings.get(ACCOUNT_NAME_NAME);
        return CloudStorageAccount.getDefaultStorageUri(scheme, accountName, serviceDNS);
    }

    private static StorageUri getDefaultStorageUri(String scheme, String accountName, String serviceDNS) throws URISyntaxException {
        if (Utility.isNullOrEmpty(scheme)) {
            throw new IllegalArgumentException("The protocol to use is null. Please specify whether to use http or https.");
        }
        if (Utility.isNullOrEmpty(accountName)) {
            throw new IllegalArgumentException("The account name is null or empty.");
        }
        return new StorageUri(new URI(String.format(PRIMARY_ENDPOINT_FORMAT, scheme, accountName, serviceDNS)), new URI(String.format(SECONDARY_ENDPOINT_FORMAT, scheme, accountName, SECONDARY_LOCATION_ACCOUNT_SUFFIX, serviceDNS)));
    }

    public static CloudStorageAccount getDevelopmentStorageAccount() {
        try {
            return CloudStorageAccount.getDevelopmentStorageAccount(null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static CloudStorageAccount getDevelopmentStorageAccount(URI proxyUri) throws URISyntaxException {
        String host;
        String scheme;
        if (proxyUri == null) {
            scheme = "http";
            host = "127.0.0.1";
        } else {
            scheme = proxyUri.getScheme();
            host = proxyUri.getHost();
        }
        StorageCredentialsAccountAndKey credentials = new StorageCredentialsAccountAndKey(DEVSTORE_ACCOUNT_NAME, DEVSTORE_ACCOUNT_KEY);
        URI blobPrimaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_PRIMARY_ENDPOINT_FORMAT, scheme, host, "10000", DEVSTORE_ACCOUNT_NAME));
        URI queuePrimaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_PRIMARY_ENDPOINT_FORMAT, scheme, host, "10001", DEVSTORE_ACCOUNT_NAME));
        URI tablePrimaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_PRIMARY_ENDPOINT_FORMAT, scheme, host, "10002", DEVSTORE_ACCOUNT_NAME));
        URI blobSecondaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_SECONDARY_ENDPOINT_FORMAT, scheme, host, "10000", DEVSTORE_ACCOUNT_NAME));
        URI queueSecondaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_SECONDARY_ENDPOINT_FORMAT, scheme, host, "10001", DEVSTORE_ACCOUNT_NAME));
        URI tableSecondaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_SECONDARY_ENDPOINT_FORMAT, scheme, host, "10002", DEVSTORE_ACCOUNT_NAME));
        CloudStorageAccount account = new CloudStorageAccount((StorageCredentials)credentials, new StorageUri(blobPrimaryEndpoint, blobSecondaryEndpoint), new StorageUri(queuePrimaryEndpoint, queueSecondaryEndpoint), new StorageUri(tablePrimaryEndpoint, tableSecondaryEndpoint), null);
        account.isDevStoreAccount = true;
        return account;
    }

    public static CloudStorageAccount parse(String connectionString) throws URISyntaxException, InvalidKeyException {
        if (connectionString == null || connectionString.length() == 0) {
            throw new IllegalArgumentException("Invalid connection string.");
        }
        HashMap<String, String> settings = Utility.parseAccountString(connectionString);
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            if (entry.getValue() != null && !entry.getValue().equals("") || entry.getKey().equals(ACCOUNT_KEY_NAME)) continue;
            throw new IllegalArgumentException("Invalid connection string.");
        }
        CloudStorageAccount retVal = CloudStorageAccount.tryConfigureDevStore(settings);
        if (retVal != null) {
            return retVal;
        }
        retVal = CloudStorageAccount.tryConfigureServiceAccount(settings);
        if (retVal != null) {
            return retVal;
        }
        throw new IllegalArgumentException("Invalid connection string.");
    }

    private static CloudStorageAccount tryConfigureDevStore(HashMap<String, String> settings) throws URISyntaxException {
        if (settings.containsKey(USE_DEVELOPMENT_STORAGE_NAME)) {
            if (!Boolean.parseBoolean(settings.get(USE_DEVELOPMENT_STORAGE_NAME))) {
                throw new IllegalArgumentException("Invalid connection string, the UseDevelopmentStorage key must always be paired with 'true'.  Remove the flag entirely otherwise.");
            }
            URI devStoreProxyUri = null;
            if (settings.containsKey(DEVELOPMENT_STORAGE_PROXY_URI_NAME)) {
                devStoreProxyUri = new URI(settings.get(DEVELOPMENT_STORAGE_PROXY_URI_NAME));
            }
            return CloudStorageAccount.getDevelopmentStorageAccount(devStoreProxyUri);
        }
        return null;
    }

    private static CloudStorageAccount tryConfigureServiceAccount(HashMap<String, String> settings) throws URISyntaxException, InvalidKeyException {
        String defaultEndpointSetting;
        if (settings.containsKey(USE_DEVELOPMENT_STORAGE_NAME)) {
            String useDevStoreSetting = settings.get(USE_DEVELOPMENT_STORAGE_NAME);
            if (!Boolean.parseBoolean(useDevStoreSetting)) {
                throw new IllegalArgumentException("Invalid connection string, the UseDevelopmentStorage key must always be paired with 'true'.  Remove the flag entirely otherwise.");
            }
            return null;
        }
        String string = defaultEndpointSetting = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) != null ? settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME).toLowerCase() : null;
        if (defaultEndpointSetting != null && !defaultEndpointSetting.equals("http") && !defaultEndpointSetting.equals("https")) {
            return null;
        }
        StorageCredentials credentials = StorageCredentials.tryParseCredentials(settings);
        boolean isExplicitBlobEndpoint = settings.containsKey(BLOB_ENDPOINT_NAME);
        boolean isExplicitFileEndpoint = settings.containsKey(FILE_ENDPOINT_NAME);
        boolean isExplicitQueueEndpoint = settings.containsKey(QUEUE_ENDPOINT_NAME);
        boolean isExplicitTableEndpoint = settings.containsKey(TABLE_ENDPOINT_NAME);
        StorageUri blobURI = isExplicitBlobEndpoint ? new StorageUri(new URI(settings.get(BLOB_ENDPOINT_NAME))) : null;
        StorageUri fileURI = isExplicitFileEndpoint ? new StorageUri(new URI(settings.get(FILE_ENDPOINT_NAME))) : null;
        StorageUri queueURI = isExplicitQueueEndpoint ? new StorageUri(new URI(settings.get(QUEUE_ENDPOINT_NAME))) : null;
        StorageUri tableURI = isExplicitTableEndpoint ? new StorageUri(new URI(settings.get(TABLE_ENDPOINT_NAME))) : null;
        CloudStorageAccount retVal = null;
        if (defaultEndpointSetting != null && settings.containsKey(ACCOUNT_NAME_NAME) && settings.containsKey(ACCOUNT_KEY_NAME)) {
            retVal = new CloudStorageAccount(credentials, isExplicitBlobEndpoint ? blobURI : CloudStorageAccount.getDefaultStorageUri(settings, BLOB_BASE_DNS_NAME), isExplicitQueueEndpoint ? queueURI : CloudStorageAccount.getDefaultStorageUri(settings, QUEUE_BASE_DNS_NAME), isExplicitTableEndpoint ? tableURI : CloudStorageAccount.getDefaultStorageUri(settings, TABLE_BASE_DNS_NAME), isExplicitFileEndpoint ? fileURI : CloudStorageAccount.getDefaultStorageUri(settings, FILE_BASE_DNS_NAME));
            retVal.isBlobEndpointDefault = !isExplicitBlobEndpoint;
            retVal.isFileEndpointDefault = !isExplicitFileEndpoint;
            retVal.isQueueEndpointDefault = !isExplicitQueueEndpoint;
            retVal.isTableEndpointDefault = !isExplicitTableEndpoint;
        } else if (isExplicitBlobEndpoint || isExplicitQueueEndpoint || isExplicitTableEndpoint || isExplicitFileEndpoint) {
            retVal = new CloudStorageAccount(credentials, blobURI, queueURI, tableURI, fileURI);
        }
        return retVal;
    }

    public CloudStorageAccount(StorageCredentials storageCredentials) throws URISyntaxException {
        Utility.assertNotNull("storageCredentials", storageCredentials);
        this.credentials = storageCredentials;
        this.isBlobEndpointDefault = true;
        this.isFileEndpointDefault = true;
        this.isQueueEndpointDefault = true;
        this.isTableEndpointDefault = true;
        this.blobStorageUri = CloudStorageAccount.getDefaultStorageUri("http", this.credentials.getAccountName(), BLOB_BASE_DNS_NAME);
        this.fileStorageUri = CloudStorageAccount.getDefaultStorageUri("http", this.credentials.getAccountName(), FILE_BASE_DNS_NAME);
        this.queueStorageUri = CloudStorageAccount.getDefaultStorageUri("http", this.credentials.getAccountName(), QUEUE_BASE_DNS_NAME);
        this.tableStorageUri = CloudStorageAccount.getDefaultStorageUri("http", this.credentials.getAccountName(), TABLE_BASE_DNS_NAME);
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, URI blobEndpoint, URI queueEndpoint, URI tableEndpoint) {
        this(storageCredentials, new StorageUri(blobEndpoint), new StorageUri(queueEndpoint), new StorageUri(tableEndpoint), null);
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, URI blobEndpoint, URI queueEndpoint, URI tableEndpoint, URI fileEndpoint) {
        this(storageCredentials, new StorageUri(blobEndpoint), new StorageUri(queueEndpoint), new StorageUri(tableEndpoint), new StorageUri(fileEndpoint));
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, StorageUri blobStorageUri, StorageUri queueStorageUri, StorageUri tableStorageUri) {
        this(storageCredentials, blobStorageUri, queueStorageUri, tableStorageUri, null);
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, StorageUri blobStorageUri, StorageUri queueStorageUri, StorageUri tableStorageUri, StorageUri fileStorageUri) {
        this.credentials = storageCredentials;
        this.blobStorageUri = blobStorageUri;
        this.fileStorageUri = fileStorageUri;
        this.queueStorageUri = queueStorageUri;
        this.tableStorageUri = tableStorageUri;
    }

    public CloudStorageAccount(StorageCredentialsAccountAndKey storageCredentials, boolean useHttps) throws URISyntaxException {
        Utility.assertNotNull("storageCredentials", storageCredentials);
        this.credentials = storageCredentials;
        this.blobStorageUri = CloudStorageAccount.getDefaultStorageUri(useHttps ? "https" : "http", storageCredentials.getAccountName(), BLOB_BASE_DNS_NAME);
        this.fileStorageUri = CloudStorageAccount.getDefaultStorageUri(useHttps ? "https" : "http", storageCredentials.getAccountName(), FILE_BASE_DNS_NAME);
        this.queueStorageUri = CloudStorageAccount.getDefaultStorageUri(useHttps ? "https" : "http", storageCredentials.getAccountName(), QUEUE_BASE_DNS_NAME);
        this.tableStorageUri = CloudStorageAccount.getDefaultStorageUri(useHttps ? "https" : "http", storageCredentials.getAccountName(), TABLE_BASE_DNS_NAME);
        this.isBlobEndpointDefault = true;
        this.isFileEndpointDefault = true;
        this.isQueueEndpointDefault = true;
        this.isTableEndpointDefault = true;
    }

    public CloudAnalyticsClient createCloudAnalyticsClient() {
        if (this.getBlobStorageUri() == null) {
            throw new IllegalArgumentException("No blob endpoint configured.");
        }
        if (this.getTableStorageUri() == null) {
            throw new IllegalArgumentException("No table endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        return new CloudAnalyticsClient(this.getBlobStorageUri(), this.getTableStorageUri(), this.getCredentials());
    }

    public CloudBlobClient createCloudBlobClient() {
        if (this.getBlobStorageUri() == null) {
            throw new IllegalArgumentException("No blob endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.credentials)) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudBlobClient(this.getBlobStorageUri(), this.getCredentials());
    }

    public CloudFileClient createCloudFileClient() {
        if (this.getFileStorageUri() == null) {
            throw new IllegalArgumentException("No file endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.credentials)) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudFileClient(this.getFileStorageUri(), this.getCredentials());
    }

    public CloudQueueClient createCloudQueueClient() {
        if (this.getQueueStorageUri() == null) {
            throw new IllegalArgumentException("No queue endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.credentials)) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudQueueClient(this.getQueueStorageUri(), this.getCredentials());
    }

    public CloudTableClient createCloudTableClient() {
        if (this.getTableStorageUri() == null) {
            throw new IllegalArgumentException("No table endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.credentials)) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudTableClient(this.getTableStorageUri(), this.getCredentials());
    }

    public URI getBlobEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        if (this.blobStorageUri == null) {
            return null;
        }
        return this.blobStorageUri.getPrimaryUri();
    }

    public StorageUri getBlobStorageUri() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.blobStorageUri;
    }

    public URI getFileEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        if (this.fileStorageUri == null) {
            return null;
        }
        return this.fileStorageUri.getPrimaryUri();
    }

    public StorageUri getFileStorageUri() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.fileStorageUri;
    }

    public StorageCredentials getCredentials() {
        return this.credentials;
    }

    public URI getQueueEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        if (this.queueStorageUri == null) {
            return null;
        }
        return this.queueStorageUri.getPrimaryUri();
    }

    public StorageUri getQueueStorageUri() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.queueStorageUri;
    }

    public URI getTableEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        if (this.tableStorageUri == null) {
            return null;
        }
        return this.tableStorageUri.getPrimaryUri();
    }

    public StorageUri getTableStorageUri() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.tableStorageUri;
    }

    protected void setCredentials(StorageCredentials credentials) {
        this.credentials = credentials;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean exportSecrets) {
        if (this.credentials != null && Utility.isNullOrEmpty(this.credentials.getAccountName())) {
            return this.credentials.toString(exportSecrets);
        }
        ArrayList<String> retVals = new ArrayList<String>();
        if (this.isDevStoreAccount) {
            retVals.add(String.format("%s=true", USE_DEVELOPMENT_STORAGE_NAME));
            if (!this.getBlobEndpoint().toString().equals("http://127.0.0.1:10000/devstoreaccount1")) {
                retVals.add(String.format("%s=%s://%s/", DEVELOPMENT_STORAGE_PROXY_URI_NAME, this.getBlobEndpoint().getScheme(), this.getBlobEndpoint().getHost()));
            }
        } else {
            boolean addDefault = false;
            if (this.getBlobStorageUri() != null) {
                if (this.isBlobEndpointDefault) {
                    addDefault = true;
                } else {
                    retVals.add(String.format("%s=%s", BLOB_ENDPOINT_NAME, this.getBlobEndpoint()));
                }
            }
            if (this.getQueueStorageUri() != null) {
                if (this.isQueueEndpointDefault) {
                    addDefault = true;
                } else {
                    retVals.add(String.format("%s=%s", QUEUE_ENDPOINT_NAME, this.getQueueEndpoint()));
                }
            }
            if (this.getTableStorageUri() != null) {
                if (this.isTableEndpointDefault) {
                    addDefault = true;
                } else {
                    retVals.add(String.format("%s=%s", TABLE_ENDPOINT_NAME, this.getTableEndpoint()));
                }
            }
            if (this.getFileStorageUri() != null) {
                if (this.isFileEndpointDefault) {
                    addDefault = true;
                } else {
                    retVals.add(String.format("%s=%s", FILE_ENDPOINT_NAME, this.getFileEndpoint()));
                }
            }
            if (addDefault) {
                retVals.add(String.format("%s=%s", DEFAULT_ENDPOINTS_PROTOCOL_NAME, this.getBlobEndpoint().getScheme()));
            }
            if (this.getCredentials() != null) {
                retVals.add(this.getCredentials().toString(exportSecrets));
            }
        }
        StringBuilder returnString = new StringBuilder();
        for (String val : retVals) {
            returnString.append(val);
            returnString.append(';');
        }
        if (retVals.size() > 0) {
            returnString.deleteCharAt(returnString.length() - 1);
        }
        return returnString.toString();
    }
}

