/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.storage.implementation.BlobContainersInner;
import com.microsoft.azure.management.storage.implementation.BlobServicesInner;
import com.microsoft.azure.management.storage.implementation.FileServicesInner;
import com.microsoft.azure.management.storage.implementation.FileSharesInner;
import com.microsoft.azure.management.storage.implementation.ManagementPoliciesInner;
import com.microsoft.azure.management.storage.implementation.OperationsInner;
import com.microsoft.azure.management.storage.implementation.PrivateEndpointConnectionsInner;
import com.microsoft.azure.management.storage.implementation.PrivateLinkResourcesInner;
import com.microsoft.azure.management.storage.implementation.SkusInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountsInner;
import com.microsoft.azure.management.storage.implementation.UsagesInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class StorageManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private OperationsInner operations;
    private SkusInner skus;
    private StorageAccountsInner storageAccounts;
    private UsagesInner usages;
    private ManagementPoliciesInner managementPolicies;
    private PrivateEndpointConnectionsInner privateEndpointConnections;
    private PrivateLinkResourcesInner privateLinkResources;
    private BlobServicesInner blobServices;
    private BlobContainersInner blobContainers;
    private FileServicesInner fileServices;
    private FileSharesInner fileShares;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public StorageManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public StorageManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public StorageManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public StorageManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public SkusInner skus() {
        return this.skus;
    }

    public StorageAccountsInner storageAccounts() {
        return this.storageAccounts;
    }

    public UsagesInner usages() {
        return this.usages;
    }

    public ManagementPoliciesInner managementPolicies() {
        return this.managementPolicies;
    }

    public PrivateEndpointConnectionsInner privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PrivateLinkResourcesInner privateLinkResources() {
        return this.privateLinkResources;
    }

    public BlobServicesInner blobServices() {
        return this.blobServices;
    }

    public BlobContainersInner blobContainers() {
        return this.blobContainers;
    }

    public FileServicesInner fileServices() {
        return this.fileServices;
    }

    public FileSharesInner fileShares() {
        return this.fileShares;
    }

    public StorageManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public StorageManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public StorageManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2019-06-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.skus = new SkusInner(this.restClient().retrofit(), this);
        this.storageAccounts = new StorageAccountsInner(this.restClient().retrofit(), this);
        this.usages = new UsagesInner(this.restClient().retrofit(), this);
        this.managementPolicies = new ManagementPoliciesInner(this.restClient().retrofit(), this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsInner(this.restClient().retrofit(), this);
        this.privateLinkResources = new PrivateLinkResourcesInner(this.restClient().retrofit(), this);
        this.blobServices = new BlobServicesInner(this.restClient().retrofit(), this);
        this.blobContainers = new BlobContainersInner(this.restClient().retrofit(), this);
        this.fileServices = new FileServicesInner(this.restClient().retrofit(), this);
        this.fileShares = new FileSharesInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "StorageManagementClient", "2019-06-01");
    }
}

