/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.resources.fluentcore.model.Attachable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Settable;
import com.microsoft.azure.management.storage.BlobTypes;
import com.microsoft.azure.management.storage.ManagementPolicy;
import com.microsoft.azure.management.storage.ManagementPolicyBaseBlob;
import com.microsoft.azure.management.storage.ManagementPolicyRule;
import com.microsoft.azure.management.storage.ManagementPolicySnapShot;
import java.util.List;

@Fluent
@Beta
public interface PolicyRule
extends HasInner<ManagementPolicyRule> {
    public String name();

    public String type();

    public List<BlobTypes> blobTypesToFilterFor();

    public List<String> prefixesToFilterFor();

    public ManagementPolicyBaseBlob actionsOnBaseBlob();

    public ManagementPolicySnapShot actionsOnSnapShot();

    public boolean tierToCoolActionOnBaseBlobEnabled();

    public boolean tierToArchiveActionOnBaseBlobEnabled();

    public boolean deleteActionOnBaseBlobEnabled();

    public boolean deleteActionOnSnapShotEnabled();

    public Double daysAfterBaseBlobModificationUntilCooling();

    public Double daysAfterBaseBlobModificationUntilArchiving();

    public Double daysAfterBaseBlobModificationUntilDeleting();

    public Double daysAfterSnapShotCreationUntilDeleting();

    public static interface UpdateStages {

        public static interface WithActions {
            public Update withTierToCoolActionOnBaseBlob(double var1);

            public Update withTierToArchiveActionOnBaseBlob(double var1);

            public Update withDeleteActionOnBaseBlob(double var1);

            public Update withDeleteActionOnSnapShot(double var1);

            public Update updateActionsOnBaseBlob(ManagementPolicyBaseBlob var1);

            public Update updateActionsOnSnapShot(ManagementPolicySnapShot var1);
        }

        public static interface WithPrefixesToFilterFor {
            public Update withPrefixesToFilterFor(List<String> var1);

            public Update withPrefixToFilterFor(String var1);

            public Update withoutPrefixesToFilterFor();
        }

        public static interface WithBlobTypesToFilterFor {
            public Update withBlobTypesToFilterFor(List<BlobTypes> var1);

            public Update withBlobTypeToFilterFor(BlobTypes var1);

            public Update withBlobTypeToFilterForRemoved(BlobTypes var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithPolicyRuleAttachable
        extends WithRuleActions,
        WithPrefixesToFilterFor,
        Attachable<ManagementPolicy.DefinitionStages.WithCreate> {
        }

        public static interface WithRuleActions {
            public WithPolicyRuleAttachable withTierToCoolActionOnBaseBlob(double var1);

            public WithPolicyRuleAttachable withTierToArchiveActionOnBaseBlob(double var1);

            public WithPolicyRuleAttachable withDeleteActionOnBaseBlob(double var1);

            public WithPolicyRuleAttachable withDeleteActionOnSnapShot(double var1);

            public WithPolicyRuleAttachable withActionsOnBaseBlob(ManagementPolicyBaseBlob var1);

            public WithPolicyRuleAttachable withActionsOnSnapShot(ManagementPolicySnapShot var1);
        }

        public static interface WithPrefixesToFilterFor {
            public WithRuleActions withPrefixesToFilterFor(List<String> var1);

            public WithRuleActions withPrefixToFilterFor(String var1);
        }

        public static interface PrefixActionFork
        extends WithPrefixesToFilterFor,
        WithRuleActions {
        }

        public static interface WithBlobTypesToFilterFor {
            public PrefixActionFork withBlobTypesToFilterFor(List<BlobTypes> var1);

            public PrefixActionFork withBlobTypeToFilterFor(BlobTypes var1);
        }

        public static interface WithPolicyRuleType {
            public WithBlobTypesToFilterFor withLifecycleRuleType();
        }

        public static interface Blank
        extends WithPolicyRuleType {
        }
    }

    public static interface Update
    extends UpdateStages.WithBlobTypesToFilterFor,
    UpdateStages.WithPrefixesToFilterFor,
    UpdateStages.WithActions,
    Settable<ManagementPolicy.Update> {
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithPolicyRuleType,
    DefinitionStages.WithBlobTypesToFilterFor,
    DefinitionStages.PrefixActionFork,
    DefinitionStages.WithPrefixesToFilterFor,
    DefinitionStages.WithRuleActions,
    DefinitionStages.WithPolicyRuleAttachable {
    }
}

