/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.TdeCertificateInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class TdeCertificatesInner {
    private TdeCertificatesService service;
    private SqlManagementClientImpl client;

    public TdeCertificatesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (TdeCertificatesService)retrofit.create(TdeCertificatesService.class);
        this.client = client;
    }

    public void create(String resourceGroupName, String serverName, TdeCertificateInner parameters) {
        ((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<Void> createAsync(String resourceGroupName, String serverName, TdeCertificateInner parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    public Observable<Void> createAsync(String resourceGroupName, String serverName, TdeCertificateInner parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, serverName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> createWithServiceResponseAsync(String resourceGroupName, String serverName, TdeCertificateInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, serverName, this.client.subscriptionId(), parameters, "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginCreate(String resourceGroupName, String serverName, TdeCertificateInner parameters) {
        ((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginCreateAsync(String resourceGroupName, String serverName, TdeCertificateInner parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    public Observable<Void> beginCreateAsync(String resourceGroupName, String serverName, TdeCertificateInner parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, serverName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginCreateWithServiceResponseAsync(String resourceGroupName, String serverName, TdeCertificateInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-10-01-preview";
        return this.service.beginCreate(resourceGroupName, serverName, this.client.subscriptionId(), parameters, "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TdeCertificatesInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface TdeCertificatesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.TdeCertificates create"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/tdeCertificates")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Body TdeCertificateInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.TdeCertificates beginCreate"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/tdeCertificates")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Body TdeCertificateInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

