/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.ManagedBackupShortTermRetentionPolicyInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ManagedBackupShortTermRetentionPoliciesInner {
    private ManagedBackupShortTermRetentionPoliciesService service;
    private SqlManagementClientImpl client;

    public ManagedBackupShortTermRetentionPoliciesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ManagedBackupShortTermRetentionPoliciesService)retrofit.create(ManagedBackupShortTermRetentionPoliciesService.class);
        this.client = client;
    }

    public ManagedBackupShortTermRetentionPolicyInner get(String resourceGroupName, String managedInstanceName, String databaseName) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName, ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    public Observable<ManagedBackupShortTermRetentionPolicyInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>(){

            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return (ManagedBackupShortTermRetentionPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>>>(){

            public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedBackupShortTermRetentionPoliciesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedBackupShortTermRetentionPolicyInner createOrUpdate(String resourceGroupName, String managedInstanceName, String databaseName) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    public Observable<ManagedBackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>(){

            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return (ManagedBackupShortTermRetentionPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-03-01-preview";
        Object retentionDays = null;
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(null);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>(){}.getType());
    }

    public ManagedBackupShortTermRetentionPolicyInner createOrUpdate(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, retentionDays).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays, ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, retentionDays), serviceCallback);
    }

    public Observable<ManagedBackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, retentionDays).map((Func1)new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>(){

            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return (ManagedBackupShortTermRetentionPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-03-01-preview";
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>(){}.getType());
    }

    public ManagedBackupShortTermRetentionPolicyInner beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, String databaseName) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    public Observable<ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>(){

            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return (ManagedBackupShortTermRetentionPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-03-01-preview";
        Object retentionDays = null;
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(null);
        return this.service.beginCreateOrUpdate(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>>>(){

            public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedBackupShortTermRetentionPoliciesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ManagedBackupShortTermRetentionPolicyInner beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, retentionDays).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays, ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, retentionDays), serviceCallback);
    }

    public Observable<ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, retentionDays).map((Func1)new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>(){

            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return (ManagedBackupShortTermRetentionPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-03-01-preview";
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        return this.service.beginCreateOrUpdate(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>>>(){

            public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedBackupShortTermRetentionPoliciesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedBackupShortTermRetentionPolicyInner update(String resourceGroupName, String managedInstanceName, String databaseName) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    public Observable<ManagedBackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>(){

            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return (ManagedBackupShortTermRetentionPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-03-01-preview";
        Object retentionDays = null;
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(null);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>(){}.getType());
    }

    public ManagedBackupShortTermRetentionPolicyInner update(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, retentionDays).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays, ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, retentionDays), serviceCallback);
    }

    public Observable<ManagedBackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays) {
        return this.updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, retentionDays).map((Func1)new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>(){

            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return (ManagedBackupShortTermRetentionPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-03-01-preview";
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>(){}.getType());
    }

    public ManagedBackupShortTermRetentionPolicyInner beginUpdate(String resourceGroupName, String managedInstanceName, String databaseName) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    public Observable<ManagedBackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>(){

            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return (ManagedBackupShortTermRetentionPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-03-01-preview";
        Object retentionDays = null;
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(null);
        return this.service.beginUpdate(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>>>(){

            public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedBackupShortTermRetentionPoliciesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ManagedBackupShortTermRetentionPolicyInner beginUpdate(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, retentionDays).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays, ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, retentionDays), serviceCallback);
    }

    public Observable<ManagedBackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, retentionDays).map((Func1)new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>(){

            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return (ManagedBackupShortTermRetentionPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, Integer retentionDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-03-01-preview";
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        return this.service.beginUpdate(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>>>(){

            public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedBackupShortTermRetentionPoliciesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedBackupShortTermRetentionPolicyInner> listByDatabase(String resourceGroupName, String managedInstanceName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single();
        return new PagedList<ManagedBackupShortTermRetentionPolicyInner>((Page)response.body()){

            public Page<ManagedBackupShortTermRetentionPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedBackupShortTermRetentionPoliciesInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedBackupShortTermRetentionPolicyInner>> listByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName, ListOperationCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> call(String nextPageLink) {
                return ManagedBackupShortTermRetentionPoliciesInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedBackupShortTermRetentionPolicyInner>> listByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>, Page<ManagedBackupShortTermRetentionPolicyInner>>(){

            public Page<ManagedBackupShortTermRetentionPolicyInner> call(ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>, Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> call(ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedBackupShortTermRetentionPoliciesInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> listByDatabaseSinglePageAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByDatabase(resourceGroupName, managedInstanceName, databaseName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedBackupShortTermRetentionPoliciesInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedBackupShortTermRetentionPolicyInner> listByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedBackupShortTermRetentionPolicyInner>((Page)response.body()){

            public Page<ManagedBackupShortTermRetentionPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedBackupShortTermRetentionPoliciesInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedBackupShortTermRetentionPolicyInner>> listByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<ManagedBackupShortTermRetentionPolicyInner>> serviceFuture, ListOperationCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> call(String nextPageLink) {
                return ManagedBackupShortTermRetentionPoliciesInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedBackupShortTermRetentionPolicyInner>> listByDatabaseNextAsync(String nextPageLink) {
        return this.listByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>, Page<ManagedBackupShortTermRetentionPolicyInner>>(){

            public Page<ManagedBackupShortTermRetentionPolicyInner> call(ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> listByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>, Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> call(ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedBackupShortTermRetentionPoliciesInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> listByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedBackupShortTermRetentionPoliciesInner.this.listByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>> listByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ManagedBackupShortTermRetentionPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedBackupShortTermRetentionPolicies get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="policyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedBackupShortTermRetentionPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="policyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ManagedBackupShortTermRetentionPolicyInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedBackupShortTermRetentionPolicies beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="policyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ManagedBackupShortTermRetentionPolicyInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedBackupShortTermRetentionPolicies update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="policyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ManagedBackupShortTermRetentionPolicyInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedBackupShortTermRetentionPolicies beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="policyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ManagedBackupShortTermRetentionPolicyInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedBackupShortTermRetentionPolicies listByDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/backupShortTermRetentionPolicies")
        public Observable<Response<ResponseBody>> listByDatabase(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedBackupShortTermRetentionPolicies listByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

