/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.DatabaseAutomaticTuningInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DatabaseAutomaticTuningsInner {
    private DatabaseAutomaticTuningsService service;
    private SqlManagementClientImpl client;

    public DatabaseAutomaticTuningsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (DatabaseAutomaticTuningsService)retrofit.create(DatabaseAutomaticTuningsService.class);
        this.client = client;
    }

    public DatabaseAutomaticTuningInner get(String resourceGroupName, String serverName, String databaseName) {
        return (DatabaseAutomaticTuningInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAutomaticTuningInner> getAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<DatabaseAutomaticTuningInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<DatabaseAutomaticTuningInner> getAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<DatabaseAutomaticTuningInner>, DatabaseAutomaticTuningInner>(){

            public DatabaseAutomaticTuningInner call(ServiceResponse<DatabaseAutomaticTuningInner> response) {
                return (DatabaseAutomaticTuningInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAutomaticTuningInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.get(resourceGroupName, serverName, databaseName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAutomaticTuningInner>>>(){

            public Observable<ServiceResponse<DatabaseAutomaticTuningInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAutomaticTuningsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAutomaticTuningInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAutomaticTuningInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAutomaticTuningInner update(String resourceGroupName, String serverName, String databaseName, DatabaseAutomaticTuningInner parameters) {
        return (DatabaseAutomaticTuningInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAutomaticTuningInner> updateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseAutomaticTuningInner parameters, ServiceCallback<DatabaseAutomaticTuningInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters), serviceCallback);
    }

    public Observable<DatabaseAutomaticTuningInner> updateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseAutomaticTuningInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<DatabaseAutomaticTuningInner>, DatabaseAutomaticTuningInner>(){

            public DatabaseAutomaticTuningInner call(ServiceResponse<DatabaseAutomaticTuningInner> response) {
                return (DatabaseAutomaticTuningInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAutomaticTuningInner>> updateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, DatabaseAutomaticTuningInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2015-05-01-preview";
        return this.service.update(resourceGroupName, serverName, databaseName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAutomaticTuningInner>>>(){

            public Observable<ServiceResponse<DatabaseAutomaticTuningInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAutomaticTuningsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAutomaticTuningInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAutomaticTuningInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DatabaseAutomaticTuningsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseAutomaticTunings get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/automaticTuning/current")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseAutomaticTunings update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/automaticTuning/current")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Body DatabaseAutomaticTuningInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

