/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * A stored credential that can be used by a job to connect to target
 * databases.
 */
@JsonFlatten
public class JobCredentialInner extends ProxyResource {
    /**
     * The credential user name.
     */
    @JsonProperty(value = "properties.username", required = true)
    private String username;

    /**
     * The credential password.
     */
    @JsonProperty(value = "properties.password", required = true)
    private String password;

    /**
     * Get the credential user name.
     *
     * @return the username value
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the credential user name.
     *
     * @param username the username value to set
     * @return the JobCredentialInner object itself.
     */
    public JobCredentialInner withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the credential password.
     *
     * @return the password value
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the credential password.
     *
     * @param password the password value to set
     * @return the JobCredentialInner object itself.
     */
    public JobCredentialInner withPassword(String password) {
        this.password = password;
        return this;
    }

}
