/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.AutomaticTuningMode;
import java.util.Map;
import com.microsoft.azure.management.sql.AutomaticTuningOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * Database-level Automatic Tuning.
 */
@JsonFlatten
public class DatabaseAutomaticTuningInner extends ProxyResource {
    /**
     * Automatic tuning desired state. Possible values include: 'Inherit',
     * 'Custom', 'Auto', 'Unspecified'.
     */
    @JsonProperty(value = "properties.desiredState")
    private AutomaticTuningMode desiredState;

    /**
     * Automatic tuning actual state. Possible values include: 'Inherit',
     * 'Custom', 'Auto', 'Unspecified'.
     */
    @JsonProperty(value = "properties.actualState", access = JsonProperty.Access.WRITE_ONLY)
    private AutomaticTuningMode actualState;

    /**
     * Automatic tuning options definition.
     */
    @JsonProperty(value = "properties.options")
    private Map<String, AutomaticTuningOptions> options;

    /**
     * Get automatic tuning desired state. Possible values include: 'Inherit', 'Custom', 'Auto', 'Unspecified'.
     *
     * @return the desiredState value
     */
    public AutomaticTuningMode desiredState() {
        return this.desiredState;
    }

    /**
     * Set automatic tuning desired state. Possible values include: 'Inherit', 'Custom', 'Auto', 'Unspecified'.
     *
     * @param desiredState the desiredState value to set
     * @return the DatabaseAutomaticTuningInner object itself.
     */
    public DatabaseAutomaticTuningInner withDesiredState(AutomaticTuningMode desiredState) {
        this.desiredState = desiredState;
        return this;
    }

    /**
     * Get automatic tuning actual state. Possible values include: 'Inherit', 'Custom', 'Auto', 'Unspecified'.
     *
     * @return the actualState value
     */
    public AutomaticTuningMode actualState() {
        return this.actualState;
    }

    /**
     * Get automatic tuning options definition.
     *
     * @return the options value
     */
    public Map<String, AutomaticTuningOptions> options() {
        return this.options;
    }

    /**
     * Set automatic tuning options definition.
     *
     * @param options the options value to set
     * @return the DatabaseAutomaticTuningInner object itself.
     */
    public DatabaseAutomaticTuningInner withOptions(Map<String, AutomaticTuningOptions> options) {
        this.options = options;
        return this;
    }

}
