/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for CreateMode.
 */
public final class CreateMode extends ExpandableStringEnum<CreateMode> {
    /** Static value Copy for CreateMode. */
    public static final CreateMode COPY = fromString("Copy");

    /** Static value Default for CreateMode. */
    public static final CreateMode DEFAULT = fromString("Default");

    /** Static value NonReadableSecondary for CreateMode. */
    public static final CreateMode NON_READABLE_SECONDARY = fromString("NonReadableSecondary");

    /** Static value OnlineSecondary for CreateMode. */
    public static final CreateMode ONLINE_SECONDARY = fromString("OnlineSecondary");

    /** Static value PointInTimeRestore for CreateMode. */
    public static final CreateMode POINT_IN_TIME_RESTORE = fromString("PointInTimeRestore");

    /** Static value Recovery for CreateMode. */
    public static final CreateMode RECOVERY = fromString("Recovery");

    /** Static value Restore for CreateMode. */
    public static final CreateMode RESTORE = fromString("Restore");

    /** Static value RestoreLongTermRetentionBackup for CreateMode. */
    public static final CreateMode RESTORE_LONG_TERM_RETENTION_BACKUP = fromString("RestoreLongTermRetentionBackup");

    /**
     * Creates or finds a CreateMode from its string representation.
     * @param name a name to look for
     * @return the corresponding CreateMode
     */
    @JsonCreator
    public static CreateMode fromString(String name) {
        return fromString(name, CreateMode.class);
    }

    /**
     * @return known CreateMode values
     */
    public static Collection<CreateMode> values() {
        return values(CreateMode.class);
    }
}
