/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SyncAgentInner;
import com.microsoft.azure.management.sql.implementation.SyncAgentKeyPropertiesInner;
import com.microsoft.azure.management.sql.implementation.SyncAgentLinkedDatabaseInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class SyncAgentsInner {
    private SyncAgentsService service;
    private SqlManagementClientImpl client;

    public SyncAgentsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (SyncAgentsService)retrofit.create(SyncAgentsService.class);
        this.client = client;
    }

    public SyncAgentInner get(String resourceGroupName, String serverName, String syncAgentName) {
        return (SyncAgentInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).toBlocking().single()).body());
    }

    public ServiceFuture<SyncAgentInner> getAsync(String resourceGroupName, String serverName, String syncAgentName, ServiceCallback<SyncAgentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName), serviceCallback);
    }

    public Observable<SyncAgentInner> getAsync(String resourceGroupName, String serverName, String syncAgentName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).map((Func1)new Func1<ServiceResponse<SyncAgentInner>, SyncAgentInner>(){

            public SyncAgentInner call(ServiceResponse<SyncAgentInner> response) {
                return (SyncAgentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SyncAgentInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String syncAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (syncAgentName == null) {
            throw new IllegalArgumentException("Parameter syncAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.get(resourceGroupName, serverName, syncAgentName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncAgentInner>>>(){

            public Observable<ServiceResponse<SyncAgentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncAgentsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SyncAgentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SyncAgentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SyncAgentInner createOrUpdate(String resourceGroupName, String serverName, String syncAgentName) {
        return (SyncAgentInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).toBlocking().last()).body());
    }

    public ServiceFuture<SyncAgentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName, ServiceCallback<SyncAgentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName), serviceCallback);
    }

    public Observable<SyncAgentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).map((Func1)new Func1<ServiceResponse<SyncAgentInner>, SyncAgentInner>(){

            public SyncAgentInner call(ServiceResponse<SyncAgentInner> response) {
                return (SyncAgentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SyncAgentInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String syncAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (syncAgentName == null) {
            throw new IllegalArgumentException("Parameter syncAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Object syncDatabaseId = null;
        SyncAgentInner parameters = new SyncAgentInner();
        parameters.withSyncDatabaseId(null);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, syncAgentName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SyncAgentInner>(){}.getType());
    }

    public SyncAgentInner createOrUpdate(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId) {
        return (SyncAgentInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId).toBlocking().last()).body());
    }

    public ServiceFuture<SyncAgentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId, ServiceCallback<SyncAgentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId), serviceCallback);
    }

    public Observable<SyncAgentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId).map((Func1)new Func1<ServiceResponse<SyncAgentInner>, SyncAgentInner>(){

            public SyncAgentInner call(ServiceResponse<SyncAgentInner> response) {
                return (SyncAgentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SyncAgentInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (syncAgentName == null) {
            throw new IllegalArgumentException("Parameter syncAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        SyncAgentInner parameters = new SyncAgentInner();
        parameters.withSyncDatabaseId(syncDatabaseId);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, syncAgentName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SyncAgentInner>(){}.getType());
    }

    public SyncAgentInner beginCreateOrUpdate(String resourceGroupName, String serverName, String syncAgentName) {
        return (SyncAgentInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).toBlocking().single()).body());
    }

    public ServiceFuture<SyncAgentInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName, ServiceCallback<SyncAgentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName), serviceCallback);
    }

    public Observable<SyncAgentInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).map((Func1)new Func1<ServiceResponse<SyncAgentInner>, SyncAgentInner>(){

            public SyncAgentInner call(ServiceResponse<SyncAgentInner> response) {
                return (SyncAgentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SyncAgentInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String syncAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (syncAgentName == null) {
            throw new IllegalArgumentException("Parameter syncAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Object syncDatabaseId = null;
        SyncAgentInner parameters = new SyncAgentInner();
        parameters.withSyncDatabaseId(null);
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, syncAgentName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncAgentInner>>>(){

            public Observable<ServiceResponse<SyncAgentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncAgentsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public SyncAgentInner beginCreateOrUpdate(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId) {
        return (SyncAgentInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId).toBlocking().single()).body());
    }

    public ServiceFuture<SyncAgentInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId, ServiceCallback<SyncAgentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId), serviceCallback);
    }

    public Observable<SyncAgentInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId).map((Func1)new Func1<ServiceResponse<SyncAgentInner>, SyncAgentInner>(){

            public SyncAgentInner call(ServiceResponse<SyncAgentInner> response) {
                return (SyncAgentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SyncAgentInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (syncAgentName == null) {
            throw new IllegalArgumentException("Parameter syncAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        SyncAgentInner parameters = new SyncAgentInner();
        parameters.withSyncDatabaseId(syncDatabaseId);
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, syncAgentName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncAgentInner>>>(){

            public Observable<ServiceResponse<SyncAgentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncAgentsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SyncAgentInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SyncAgentInner>(){}.getType()).register(201, new TypeToken<SyncAgentInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String syncAgentName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String syncAgentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String syncAgentName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String syncAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (syncAgentName == null) {
            throw new IllegalArgumentException("Parameter syncAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, serverName, syncAgentName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String serverName, String syncAgentName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serverName, String syncAgentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serverName, String syncAgentName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serverName, String syncAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (syncAgentName == null) {
            throw new IllegalArgumentException("Parameter syncAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.beginDelete(resourceGroupName, serverName, syncAgentName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncAgentsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncAgentInner> listByServer(String resourceGroupName, String serverName) {
        ServiceResponse response = (ServiceResponse)this.listByServerSinglePageAsync(resourceGroupName, serverName).toBlocking().single();
        return new PagedList<SyncAgentInner>((Page)response.body()){

            public Page<SyncAgentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncAgentsInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncAgentInner>> listByServerAsync(String resourceGroupName, String serverName, ListOperationCallback<SyncAgentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerSinglePageAsync(resourceGroupName, serverName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncAgentInner>>>>(){

            public Observable<ServiceResponse<Page<SyncAgentInner>>> call(String nextPageLink) {
                return SyncAgentsInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncAgentInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<Page<SyncAgentInner>>, Page<SyncAgentInner>>(){

            public Page<SyncAgentInner> call(ServiceResponse<Page<SyncAgentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncAgentInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        return this.listByServerSinglePageAsync(resourceGroupName, serverName).concatMap((Func1)new Func1<ServiceResponse<Page<SyncAgentInner>>, Observable<ServiceResponse<Page<SyncAgentInner>>>>(){

            public Observable<ServiceResponse<Page<SyncAgentInner>>> call(ServiceResponse<Page<SyncAgentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncAgentsInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncAgentInner>>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listByServer(resourceGroupName, serverName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncAgentInner>>>>(){

            public Observable<ServiceResponse<Page<SyncAgentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncAgentsInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncAgentInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncAgentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SyncAgentKeyPropertiesInner generateKey(String resourceGroupName, String serverName, String syncAgentName) {
        return (SyncAgentKeyPropertiesInner)((ServiceResponse)this.generateKeyWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).toBlocking().single()).body();
    }

    public ServiceFuture<SyncAgentKeyPropertiesInner> generateKeyAsync(String resourceGroupName, String serverName, String syncAgentName, ServiceCallback<SyncAgentKeyPropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.generateKeyWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName), serviceCallback);
    }

    public Observable<SyncAgentKeyPropertiesInner> generateKeyAsync(String resourceGroupName, String serverName, String syncAgentName) {
        return this.generateKeyWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).map((Func1)new Func1<ServiceResponse<SyncAgentKeyPropertiesInner>, SyncAgentKeyPropertiesInner>(){

            public SyncAgentKeyPropertiesInner call(ServiceResponse<SyncAgentKeyPropertiesInner> response) {
                return (SyncAgentKeyPropertiesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SyncAgentKeyPropertiesInner>> generateKeyWithServiceResponseAsync(String resourceGroupName, String serverName, String syncAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (syncAgentName == null) {
            throw new IllegalArgumentException("Parameter syncAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.generateKey(resourceGroupName, serverName, syncAgentName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncAgentKeyPropertiesInner>>>(){

            public Observable<ServiceResponse<SyncAgentKeyPropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncAgentsInner.this.generateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SyncAgentKeyPropertiesInner> generateKeyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SyncAgentKeyPropertiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncAgentLinkedDatabaseInner> listLinkedDatabases(String resourceGroupName, String serverName, String syncAgentName) {
        ServiceResponse response = (ServiceResponse)this.listLinkedDatabasesSinglePageAsync(resourceGroupName, serverName, syncAgentName).toBlocking().single();
        return new PagedList<SyncAgentLinkedDatabaseInner>((Page)response.body()){

            public Page<SyncAgentLinkedDatabaseInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncAgentsInner.this.listLinkedDatabasesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncAgentLinkedDatabaseInner>> listLinkedDatabasesAsync(String resourceGroupName, String serverName, String syncAgentName, ListOperationCallback<SyncAgentLinkedDatabaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listLinkedDatabasesSinglePageAsync(resourceGroupName, serverName, syncAgentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>> call(String nextPageLink) {
                return SyncAgentsInner.this.listLinkedDatabasesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncAgentLinkedDatabaseInner>> listLinkedDatabasesAsync(String resourceGroupName, String serverName, String syncAgentName) {
        return this.listLinkedDatabasesWithServiceResponseAsync(resourceGroupName, serverName, syncAgentName).map((Func1)new Func1<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>, Page<SyncAgentLinkedDatabaseInner>>(){

            public Page<SyncAgentLinkedDatabaseInner> call(ServiceResponse<Page<SyncAgentLinkedDatabaseInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>> listLinkedDatabasesWithServiceResponseAsync(String resourceGroupName, String serverName, String syncAgentName) {
        return this.listLinkedDatabasesSinglePageAsync(resourceGroupName, serverName, syncAgentName).concatMap((Func1)new Func1<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>, Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>> call(ServiceResponse<Page<SyncAgentLinkedDatabaseInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncAgentsInner.this.listLinkedDatabasesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>> listLinkedDatabasesSinglePageAsync(String resourceGroupName, String serverName, String syncAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (syncAgentName == null) {
            throw new IllegalArgumentException("Parameter syncAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listLinkedDatabases(resourceGroupName, serverName, syncAgentName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncAgentsInner.this.listLinkedDatabasesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncAgentLinkedDatabaseInner>> listLinkedDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncAgentLinkedDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncAgentInner> listByServerNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SyncAgentInner>((Page)response.body()){

            public Page<SyncAgentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncAgentsInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncAgentInner>> listByServerNextAsync(String nextPageLink, ServiceFuture<List<SyncAgentInner>> serviceFuture, ListOperationCallback<SyncAgentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncAgentInner>>>>(){

            public Observable<ServiceResponse<Page<SyncAgentInner>>> call(String nextPageLink) {
                return SyncAgentsInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncAgentInner>> listByServerNextAsync(String nextPageLink) {
        return this.listByServerNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SyncAgentInner>>, Page<SyncAgentInner>>(){

            public Page<SyncAgentInner> call(ServiceResponse<Page<SyncAgentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncAgentInner>>> listByServerNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByServerNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SyncAgentInner>>, Observable<ServiceResponse<Page<SyncAgentInner>>>>(){

            public Observable<ServiceResponse<Page<SyncAgentInner>>> call(ServiceResponse<Page<SyncAgentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncAgentsInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncAgentInner>>> listByServerNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByServerNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncAgentInner>>>>(){

            public Observable<ServiceResponse<Page<SyncAgentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncAgentsInner.this.listByServerNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncAgentInner>> listByServerNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncAgentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncAgentLinkedDatabaseInner> listLinkedDatabasesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listLinkedDatabasesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SyncAgentLinkedDatabaseInner>((Page)response.body()){

            public Page<SyncAgentLinkedDatabaseInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncAgentsInner.this.listLinkedDatabasesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncAgentLinkedDatabaseInner>> listLinkedDatabasesNextAsync(String nextPageLink, ServiceFuture<List<SyncAgentLinkedDatabaseInner>> serviceFuture, ListOperationCallback<SyncAgentLinkedDatabaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listLinkedDatabasesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>> call(String nextPageLink) {
                return SyncAgentsInner.this.listLinkedDatabasesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncAgentLinkedDatabaseInner>> listLinkedDatabasesNextAsync(String nextPageLink) {
        return this.listLinkedDatabasesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>, Page<SyncAgentLinkedDatabaseInner>>(){

            public Page<SyncAgentLinkedDatabaseInner> call(ServiceResponse<Page<SyncAgentLinkedDatabaseInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>> listLinkedDatabasesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listLinkedDatabasesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>, Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>> call(ServiceResponse<Page<SyncAgentLinkedDatabaseInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncAgentsInner.this.listLinkedDatabasesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>> listLinkedDatabasesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listLinkedDatabasesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<SyncAgentLinkedDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncAgentsInner.this.listLinkedDatabasesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncAgentLinkedDatabaseInner>> listLinkedDatabasesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncAgentLinkedDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface SyncAgentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncAgents get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="syncAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncAgents createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="syncAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body SyncAgentInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncAgents beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="syncAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body SyncAgentInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncAgents delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="syncAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncAgents beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="syncAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncAgents listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncAgents generateKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}/generateKey")
        public Observable<Response<ResponseBody>> generateKey(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="syncAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncAgents listLinkedDatabases"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}/linkedDatabases")
        public Observable<Response<ResponseBody>> listLinkedDatabases(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="syncAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncAgents listByServerNext"})
        @GET
        public Observable<Response<ResponseBody>> listByServerNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncAgents listLinkedDatabasesNext"})
        @GET
        public Observable<Response<ResponseBody>> listLinkedDatabasesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

