/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.RestorableDroppedManagedDatabaseInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RestorableDroppedManagedDatabasesInner {
    private RestorableDroppedManagedDatabasesService service;
    private SqlManagementClientImpl client;

    public RestorableDroppedManagedDatabasesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (RestorableDroppedManagedDatabasesService)retrofit.create(RestorableDroppedManagedDatabasesService.class);
        this.client = client;
    }

    public PagedList<RestorableDroppedManagedDatabaseInner> listByInstance(String resourceGroupName, String managedInstanceName) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).toBlocking().single();
        return new PagedList<RestorableDroppedManagedDatabaseInner>((Page)response.body()){

            public Page<RestorableDroppedManagedDatabaseInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RestorableDroppedManagedDatabasesInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RestorableDroppedManagedDatabaseInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName, ListOperationCallback<RestorableDroppedManagedDatabaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> call(String nextPageLink) {
                return RestorableDroppedManagedDatabasesInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RestorableDroppedManagedDatabaseInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>, Page<RestorableDroppedManagedDatabaseInner>>(){

            public Page<RestorableDroppedManagedDatabaseInner> call(ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> listByInstanceWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).concatMap((Func1)new Func1<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>, Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> call(ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RestorableDroppedManagedDatabasesInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RestorableDroppedManagedDatabasesInner.this.listByInstanceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<RestorableDroppedManagedDatabaseInner>> listByInstanceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<RestorableDroppedManagedDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RestorableDroppedManagedDatabaseInner get(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return (RestorableDroppedManagedDatabaseInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).toBlocking().single()).body());
    }

    public ServiceFuture<RestorableDroppedManagedDatabaseInner> getAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ServiceCallback<RestorableDroppedManagedDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId), serviceCallback);
    }

    public Observable<RestorableDroppedManagedDatabaseInner> getAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).map((Func1)new Func1<ServiceResponse<RestorableDroppedManagedDatabaseInner>, RestorableDroppedManagedDatabaseInner>(){

            public RestorableDroppedManagedDatabaseInner call(ServiceResponse<RestorableDroppedManagedDatabaseInner> response) {
                return (RestorableDroppedManagedDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RestorableDroppedManagedDatabaseInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (restorableDroppedDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RestorableDroppedManagedDatabaseInner>>>(){

            public Observable<ServiceResponse<RestorableDroppedManagedDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RestorableDroppedManagedDatabasesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RestorableDroppedManagedDatabaseInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RestorableDroppedManagedDatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RestorableDroppedManagedDatabaseInner> listByInstanceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RestorableDroppedManagedDatabaseInner>((Page)response.body()){

            public Page<RestorableDroppedManagedDatabaseInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RestorableDroppedManagedDatabasesInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RestorableDroppedManagedDatabaseInner>> listByInstanceNextAsync(String nextPageLink, ServiceFuture<List<RestorableDroppedManagedDatabaseInner>> serviceFuture, ListOperationCallback<RestorableDroppedManagedDatabaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> call(String nextPageLink) {
                return RestorableDroppedManagedDatabasesInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RestorableDroppedManagedDatabaseInner>> listByInstanceNextAsync(String nextPageLink) {
        return this.listByInstanceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>, Page<RestorableDroppedManagedDatabaseInner>>(){

            public Page<RestorableDroppedManagedDatabaseInner> call(ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> listByInstanceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByInstanceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>, Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> call(ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RestorableDroppedManagedDatabasesInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> listByInstanceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByInstanceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RestorableDroppedManagedDatabasesInner.this.listByInstanceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<RestorableDroppedManagedDatabaseInner>> listByInstanceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<RestorableDroppedManagedDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RestorableDroppedManagedDatabasesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorableDroppedManagedDatabases listByInstance"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases")
        public Observable<Response<ResponseBody>> listByInstance(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorableDroppedManagedDatabases get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases/{restorableDroppedDatabaseId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="restorableDroppedDatabaseId") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorableDroppedManagedDatabases listByInstanceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByInstanceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

