/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.EncryptionProtectorInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class EncryptionProtectorsInner {
    private EncryptionProtectorsService service;
    private SqlManagementClientImpl client;

    public EncryptionProtectorsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (EncryptionProtectorsService)retrofit.create(EncryptionProtectorsService.class);
        this.client = client;
    }

    public PagedList<EncryptionProtectorInner> listByServer(String resourceGroupName, String serverName) {
        ServiceResponse response = (ServiceResponse)this.listByServerSinglePageAsync(resourceGroupName, serverName).toBlocking().single();
        return new PagedList<EncryptionProtectorInner>((Page)response.body()){

            public Page<EncryptionProtectorInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EncryptionProtectorsInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EncryptionProtectorInner>> listByServerAsync(String resourceGroupName, String serverName, ListOperationCallback<EncryptionProtectorInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerSinglePageAsync(resourceGroupName, serverName), (Func1)new Func1<String, Observable<ServiceResponse<Page<EncryptionProtectorInner>>>>(){

            public Observable<ServiceResponse<Page<EncryptionProtectorInner>>> call(String nextPageLink) {
                return EncryptionProtectorsInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EncryptionProtectorInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<Page<EncryptionProtectorInner>>, Page<EncryptionProtectorInner>>(){

            public Page<EncryptionProtectorInner> call(ServiceResponse<Page<EncryptionProtectorInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EncryptionProtectorInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        return this.listByServerSinglePageAsync(resourceGroupName, serverName).concatMap((Func1)new Func1<ServiceResponse<Page<EncryptionProtectorInner>>, Observable<ServiceResponse<Page<EncryptionProtectorInner>>>>(){

            public Observable<ServiceResponse<Page<EncryptionProtectorInner>>> call(ServiceResponse<Page<EncryptionProtectorInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EncryptionProtectorsInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EncryptionProtectorInner>>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listByServer(resourceGroupName, serverName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EncryptionProtectorInner>>>>(){

            public Observable<ServiceResponse<Page<EncryptionProtectorInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EncryptionProtectorsInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<EncryptionProtectorInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<EncryptionProtectorInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public EncryptionProtectorInner get(String resourceGroupName, String serverName) {
        return (EncryptionProtectorInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body());
    }

    public ServiceFuture<EncryptionProtectorInner> getAsync(String resourceGroupName, String serverName, ServiceCallback<EncryptionProtectorInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<EncryptionProtectorInner> getAsync(String resourceGroupName, String serverName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<EncryptionProtectorInner>, EncryptionProtectorInner>(){

            public EncryptionProtectorInner call(ServiceResponse<EncryptionProtectorInner> response) {
                return (EncryptionProtectorInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EncryptionProtectorInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String encryptionProtectorName = "current";
        String apiVersion = "2015-05-01-preview";
        return this.service.get(resourceGroupName, serverName, "current", this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EncryptionProtectorInner>>>(){

            public Observable<ServiceResponse<EncryptionProtectorInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EncryptionProtectorsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EncryptionProtectorInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EncryptionProtectorInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public EncryptionProtectorInner createOrUpdate(String resourceGroupName, String serverName, EncryptionProtectorInner parameters) {
        return (EncryptionProtectorInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<EncryptionProtectorInner> createOrUpdateAsync(String resourceGroupName, String serverName, EncryptionProtectorInner parameters, ServiceCallback<EncryptionProtectorInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    public Observable<EncryptionProtectorInner> createOrUpdateAsync(String resourceGroupName, String serverName, EncryptionProtectorInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).map((Func1)new Func1<ServiceResponse<EncryptionProtectorInner>, EncryptionProtectorInner>(){

            public EncryptionProtectorInner call(ServiceResponse<EncryptionProtectorInner> response) {
                return (EncryptionProtectorInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EncryptionProtectorInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, EncryptionProtectorInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String encryptionProtectorName = "current";
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, "current", this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<EncryptionProtectorInner>(){}.getType());
    }

    public EncryptionProtectorInner beginCreateOrUpdate(String resourceGroupName, String serverName, EncryptionProtectorInner parameters) {
        return (EncryptionProtectorInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<EncryptionProtectorInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, EncryptionProtectorInner parameters, ServiceCallback<EncryptionProtectorInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    public Observable<EncryptionProtectorInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, EncryptionProtectorInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).map((Func1)new Func1<ServiceResponse<EncryptionProtectorInner>, EncryptionProtectorInner>(){

            public EncryptionProtectorInner call(ServiceResponse<EncryptionProtectorInner> response) {
                return (EncryptionProtectorInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EncryptionProtectorInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, EncryptionProtectorInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String encryptionProtectorName = "current";
        String apiVersion = "2015-05-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, "current", this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EncryptionProtectorInner>>>(){

            public Observable<ServiceResponse<EncryptionProtectorInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EncryptionProtectorsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EncryptionProtectorInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EncryptionProtectorInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<EncryptionProtectorInner> listByServerNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<EncryptionProtectorInner>((Page)response.body()){

            public Page<EncryptionProtectorInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EncryptionProtectorsInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EncryptionProtectorInner>> listByServerNextAsync(String nextPageLink, ServiceFuture<List<EncryptionProtectorInner>> serviceFuture, ListOperationCallback<EncryptionProtectorInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<EncryptionProtectorInner>>>>(){

            public Observable<ServiceResponse<Page<EncryptionProtectorInner>>> call(String nextPageLink) {
                return EncryptionProtectorsInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EncryptionProtectorInner>> listByServerNextAsync(String nextPageLink) {
        return this.listByServerNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<EncryptionProtectorInner>>, Page<EncryptionProtectorInner>>(){

            public Page<EncryptionProtectorInner> call(ServiceResponse<Page<EncryptionProtectorInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EncryptionProtectorInner>>> listByServerNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByServerNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<EncryptionProtectorInner>>, Observable<ServiceResponse<Page<EncryptionProtectorInner>>>>(){

            public Observable<ServiceResponse<Page<EncryptionProtectorInner>>> call(ServiceResponse<Page<EncryptionProtectorInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EncryptionProtectorsInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EncryptionProtectorInner>>> listByServerNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByServerNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EncryptionProtectorInner>>>>(){

            public Observable<ServiceResponse<Page<EncryptionProtectorInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EncryptionProtectorsInner.this.listByServerNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<EncryptionProtectorInner>> listByServerNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<EncryptionProtectorInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface EncryptionProtectorsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.EncryptionProtectors listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/encryptionProtector")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.EncryptionProtectors get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/encryptionProtector/{encryptionProtectorName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="encryptionProtectorName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.EncryptionProtectors createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/encryptionProtector/{encryptionProtectorName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="encryptionProtectorName") String var3, @Path(value="subscriptionId") String var4, @Body EncryptionProtectorInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.EncryptionProtectors beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/encryptionProtector/{encryptionProtectorName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="encryptionProtectorName") String var3, @Path(value="subscriptionId") String var4, @Body EncryptionProtectorInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.EncryptionProtectors listByServerNext"})
        @GET
        public Observable<Response<ResponseBody>> listByServerNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

