/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.DatabaseVulnerabilityAssessmentInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DatabaseVulnerabilityAssessmentsInner {
    private DatabaseVulnerabilityAssessmentsService service;
    private SqlManagementClientImpl client;

    public DatabaseVulnerabilityAssessmentsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (DatabaseVulnerabilityAssessmentsService)retrofit.create(DatabaseVulnerabilityAssessmentsService.class);
        this.client = client;
    }

    public DatabaseVulnerabilityAssessmentInner get(String resourceGroupName, String serverName, String databaseName) {
        return (DatabaseVulnerabilityAssessmentInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<DatabaseVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentInner>, DatabaseVulnerabilityAssessmentInner>(){

            public DatabaseVulnerabilityAssessmentInner call(ServiceResponse<DatabaseVulnerabilityAssessmentInner> response) {
                return (DatabaseVulnerabilityAssessmentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>>>(){

            public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseVulnerabilityAssessmentsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseVulnerabilityAssessmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseVulnerabilityAssessmentInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters) {
        return (DatabaseVulnerabilityAssessmentInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters, ServiceCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters), serviceCallback);
    }

    public Observable<DatabaseVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentInner>, DatabaseVulnerabilityAssessmentInner>(){

            public DatabaseVulnerabilityAssessmentInner call(ServiceResponse<DatabaseVulnerabilityAssessmentInner> response) {
                return (DatabaseVulnerabilityAssessmentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-03-01-preview";
        return this.service.createOrUpdate(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>>>(){

            public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseVulnerabilityAssessmentsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseVulnerabilityAssessmentInner>(){}.getType()).register(201, new TypeToken<DatabaseVulnerabilityAssessmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String databaseName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-03-01-preview";
        return this.service.delete(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseVulnerabilityAssessmentsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DatabaseVulnerabilityAssessmentInner> listByDatabase(String resourceGroupName, String serverName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName).toBlocking().single();
        return new PagedList<DatabaseVulnerabilityAssessmentInner>((Page)response.body()){

            public Page<DatabaseVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DatabaseVulnerabilityAssessmentInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, ListOperationCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                return DatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DatabaseVulnerabilityAssessmentInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>, Page<DatabaseVulnerabilityAssessmentInner>>(){

            public Page<DatabaseVulnerabilityAssessmentInner> call(ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByDatabase(resourceGroupName, serverName, databaseName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseVulnerabilityAssessmentsInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DatabaseVulnerabilityAssessmentInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DatabaseVulnerabilityAssessmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DatabaseVulnerabilityAssessmentInner> listByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DatabaseVulnerabilityAssessmentInner>((Page)response.body()){

            public Page<DatabaseVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DatabaseVulnerabilityAssessmentInner>> listByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<DatabaseVulnerabilityAssessmentInner>> serviceFuture, ListOperationCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                return DatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DatabaseVulnerabilityAssessmentInner>> listByDatabaseNextAsync(String nextPageLink) {
        return this.listByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>, Page<DatabaseVulnerabilityAssessmentInner>>(){

            public Page<DatabaseVulnerabilityAssessmentInner> call(ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> listByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> listByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DatabaseVulnerabilityAssessmentInner>> listByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DatabaseVulnerabilityAssessmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DatabaseVulnerabilityAssessmentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessments get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessments createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="subscriptionId") String var5, @Body DatabaseVulnerabilityAssessmentInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessments delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessments listByDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments")
        public Observable<Response<ResponseBody>> listByDatabase(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessments listByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

