/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.dag.FunctionalTaskItem;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.ExecutableImpl;
import com.microsoft.azure.management.sql.AuthenticationType;
import com.microsoft.azure.management.sql.ImportExtensionRequest;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlDatabaseImportExportResponse;
import com.microsoft.azure.management.sql.SqlDatabaseImportRequest;
import com.microsoft.azure.management.sql.StorageKeyType;
import com.microsoft.azure.management.sql.implementation.ImportExportResponseInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImportExportResponseImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountKey;
import java.util.List;
import java.util.Objects;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlDatabaseImportRequestImpl
extends ExecutableImpl<SqlDatabaseImportExportResponse>
implements SqlDatabaseImportRequest,
SqlDatabaseImportRequest.SqlDatabaseImportRequestDefinition {
    private final SqlDatabaseImpl sqlDatabase;
    private final SqlServerManager sqlServerManager;
    private ImportExtensionRequest inner;

    SqlDatabaseImportRequestImpl(SqlDatabaseImpl sqlDatabase, SqlServerManager sqlServerManager) {
        this.sqlDatabase = sqlDatabase;
        this.sqlServerManager = sqlServerManager;
        this.inner = new ImportExtensionRequest();
    }

    public SqlDatabase parent() {
        return null;
    }

    public ImportExtensionRequest inner() {
        return this.inner;
    }

    public Observable<SqlDatabaseImportExportResponse> executeWorkAsync() {
        final SqlDatabaseImportRequestImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().createImportOperationAsync(this.sqlDatabase.resourceGroupName, this.sqlDatabase.sqlServerName, this.sqlDatabase.name(), this.inner()).flatMap((Func1)new Func1<ImportExportResponseInner, Observable<SqlDatabaseImportExportResponse>>(){

            public Observable<SqlDatabaseImportExportResponse> call(final ImportExportResponseInner importExportResponseInner) {
                return self.sqlDatabase.refreshAsync().map((Func1)new Func1<SqlDatabase, SqlDatabaseImportExportResponse>(){

                    public SqlDatabaseImportExportResponse call(SqlDatabase sqlDatabase) {
                        return new SqlDatabaseImportExportResponseImpl(importExportResponseInner);
                    }
                });
            }
        });
    }

    private Observable<Indexable> getOrCreateStorageAccountContainer(final StorageAccount storageAccount, final String containerName, final String fileName, final FunctionalTaskItem.Context context) {
        final SqlDatabaseImportRequestImpl self = this;
        return storageAccount.getKeysAsync().flatMap((Func1)new Func1<List<StorageAccountKey>, Observable<StorageAccountKey>>(){

            public Observable<StorageAccountKey> call(List<StorageAccountKey> storageAccountKeys) {
                return Observable.from(storageAccountKeys).first();
            }
        }).flatMap((Func1)new Func1<StorageAccountKey, Observable<Indexable>>(){

            public Observable<Indexable> call(StorageAccountKey storageAccountKey) {
                self.inner.withStorageUri(String.format("%s%s/%s", storageAccount.endPoints().primary().blob(), containerName, fileName));
                self.inner.withStorageKeyType(StorageKeyType.STORAGE_ACCESS_KEY);
                self.inner.withStorageKey(storageAccountKey.value());
                return context.voidObservable();
            }
        });
    }

    @Override
    public SqlDatabaseImportRequestImpl importFrom(String storageUri) {
        if (this.inner == null) {
            this.inner = new ImportExtensionRequest();
        }
        this.inner.withStorageUri(storageUri);
        return this;
    }

    @Override
    public SqlDatabaseImportRequestImpl importFrom(final StorageAccount storageAccount, final String containerName, final String fileName) {
        Objects.requireNonNull(storageAccount);
        Objects.requireNonNull(containerName);
        Objects.requireNonNull(fileName);
        if (this.inner == null) {
            this.inner = new ImportExtensionRequest();
        }
        SqlDatabaseImportRequestImpl self = this;
        this.addDependency(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return SqlDatabaseImportRequestImpl.this.getOrCreateStorageAccountContainer(storageAccount, containerName, fileName, context);
            }
        });
        return this;
    }

    @Override
    public SqlDatabaseImportRequestImpl withStorageAccessKey(String storageAccessKey) {
        this.inner.withStorageKeyType(StorageKeyType.STORAGE_ACCESS_KEY);
        this.inner.withStorageKey(storageAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseImportRequestImpl withSharedAccessKey(String sharedAccessKey) {
        this.inner.withStorageKeyType(StorageKeyType.SHARED_ACCESS_KEY);
        this.inner.withStorageKey(sharedAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseImportRequestImpl withSqlAdministratorLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.inner.withAuthenticationType(AuthenticationType.SQL);
        return this.withLoginAndPassword(administratorLogin, administratorPassword);
    }

    @Override
    public SqlDatabaseImportRequestImpl withActiveDirectoryLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.inner.withAuthenticationType(AuthenticationType.ADPASSWORD);
        return this.withLoginAndPassword(administratorLogin, administratorPassword);
    }

    SqlDatabaseImportRequestImpl withLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.inner.withAdministratorLogin(administratorLogin);
        this.inner.withAdministratorLoginPassword(administratorPassword);
        return this;
    }
}

