/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.dag.FunctionalTaskItem;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.sql.ElasticPoolEditions;
import com.microsoft.azure.management.sql.IdentityType;
import com.microsoft.azure.management.sql.RecommendedElasticPool;
import com.microsoft.azure.management.sql.ResourceIdentity;
import com.microsoft.azure.management.sql.ServerMetric;
import com.microsoft.azure.management.sql.ServiceObjective;
import com.microsoft.azure.management.sql.SqlDatabaseOperations;
import com.microsoft.azure.management.sql.SqlElasticPoolOperations;
import com.microsoft.azure.management.sql.SqlEncryptionProtectorOperations;
import com.microsoft.azure.management.sql.SqlFailoverGroupOperations;
import com.microsoft.azure.management.sql.SqlFirewallRule;
import com.microsoft.azure.management.sql.SqlFirewallRuleOperations;
import com.microsoft.azure.management.sql.SqlRestorableDroppedDatabase;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.SqlServerAutomaticTuning;
import com.microsoft.azure.management.sql.SqlServerDnsAliasOperations;
import com.microsoft.azure.management.sql.SqlServerKeyOperations;
import com.microsoft.azure.management.sql.SqlServerSecurityAlertPolicyOperations;
import com.microsoft.azure.management.sql.SqlVirtualNetworkRule;
import com.microsoft.azure.management.sql.SqlVirtualNetworkRuleOperations;
import com.microsoft.azure.management.sql.implementation.RecommendedElasticPoolImpl;
import com.microsoft.azure.management.sql.implementation.RecommendedElasticPoolInner;
import com.microsoft.azure.management.sql.implementation.RestorableDroppedDatabaseInner;
import com.microsoft.azure.management.sql.implementation.ServerAutomaticTuningInner;
import com.microsoft.azure.management.sql.implementation.ServerAzureADAdministratorInner;
import com.microsoft.azure.management.sql.implementation.ServerInner;
import com.microsoft.azure.management.sql.implementation.ServerMetricImpl;
import com.microsoft.azure.management.sql.implementation.ServerUsageInner;
import com.microsoft.azure.management.sql.implementation.ServiceObjectiveImpl;
import com.microsoft.azure.management.sql.implementation.ServiceObjectiveInner;
import com.microsoft.azure.management.sql.implementation.SqlActiveDirectoryAdministratorImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabasesAsExternalChildResourcesImpl;
import com.microsoft.azure.management.sql.implementation.SqlElasticPoolImpl;
import com.microsoft.azure.management.sql.implementation.SqlElasticPoolOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlElasticPoolsAsExternalChildResourcesImpl;
import com.microsoft.azure.management.sql.implementation.SqlEncryptionProtectorOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlFailoverGroupOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlFirewallRuleImpl;
import com.microsoft.azure.management.sql.implementation.SqlFirewallRuleOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlFirewallRulesAsExternalChildResourcesImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlRestorableDroppedDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerAutomaticTuningImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerDnsAliasOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerKeyOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.SqlServerSecurityAlertPolicyOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlVirtualNetworkRuleOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlVirtualNetworkRulesAsExternalChildResourcesImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlServerImpl
extends GroupableResourceImpl<SqlServer, ServerInner, SqlServerImpl, SqlServerManager>
implements SqlServer,
SqlServer.Definition,
SqlServer.Update {
    private FunctionalTaskItem sqlADAdminCreator = null;
    private boolean allowAzureServicesAccess = true;
    private SqlFirewallRulesAsExternalChildResourcesImpl sqlFirewallRules = new SqlFirewallRulesAsExternalChildResourcesImpl(this, "SqlFirewallRule");
    private SqlFirewallRuleOperations.SqlFirewallRuleActionsDefinition sqlFirewallRuleOperations;
    private SqlVirtualNetworkRulesAsExternalChildResourcesImpl sqlVirtualNetworkRules = new SqlVirtualNetworkRulesAsExternalChildResourcesImpl(this, "SqlVirtualNetworkRule");
    private SqlVirtualNetworkRuleOperations.SqlVirtualNetworkRuleActionsDefinition sqlVirtualNetworkRuleOperations;
    private SqlElasticPoolsAsExternalChildResourcesImpl sqlElasticPools = new SqlElasticPoolsAsExternalChildResourcesImpl(this, "SqlElasticPool");
    private SqlElasticPoolOperations.SqlElasticPoolActionsDefinition sqlElasticPoolOperations;
    private SqlDatabasesAsExternalChildResourcesImpl sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this, "SqlDatabase");
    private SqlDatabaseOperations.SqlDatabaseActionsDefinition sqlDatabaseOperations;
    private SqlServerDnsAliasOperations.SqlServerDnsAliasActionsDefinition sqlServerDnsAliasOperations;
    private SqlFailoverGroupOperations.SqlFailoverGroupActionsDefinition sqlFailoverGroupOperations;
    private SqlServerKeyOperations.SqlServerKeyActionsDefinition sqlServerKeyOperations;
    private SqlServerSecurityAlertPolicyOperationsImpl sqlServerSecurityAlertPolicyOperations;
    private SqlEncryptionProtectorOperations.SqlEncryptionProtectorActionsDefinition sqlEncryptionProtectorsOperations;

    protected SqlServerImpl(String name, ServerInner innerObject, SqlServerManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
    }

    protected Observable<ServerInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).servers().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<SqlServer> createResourceAsync() {
        final SqlServerImpl self = this;
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).servers().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ServerInner)((Object)this.inner())).map((Func1)new Func1<ServerInner, SqlServer>(){

            public SqlServer call(ServerInner serverInner) {
                SqlServerImpl.this.setInner((Object)serverInner);
                return self;
            }
        });
    }

    public void beforeGroupCreateOrUpdate() {
        if (this.isInCreateMode()) {
            if (this.allowAzureServicesAccess) {
                this.sqlFirewallRules.defineInlineFirewallRule("AllowAllWindowsAzureIps").withStartIPAddress("0.0.0.0").withEndIPAddress("0.0.0.0");
            }
            if (this.sqlADAdminCreator != null) {
                this.addPostRunDependent(this.sqlADAdminCreator);
            }
        }
        if (this.sqlElasticPools != null && this.sqlDatabases != null) {
            List<SqlDatabaseImpl> dbToBeRemoved = this.sqlDatabases.getChildren(ExternalChildResourceImpl.PendingOperation.ToBeRemoved);
            List<SqlElasticPoolImpl> epToBeRemoved = this.sqlElasticPools.getChildren(ExternalChildResourceImpl.PendingOperation.ToBeRemoved);
            for (SqlElasticPoolImpl epItem : epToBeRemoved) {
                for (SqlDatabaseImpl dbItem : dbToBeRemoved) {
                    epItem.addParentDependency((TaskGroup.HasTaskGroup)dbItem);
                }
            }
            List<SqlDatabaseImpl> dbToBeCreated = this.sqlDatabases.getChildren(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
            List<SqlElasticPoolImpl> epToBeCreated = this.sqlElasticPools.getChildren(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
            for (SqlElasticPoolImpl epItem : epToBeCreated) {
                for (SqlDatabaseImpl dbItem : dbToBeCreated) {
                    if (dbItem.elasticPoolName() == null || !dbItem.elasticPoolName().equals(epItem.name())) continue;
                    dbItem.addParentDependency((TaskGroup.HasTaskGroup)epItem);
                }
            }
        }
    }

    public Completable afterPostRunAsync(boolean isGroupFaulted) {
        this.sqlADAdminCreator = null;
        this.sqlFirewallRules.clear();
        this.sqlElasticPools.clear();
        this.sqlDatabases.clear();
        return Completable.complete();
    }

    @Override
    public String fullyQualifiedDomainName() {
        return ((ServerInner)((Object)this.inner())).fullyQualifiedDomainName();
    }

    @Override
    public String administratorLogin() {
        return ((ServerInner)((Object)this.inner())).administratorLogin();
    }

    @Override
    public String kind() {
        return ((ServerInner)((Object)this.inner())).kind();
    }

    @Override
    public String state() {
        return ((ServerInner)((Object)this.inner())).state();
    }

    @Override
    public boolean isManagedServiceIdentityEnabled() {
        return ((ServerInner)((Object)this.inner())).identity() != null && ((ServerInner)((Object)this.inner())).identity().type().equals((Object)IdentityType.SYSTEM_ASSIGNED);
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        return ((ServerInner)((Object)this.inner())).identity() != null ? ((ServerInner)((Object)this.inner())).identity().tenantId().toString() : null;
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        return ((ServerInner)((Object)this.inner())).identity() != null ? ((ServerInner)((Object)this.inner())).identity().principalId().toString() : null;
    }

    @Override
    public IdentityType managedServiceIdentityType() {
        return ((ServerInner)((Object)this.inner())).identity() != null ? ((ServerInner)((Object)this.inner())).identity().type() : null;
    }

    @Override
    public List<ServerMetric> listUsages() {
        return this.listUsageMetrics();
    }

    @Override
    public List<ServerMetric> listUsageMetrics() {
        ArrayList<ServerMetricImpl> serverMetrics = new ArrayList<ServerMetricImpl>();
        List<ServerUsageInner> serverUsageInners = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).serverUsages().listByServer(this.resourceGroupName(), this.name());
        if (serverUsageInners != null) {
            for (ServerUsageInner serverUsageInner : serverUsageInners) {
                serverMetrics.add(new ServerMetricImpl(serverUsageInner));
            }
        }
        return Collections.unmodifiableList(serverMetrics);
    }

    @Override
    public List<ServiceObjective> listServiceObjectives() {
        ArrayList<ServiceObjectiveImpl> serviceObjectives = new ArrayList<ServiceObjectiveImpl>();
        List<ServiceObjectiveInner> serviceObjectiveInners = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).serviceObjectives().listByServer(this.resourceGroupName(), this.name());
        if (serviceObjectiveInners != null) {
            for (ServiceObjectiveInner inner : serviceObjectiveInners) {
                serviceObjectives.add(new ServiceObjectiveImpl(inner, this));
            }
        }
        return Collections.unmodifiableList(serviceObjectives);
    }

    @Override
    public ServiceObjective getServiceObjective(String serviceObjectiveName) {
        ServiceObjectiveInner inner = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).serviceObjectives().get(this.resourceGroupName(), this.name(), serviceObjectiveName);
        return inner != null ? new ServiceObjectiveImpl(inner, this) : null;
    }

    @Override
    public Map<String, RecommendedElasticPool> listRecommendedElasticPools() {
        HashMap<String, RecommendedElasticPoolImpl> recommendedElasticPoolMap = new HashMap<String, RecommendedElasticPoolImpl>();
        List<RecommendedElasticPoolInner> recommendedElasticPoolInners = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).recommendedElasticPools().listByServer(this.resourceGroupName(), this.name());
        if (recommendedElasticPoolInners != null) {
            for (RecommendedElasticPoolInner inner : recommendedElasticPoolInners) {
                recommendedElasticPoolMap.put(inner.name(), new RecommendedElasticPoolImpl(inner, this));
            }
        }
        return Collections.unmodifiableMap(recommendedElasticPoolMap);
    }

    @Override
    public List<SqlRestorableDroppedDatabase> listRestorableDroppedDatabases() {
        ArrayList<SqlRestorableDroppedDatabaseImpl> sqlRestorableDroppedDatabases = new ArrayList<SqlRestorableDroppedDatabaseImpl>();
        List<RestorableDroppedDatabaseInner> restorableDroppedDatabasesInners = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).restorableDroppedDatabases().listByServer(this.resourceGroupName(), this.name());
        if (restorableDroppedDatabasesInners != null) {
            for (RestorableDroppedDatabaseInner restorableDroppedDatabaseInner : restorableDroppedDatabasesInners) {
                sqlRestorableDroppedDatabases.add(new SqlRestorableDroppedDatabaseImpl(this.resourceGroupName(), this.name(), restorableDroppedDatabaseInner, (SqlServerManager)this.manager()));
            }
        }
        return Collections.unmodifiableList(sqlRestorableDroppedDatabases);
    }

    @Override
    public Observable<SqlRestorableDroppedDatabase> listRestorableDroppedDatabasesAsync() {
        final SqlServerImpl self = this;
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).restorableDroppedDatabases().listByServerAsync(this.resourceGroupName(), this.name()).flatMap((Func1)new Func1<List<RestorableDroppedDatabaseInner>, Observable<RestorableDroppedDatabaseInner>>(){

            public Observable<RestorableDroppedDatabaseInner> call(List<RestorableDroppedDatabaseInner> restorableDroppedDatabaseInners) {
                return Observable.from(restorableDroppedDatabaseInners);
            }
        }).map((Func1)new Func1<RestorableDroppedDatabaseInner, SqlRestorableDroppedDatabase>(){

            public SqlRestorableDroppedDatabase call(RestorableDroppedDatabaseInner restorableDroppedDatabaseInner) {
                return new SqlRestorableDroppedDatabaseImpl(self.resourceGroupName(), self.name(), restorableDroppedDatabaseInner, (SqlServerManager)self.manager());
            }
        });
    }

    @Override
    public String version() {
        return ((ServerInner)((Object)this.inner())).version();
    }

    @Override
    public SqlFirewallRule enableAccessFromAzureServices() {
        SqlFirewallRule firewallRule = (SqlFirewallRule)((SqlServerManager)this.manager()).sqlServers().firewallRules().getBySqlServer(this.resourceGroupName(), this.name(), "AllowAllWindowsAzureIps");
        if (firewallRule == null) {
            firewallRule = (SqlFirewallRule)((SqlFirewallRuleOperations.DefinitionStages.WithSqlServer)((SqlServerManager)this.manager()).sqlServers().firewallRules().define("AllowAllWindowsAzureIps")).withExistingSqlServer(this.resourceGroupName(), this.name()).withIPAddress("0.0.0.0").create();
        }
        return firewallRule;
    }

    @Override
    public void removeAccessFromAzureServices() {
        SqlFirewallRule firewallRule = (SqlFirewallRule)((SqlServerManager)this.manager()).sqlServers().firewallRules().getBySqlServer(this.resourceGroupName(), this.name(), "AllowAllWindowsAzureIps");
        if (firewallRule != null) {
            ((SqlServerManager)this.manager()).sqlServers().firewallRules().deleteBySqlServer(this.resourceGroupName(), this.name(), "AllowAllWindowsAzureIps");
        }
    }

    @Override
    public SqlActiveDirectoryAdministratorImpl setActiveDirectoryAdministrator(String userLogin, String objectId) {
        ServerAzureADAdministratorInner serverAzureADAdministratorInner = new ServerAzureADAdministratorInner().withLogin(userLogin).withSid(UUID.fromString(objectId)).withTenantId(UUID.fromString(((SqlServerManager)this.manager()).tenantId()));
        return new SqlActiveDirectoryAdministratorImpl(((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).serverAzureADAdministrators().createOrUpdate(this.resourceGroupName(), this.name(), serverAzureADAdministratorInner));
    }

    @Override
    public SqlActiveDirectoryAdministratorImpl getActiveDirectoryAdministrator() {
        ServerAzureADAdministratorInner serverAzureADAdministratorInner = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).serverAzureADAdministrators().get(this.resourceGroupName(), this.name());
        return serverAzureADAdministratorInner != null ? new SqlActiveDirectoryAdministratorImpl(serverAzureADAdministratorInner) : null;
    }

    @Override
    public void removeActiveDirectoryAdministrator() {
        ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).serverAzureADAdministrators().delete(this.resourceGroupName(), this.name());
    }

    @Override
    public SqlServerAutomaticTuning getServerAutomaticTuning() {
        ServerAutomaticTuningInner serverAutomaticTuningInner = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).serverAutomaticTunings().get(this.resourceGroupName(), this.name());
        return serverAutomaticTuningInner != null ? new SqlServerAutomaticTuningImpl(this, serverAutomaticTuningInner) : null;
    }

    @Override
    public SqlFirewallRuleOperations.SqlFirewallRuleActionsDefinition firewallRules() {
        if (this.sqlFirewallRuleOperations == null) {
            this.sqlFirewallRuleOperations = new SqlFirewallRuleOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlFirewallRuleOperations;
    }

    @Override
    public SqlVirtualNetworkRuleOperations.SqlVirtualNetworkRuleActionsDefinition virtualNetworkRules() {
        if (this.sqlVirtualNetworkRuleOperations == null) {
            this.sqlVirtualNetworkRuleOperations = new SqlVirtualNetworkRuleOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlVirtualNetworkRuleOperations;
    }

    @Override
    public SqlServerImpl withAdministratorLogin(String administratorLogin) {
        ((ServerInner)((Object)this.inner())).withAdministratorLogin(administratorLogin);
        return this;
    }

    @Override
    public SqlServerImpl withAdministratorPassword(String administratorLoginPassword) {
        ((ServerInner)((Object)this.inner())).withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    @Override
    public SqlServerImpl withoutAccessFromAzureServices() {
        this.allowAzureServicesAccess = false;
        return this;
    }

    @Override
    public SqlServer.DefinitionStages.WithCreate withActiveDirectoryAdministrator(final String userLogin, final String objectId) {
        final SqlServerImpl self = this;
        this.sqlADAdminCreator = new FunctionalTaskItem(){

            public Observable<Indexable> call(final FunctionalTaskItem.Context context) {
                ServerAzureADAdministratorInner serverAzureADAdministratorInner = new ServerAzureADAdministratorInner().withLogin(userLogin).withSid(UUID.fromString(objectId)).withTenantId(UUID.fromString(((SqlServerManager)self.manager()).tenantId()));
                return ((SqlManagementClientImpl)((Object)((SqlServerManager)self.manager()).inner())).serverAzureADAdministrators().createOrUpdateAsync(self.resourceGroupName(), self.name(), serverAzureADAdministratorInner).flatMap((Func1)new Func1<ServerAzureADAdministratorInner, Observable<Indexable>>(){

                    public Observable<Indexable> call(ServerAzureADAdministratorInner serverAzureADAdministratorInner) {
                        return context.voidObservable();
                    }
                });
            }
        };
        return this;
    }

    public SqlFirewallRuleImpl defineFirewallRule(String name) {
        return this.sqlFirewallRules.defineInlineFirewallRule(name);
    }

    @Override
    public SqlServerImpl withNewFirewallRule(String ipAddress) {
        return this.withNewFirewallRule(ipAddress, ipAddress);
    }

    @Override
    public SqlServerImpl withNewFirewallRule(String startIPAddress, String endIPAddress) {
        return this.withNewFirewallRule(startIPAddress, endIPAddress, SdkContext.randomResourceName((String)"firewall_", (int)15));
    }

    @Override
    public SqlServerImpl withNewFirewallRule(String startIPAddress, String endIPAddress, String firewallRuleName) {
        return this.sqlFirewallRules.defineInlineFirewallRule(firewallRuleName).withStartIPAddress(startIPAddress).withEndIPAddress(endIPAddress).attach();
    }

    @Override
    public SqlServerImpl withoutFirewallRule(String firewallRuleName) {
        this.sqlFirewallRules.removeInlineFirewallRule(firewallRuleName);
        return this;
    }

    @Override
    public SqlVirtualNetworkRule.DefinitionStages.Blank<SqlServer.DefinitionStages.WithCreate> defineVirtualNetworkRule(String virtualNetworkRuleName) {
        return this.sqlVirtualNetworkRules.defineInlineVirtualNetworkRule(virtualNetworkRuleName);
    }

    @Override
    public SqlElasticPoolOperations.SqlElasticPoolActionsDefinition elasticPools() {
        if (this.sqlElasticPoolOperations == null) {
            this.sqlElasticPoolOperations = new SqlElasticPoolOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlElasticPoolOperations;
    }

    @Override
    public SqlDatabaseOperations.SqlDatabaseActionsDefinition databases() {
        if (this.sqlDatabaseOperations == null) {
            this.sqlDatabaseOperations = new SqlDatabaseOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlDatabaseOperations;
    }

    @Override
    public SqlServerDnsAliasOperations.SqlServerDnsAliasActionsDefinition dnsAliases() {
        if (this.sqlServerDnsAliasOperations == null) {
            this.sqlServerDnsAliasOperations = new SqlServerDnsAliasOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlServerDnsAliasOperations;
    }

    @Override
    public SqlFailoverGroupOperations.SqlFailoverGroupActionsDefinition failoverGroups() {
        if (this.sqlFailoverGroupOperations == null) {
            this.sqlFailoverGroupOperations = new SqlFailoverGroupOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlFailoverGroupOperations;
    }

    @Override
    public SqlServerKeyOperations.SqlServerKeyActionsDefinition serverKeys() {
        if (this.sqlServerKeyOperations == null) {
            this.sqlServerKeyOperations = new SqlServerKeyOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlServerKeyOperations;
    }

    @Override
    public SqlEncryptionProtectorOperations.SqlEncryptionProtectorActionsDefinition encryptionProtectors() {
        if (this.sqlEncryptionProtectorsOperations == null) {
            this.sqlEncryptionProtectorsOperations = new SqlEncryptionProtectorOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlEncryptionProtectorsOperations;
    }

    @Override
    public SqlServerSecurityAlertPolicyOperations.SqlServerSecurityAlertPolicyActionsDefinition serverSecurityAlertPolicies() {
        if (this.sqlServerSecurityAlertPolicyOperations == null) {
            this.sqlServerSecurityAlertPolicyOperations = new SqlServerSecurityAlertPolicyOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlServerSecurityAlertPolicyOperations;
    }

    public SqlElasticPoolImpl defineElasticPool(String name) {
        return this.sqlElasticPools.defineInlineElasticPool(name);
    }

    @Override
    public SqlServerImpl withNewElasticPool(String elasticPoolName, ElasticPoolEditions elasticPoolEdition) {
        return this.sqlElasticPools.defineInlineElasticPool(elasticPoolName).withEdition(elasticPoolEdition).attach();
    }

    @Override
    public SqlServerImpl withoutElasticPool(String elasticPoolName) {
        this.sqlElasticPools.removeInlineElasticPool(elasticPoolName);
        return this;
    }

    @Override
    public SqlServerImpl withNewElasticPool(String elasticPoolName, ElasticPoolEditions elasticPoolEdition, String ... databaseNames) {
        this.withNewElasticPool(elasticPoolName, elasticPoolEdition);
        for (String dbName : databaseNames) {
            this.defineDatabase(dbName).withExistingElasticPool(elasticPoolName).attach();
        }
        return this;
    }

    public SqlDatabaseImpl defineDatabase(String name) {
        return this.sqlDatabases.defineInlineDatabase(name);
    }

    @Override
    public SqlServerImpl withNewDatabase(String databaseName) {
        return this.sqlDatabases.defineInlineDatabase(databaseName).attach();
    }

    @Override
    public SqlServerImpl withoutDatabase(String databaseName) {
        this.sqlDatabases.removeInlineDatabase(databaseName);
        return this;
    }

    @Override
    public SqlServerImpl withSystemAssignedManagedServiceIdentity() {
        ((ServerInner)((Object)this.inner())).withIdentity(new ResourceIdentity().withType(IdentityType.SYSTEM_ASSIGNED));
        return this;
    }
}

