/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.FailoverGroupInner;
import com.microsoft.azure.management.sql.implementation.FailoverGroupUpdateInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class FailoverGroupsInner {
    private FailoverGroupsService service;
    private SqlManagementClientImpl client;

    public FailoverGroupsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (FailoverGroupsService)retrofit.create(FailoverGroupsService.class);
        this.client = client;
    }

    public FailoverGroupInner get(String resourceGroupName, String serverName, String failoverGroupName) {
        return (FailoverGroupInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<FailoverGroupInner> getAsync(String resourceGroupName, String serverName, String failoverGroupName, ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    public Observable<FailoverGroupInner> getAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map((Func1)new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>(){

            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return (FailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FailoverGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.get(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FailoverGroupInner>>>(){

            public Observable<ServiceResponse<FailoverGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FailoverGroupsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FailoverGroupInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FailoverGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FailoverGroupInner createOrUpdate(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters) {
        return (FailoverGroupInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<FailoverGroupInner> createOrUpdateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters, ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters), serviceCallback);
    }

    public Observable<FailoverGroupInner> createOrUpdateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).map((Func1)new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>(){

            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return (FailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FailoverGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<FailoverGroupInner>(){}.getType());
    }

    public FailoverGroupInner beginCreateOrUpdate(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters) {
        return (FailoverGroupInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<FailoverGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters, ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters), serviceCallback);
    }

    public Observable<FailoverGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).map((Func1)new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>(){

            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return (FailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FailoverGroupInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2015-05-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FailoverGroupInner>>>(){

            public Observable<ServiceResponse<FailoverGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FailoverGroupsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FailoverGroupInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FailoverGroupInner>(){}.getType()).register(201, new TypeToken<FailoverGroupInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String failoverGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String failoverGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String serverName, String failoverGroupName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serverName, String failoverGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.beginDelete(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FailoverGroupsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FailoverGroupInner update(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters) {
        return (FailoverGroupInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<FailoverGroupInner> updateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters, ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters), serviceCallback);
    }

    public Observable<FailoverGroupInner> updateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).map((Func1)new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>(){

            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return (FailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FailoverGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<FailoverGroupInner>(){}.getType());
    }

    public FailoverGroupInner beginUpdate(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters) {
        return (FailoverGroupInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<FailoverGroupInner> beginUpdateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters, ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters), serviceCallback);
    }

    public Observable<FailoverGroupInner> beginUpdateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).map((Func1)new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>(){

            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return (FailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FailoverGroupInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        return this.service.beginUpdate(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FailoverGroupInner>>>(){

            public Observable<ServiceResponse<FailoverGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FailoverGroupsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FailoverGroupInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FailoverGroupInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FailoverGroupInner> listByServer(String resourceGroupName, String serverName) {
        ServiceResponse response = (ServiceResponse)this.listByServerSinglePageAsync(resourceGroupName, serverName).toBlocking().single();
        return new PagedList<FailoverGroupInner>((Page)response.body()){

            public Page<FailoverGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FailoverGroupsInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FailoverGroupInner>> listByServerAsync(String resourceGroupName, String serverName, ListOperationCallback<FailoverGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerSinglePageAsync(resourceGroupName, serverName), (Func1)new Func1<String, Observable<ServiceResponse<Page<FailoverGroupInner>>>>(){

            public Observable<ServiceResponse<Page<FailoverGroupInner>>> call(String nextPageLink) {
                return FailoverGroupsInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FailoverGroupInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<Page<FailoverGroupInner>>, Page<FailoverGroupInner>>(){

            public Page<FailoverGroupInner> call(ServiceResponse<Page<FailoverGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FailoverGroupInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        return this.listByServerSinglePageAsync(resourceGroupName, serverName).concatMap((Func1)new Func1<ServiceResponse<Page<FailoverGroupInner>>, Observable<ServiceResponse<Page<FailoverGroupInner>>>>(){

            public Observable<ServiceResponse<Page<FailoverGroupInner>>> call(ServiceResponse<Page<FailoverGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FailoverGroupsInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FailoverGroupInner>>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listByServer(resourceGroupName, serverName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FailoverGroupInner>>>>(){

            public Observable<ServiceResponse<Page<FailoverGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FailoverGroupsInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<FailoverGroupInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<FailoverGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FailoverGroupInner failover(String resourceGroupName, String serverName, String failoverGroupName) {
        return (FailoverGroupInner)((Object)((ServiceResponse)this.failoverWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().last()).body());
    }

    public ServiceFuture<FailoverGroupInner> failoverAsync(String resourceGroupName, String serverName, String failoverGroupName, ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.failoverWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    public Observable<FailoverGroupInner> failoverAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return this.failoverWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map((Func1)new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>(){

            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return (FailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FailoverGroupInner>> failoverWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.failover(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<FailoverGroupInner>(){}.getType());
    }

    public FailoverGroupInner beginFailover(String resourceGroupName, String serverName, String failoverGroupName) {
        return (FailoverGroupInner)((Object)((ServiceResponse)this.beginFailoverWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<FailoverGroupInner> beginFailoverAsync(String resourceGroupName, String serverName, String failoverGroupName, ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginFailoverWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    public Observable<FailoverGroupInner> beginFailoverAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return this.beginFailoverWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map((Func1)new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>(){

            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return (FailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FailoverGroupInner>> beginFailoverWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.beginFailover(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FailoverGroupInner>>>(){

            public Observable<ServiceResponse<FailoverGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FailoverGroupsInner.this.beginFailoverDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FailoverGroupInner> beginFailoverDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FailoverGroupInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FailoverGroupInner forceFailoverAllowDataLoss(String resourceGroupName, String serverName, String failoverGroupName) {
        return (FailoverGroupInner)((Object)((ServiceResponse)this.forceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().last()).body());
    }

    public ServiceFuture<FailoverGroupInner> forceFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String failoverGroupName, ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.forceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    public Observable<FailoverGroupInner> forceFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return this.forceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map((Func1)new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>(){

            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return (FailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FailoverGroupInner>> forceFailoverAllowDataLossWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.forceFailoverAllowDataLoss(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<FailoverGroupInner>(){}.getType());
    }

    public FailoverGroupInner beginForceFailoverAllowDataLoss(String resourceGroupName, String serverName, String failoverGroupName) {
        return (FailoverGroupInner)((Object)((ServiceResponse)this.beginForceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<FailoverGroupInner> beginForceFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String failoverGroupName, ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginForceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    public Observable<FailoverGroupInner> beginForceFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return this.beginForceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map((Func1)new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>(){

            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return (FailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FailoverGroupInner>> beginForceFailoverAllowDataLossWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.beginForceFailoverAllowDataLoss(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FailoverGroupInner>>>(){

            public Observable<ServiceResponse<FailoverGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FailoverGroupsInner.this.beginForceFailoverAllowDataLossDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FailoverGroupInner> beginForceFailoverAllowDataLossDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FailoverGroupInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FailoverGroupInner> listByServerNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FailoverGroupInner>((Page)response.body()){

            public Page<FailoverGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FailoverGroupsInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FailoverGroupInner>> listByServerNextAsync(String nextPageLink, ServiceFuture<List<FailoverGroupInner>> serviceFuture, ListOperationCallback<FailoverGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FailoverGroupInner>>>>(){

            public Observable<ServiceResponse<Page<FailoverGroupInner>>> call(String nextPageLink) {
                return FailoverGroupsInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FailoverGroupInner>> listByServerNextAsync(String nextPageLink) {
        return this.listByServerNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FailoverGroupInner>>, Page<FailoverGroupInner>>(){

            public Page<FailoverGroupInner> call(ServiceResponse<Page<FailoverGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FailoverGroupInner>>> listByServerNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByServerNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FailoverGroupInner>>, Observable<ServiceResponse<Page<FailoverGroupInner>>>>(){

            public Observable<ServiceResponse<Page<FailoverGroupInner>>> call(ServiceResponse<Page<FailoverGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FailoverGroupsInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FailoverGroupInner>>> listByServerNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByServerNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FailoverGroupInner>>>>(){

            public Observable<ServiceResponse<Page<FailoverGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FailoverGroupsInner.this.listByServerNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<FailoverGroupInner>> listByServerNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<FailoverGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface FailoverGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Body FailoverGroupInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Body FailoverGroupInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Body FailoverGroupUpdateInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Body FailoverGroupUpdateInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups failover"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}/failover")
        public Observable<Response<ResponseBody>> failover(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups beginFailover"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}/failover")
        public Observable<Response<ResponseBody>> beginFailover(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups forceFailoverAllowDataLoss"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}/forceFailoverAllowDataLoss")
        public Observable<Response<ResponseBody>> forceFailoverAllowDataLoss(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups beginForceFailoverAllowDataLoss"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}/forceFailoverAllowDataLoss")
        public Observable<Response<ResponseBody>> beginForceFailoverAllowDataLoss(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups listByServerNext"})
        @GET
        public Observable<Response<ResponseBody>> listByServerNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

