/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.VirtualNetworkRuleInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualNetworkRulesInner {
    private VirtualNetworkRulesService service;
    private SqlManagementClientImpl client;

    public VirtualNetworkRulesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (VirtualNetworkRulesService)retrofit.create(VirtualNetworkRulesService.class);
        this.client = client;
    }

    public VirtualNetworkRuleInner get(String resourceGroupName, String serverName, String virtualNetworkRuleName) {
        return (VirtualNetworkRuleInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<VirtualNetworkRuleInner> getAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName, ServiceCallback<VirtualNetworkRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName), serviceCallback);
    }

    public Observable<VirtualNetworkRuleInner> getAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName).map((Func1)new Func1<ServiceResponse<VirtualNetworkRuleInner>, VirtualNetworkRuleInner>(){

            public VirtualNetworkRuleInner call(ServiceResponse<VirtualNetworkRuleInner> response) {
                return (VirtualNetworkRuleInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkRuleInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (virtualNetworkRuleName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.get(resourceGroupName, serverName, virtualNetworkRuleName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkRuleInner>>>(){

            public Observable<ServiceResponse<VirtualNetworkRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkRulesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualNetworkRuleInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualNetworkRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualNetworkRuleInner createOrUpdate(String resourceGroupName, String serverName, String virtualNetworkRuleName, VirtualNetworkRuleInner parameters) {
        return (VirtualNetworkRuleInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<VirtualNetworkRuleInner> createOrUpdateAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName, VirtualNetworkRuleInner parameters, ServiceCallback<VirtualNetworkRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName, parameters), serviceCallback);
    }

    public Observable<VirtualNetworkRuleInner> createOrUpdateAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName, VirtualNetworkRuleInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName, parameters).map((Func1)new Func1<ServiceResponse<VirtualNetworkRuleInner>, VirtualNetworkRuleInner>(){

            public VirtualNetworkRuleInner call(ServiceResponse<VirtualNetworkRuleInner> response) {
                return (VirtualNetworkRuleInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkRuleInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName, VirtualNetworkRuleInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (virtualNetworkRuleName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, virtualNetworkRuleName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualNetworkRuleInner>(){}.getType());
    }

    public VirtualNetworkRuleInner beginCreateOrUpdate(String resourceGroupName, String serverName, String virtualNetworkRuleName, VirtualNetworkRuleInner parameters) {
        return (VirtualNetworkRuleInner)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<VirtualNetworkRuleInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName, VirtualNetworkRuleInner parameters, ServiceCallback<VirtualNetworkRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName, parameters), serviceCallback);
    }

    public Observable<VirtualNetworkRuleInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName, VirtualNetworkRuleInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName, parameters).map((Func1)new Func1<ServiceResponse<VirtualNetworkRuleInner>, VirtualNetworkRuleInner>(){

            public VirtualNetworkRuleInner call(ServiceResponse<VirtualNetworkRuleInner> response) {
                return (VirtualNetworkRuleInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkRuleInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName, VirtualNetworkRuleInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (virtualNetworkRuleName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, virtualNetworkRuleName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkRuleInner>>>(){

            public Observable<ServiceResponse<VirtualNetworkRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkRulesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualNetworkRuleInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualNetworkRuleInner>(){}.getType()).register(201, new TypeToken<VirtualNetworkRuleInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String virtualNetworkRuleName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (virtualNetworkRuleName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, serverName, virtualNetworkRuleName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String serverName, String virtualNetworkRuleName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, virtualNetworkRuleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serverName, String virtualNetworkRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (virtualNetworkRuleName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.beginDelete(resourceGroupName, serverName, virtualNetworkRuleName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkRulesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualNetworkRuleInner> listByServer(String resourceGroupName, String serverName) {
        ServiceResponse response = (ServiceResponse)this.listByServerSinglePageAsync(resourceGroupName, serverName).toBlocking().single();
        return new PagedList<VirtualNetworkRuleInner>((Page)response.body()){

            public Page<VirtualNetworkRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualNetworkRulesInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualNetworkRuleInner>> listByServerAsync(String resourceGroupName, String serverName, ListOperationCallback<VirtualNetworkRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerSinglePageAsync(resourceGroupName, serverName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>> call(String nextPageLink) {
                return VirtualNetworkRulesInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualNetworkRuleInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<Page<VirtualNetworkRuleInner>>, Page<VirtualNetworkRuleInner>>(){

            public Page<VirtualNetworkRuleInner> call(ServiceResponse<Page<VirtualNetworkRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        return this.listByServerSinglePageAsync(resourceGroupName, serverName).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualNetworkRuleInner>>, Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>> call(ServiceResponse<Page<VirtualNetworkRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualNetworkRulesInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listByServer(resourceGroupName, serverName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualNetworkRulesInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualNetworkRuleInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualNetworkRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualNetworkRuleInner> listByServerNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualNetworkRuleInner>((Page)response.body()){

            public Page<VirtualNetworkRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualNetworkRulesInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualNetworkRuleInner>> listByServerNextAsync(String nextPageLink, ServiceFuture<List<VirtualNetworkRuleInner>> serviceFuture, ListOperationCallback<VirtualNetworkRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>> call(String nextPageLink) {
                return VirtualNetworkRulesInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualNetworkRuleInner>> listByServerNextAsync(String nextPageLink) {
        return this.listByServerNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualNetworkRuleInner>>, Page<VirtualNetworkRuleInner>>(){

            public Page<VirtualNetworkRuleInner> call(ServiceResponse<Page<VirtualNetworkRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>> listByServerNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByServerNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualNetworkRuleInner>>, Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>> call(ServiceResponse<Page<VirtualNetworkRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualNetworkRulesInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>> listByServerNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByServerNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualNetworkRulesInner.this.listByServerNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualNetworkRuleInner>> listByServerNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualNetworkRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualNetworkRulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualNetworkRules get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="virtualNetworkRuleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualNetworkRules createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="virtualNetworkRuleName") String var3, @Path(value="subscriptionId") String var4, @Body VirtualNetworkRuleInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualNetworkRules beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="virtualNetworkRuleName") String var3, @Path(value="subscriptionId") String var4, @Body VirtualNetworkRuleInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualNetworkRules delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="virtualNetworkRuleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualNetworkRules beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="virtualNetworkRuleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualNetworkRules listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/virtualNetworkRules")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualNetworkRules listByServerNext"})
        @GET
        public Observable<Response<ResponseBody>> listByServerNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

