/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.sql.ServerKeyType;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.SqlServerKey;
import com.microsoft.azure.management.sql.SqlServerKeyOperations;
import com.microsoft.azure.management.sql.implementation.ServerKeyInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.Objects;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlServerKeyImpl
extends ExternalChildResourceImpl<SqlServerKey, ServerKeyInner, SqlServerImpl, SqlServer>
implements SqlServerKey,
SqlServerKey.Update,
SqlServerKeyOperations.SqlServerKeyOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String serverKeyName;

    SqlServerKeyImpl(String name, SqlServerImpl parent, ServerKeyInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
        if (innerObject != null && innerObject.name() != null) {
            this.serverKeyName = innerObject.name();
        }
    }

    SqlServerKeyImpl(String resourceGroupName, String sqlServerName, String name, ServerKeyInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        if (innerObject != null && innerObject.name() != null) {
            this.serverKeyName = innerObject.name();
        }
    }

    SqlServerKeyImpl(String name, ServerKeyInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            if (innerObject.name() != null) {
                this.serverKeyName = innerObject.name();
            }
            try {
                ResourceId resourceId = ResourceId.fromString((String)innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String id() {
        return ((ServerKeyInner)this.inner()).id();
    }

    public String name() {
        return this.serverKeyName;
    }

    @Override
    public SqlServerKeyImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlServerKeyImpl withExistingSqlServerId(String sqlServerId) {
        Objects.requireNonNull(sqlServerId);
        ResourceId resourceId = ResourceId.fromString((String)sqlServerId);
        this.resourceGroupName = resourceId.resourceGroupName();
        this.sqlServerName = resourceId.name();
        return this;
    }

    @Override
    public SqlServerKeyImpl withExistingSqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        return this;
    }

    @Override
    public SqlServerKeyImpl withAzureKeyVaultKey(String uri) {
        ((ServerKeyInner)this.inner()).withServerKeyType(ServerKeyType.AZURE_KEY_VAULT);
        ((ServerKeyInner)this.inner()).withUri(uri);
        String[] items = uri.split("\\/");
        this.serverKeyName = String.format("%s_%s_%s", items[2].split("\\.")[0], items[4], items[5]);
        return this;
    }

    @Override
    public SqlServerKeyImpl withThumbprint(String thumbprint) {
        ((ServerKeyInner)this.inner()).withThumbprint(thumbprint);
        return this;
    }

    @Override
    public SqlServerKeyImpl withCreationDate(DateTime creationDate) {
        ((ServerKeyInner)this.inner()).withCreationDate(creationDate);
        return this;
    }

    public Observable<SqlServerKey> createResourceAsync() {
        final SqlServerKeyImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverKeys().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, self.serverKeyName, (ServerKeyInner)self.inner()).map((Func1)new Func1<ServerKeyInner, SqlServerKey>(){

            public SqlServerKey call(ServerKeyInner serverKeyInner) {
                self.setInner(serverKeyInner);
                return self;
            }
        });
    }

    public Observable<SqlServerKey> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Observable<Void> deleteResourceAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverKeys().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    protected Observable<ServerKeyInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverKeys().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)((ServerKeyInner)this.inner()).id());
    }

    @Override
    public String kind() {
        return ((ServerKeyInner)this.inner()).kind();
    }

    @Override
    public Region region() {
        return Region.fromName((String)((ServerKeyInner)this.inner()).location());
    }

    @Override
    public ServerKeyType serverKeyType() {
        return ((ServerKeyInner)this.inner()).serverKeyType();
    }

    @Override
    public String uri() {
        return ((ServerKeyInner)this.inner()).uri();
    }

    @Override
    public String thumbprint() {
        return ((ServerKeyInner)this.inner()).thumbprint();
    }

    @Override
    public DateTime creationDate() {
        return ((ServerKeyInner)this.inner()).creationDate();
    }

    @Override
    public void delete() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverKeys().delete(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public Completable deleteAsync() {
        return this.deleteResourceAsync().toCompletable();
    }

    public SqlServerKey.Update update() {
        super.prepareUpdate();
        return this;
    }
}

