/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.StorageKeyType;
import com.microsoft.azure.management.sql.AuthenticationType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Import database parameters.
 */
@JsonFlatten
public class ImportExtensionRequestInner {
    /**
     * The name of the extension.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * The type of the extension.
     */
    @JsonProperty(value = "type")
    private String type;

    /**
     * The type of the storage key to use. Possible values include:
     * 'StorageAccessKey', 'SharedAccessKey'.
     */
    @JsonProperty(value = "properties.storageKeyType", required = true)
    private StorageKeyType storageKeyType;

    /**
     * The storage key to use.  If storage key type is SharedAccessKey, it must
     * be preceded with a "?.".
     */
    @JsonProperty(value = "properties.storageKey", required = true)
    private String storageKey;

    /**
     * The storage uri to use.
     */
    @JsonProperty(value = "properties.storageUri", required = true)
    private String storageUri;

    /**
     * The name of the SQL administrator.
     */
    @JsonProperty(value = "properties.administratorLogin", required = true)
    private String administratorLogin;

    /**
     * The password of the SQL administrator.
     */
    @JsonProperty(value = "properties.administratorLoginPassword", required = true)
    private String administratorLoginPassword;

    /**
     * The authentication type. Possible values include: 'SQL', 'ADPassword'.
     */
    @JsonProperty(value = "properties.authenticationType")
    private AuthenticationType authenticationType;

    /**
     * The type of import operation being performed. This is always Import.
     */
    @JsonProperty(value = "properties.operationMode", required = true)
    private String operationMode;

    /**
     * Creates an instance of ImportExtensionRequestInner class.
     */
    public ImportExtensionRequestInner() {
        operationMode = "Import";
    }

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the ImportExtensionRequestInner object itself.
     */
    public ImportExtensionRequestInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type value.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type value.
     *
     * @param type the type value to set
     * @return the ImportExtensionRequestInner object itself.
     */
    public ImportExtensionRequestInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the storageKeyType value.
     *
     * @return the storageKeyType value
     */
    public StorageKeyType storageKeyType() {
        return this.storageKeyType;
    }

    /**
     * Set the storageKeyType value.
     *
     * @param storageKeyType the storageKeyType value to set
     * @return the ImportExtensionRequestInner object itself.
     */
    public ImportExtensionRequestInner withStorageKeyType(StorageKeyType storageKeyType) {
        this.storageKeyType = storageKeyType;
        return this;
    }

    /**
     * Get the storageKey value.
     *
     * @return the storageKey value
     */
    public String storageKey() {
        return this.storageKey;
    }

    /**
     * Set the storageKey value.
     *
     * @param storageKey the storageKey value to set
     * @return the ImportExtensionRequestInner object itself.
     */
    public ImportExtensionRequestInner withStorageKey(String storageKey) {
        this.storageKey = storageKey;
        return this;
    }

    /**
     * Get the storageUri value.
     *
     * @return the storageUri value
     */
    public String storageUri() {
        return this.storageUri;
    }

    /**
     * Set the storageUri value.
     *
     * @param storageUri the storageUri value to set
     * @return the ImportExtensionRequestInner object itself.
     */
    public ImportExtensionRequestInner withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    /**
     * Get the administratorLogin value.
     *
     * @return the administratorLogin value
     */
    public String administratorLogin() {
        return this.administratorLogin;
    }

    /**
     * Set the administratorLogin value.
     *
     * @param administratorLogin the administratorLogin value to set
     * @return the ImportExtensionRequestInner object itself.
     */
    public ImportExtensionRequestInner withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    /**
     * Get the administratorLoginPassword value.
     *
     * @return the administratorLoginPassword value
     */
    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    /**
     * Set the administratorLoginPassword value.
     *
     * @param administratorLoginPassword the administratorLoginPassword value to set
     * @return the ImportExtensionRequestInner object itself.
     */
    public ImportExtensionRequestInner withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    /**
     * Get the authenticationType value.
     *
     * @return the authenticationType value
     */
    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType value.
     *
     * @param authenticationType the authenticationType value to set
     * @return the ImportExtensionRequestInner object itself.
     */
    public ImportExtensionRequestInner withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the operationMode value.
     *
     * @return the operationMode value
     */
    public String operationMode() {
        return this.operationMode;
    }

    /**
     * Set the operationMode value.
     *
     * @param operationMode the operationMode value to set
     * @return the ImportExtensionRequestInner object itself.
     */
    public ImportExtensionRequestInner withOperationMode(String operationMode) {
        this.operationMode = operationMode;
        return this;
    }

}
