/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.VulnerabilityAssessmentRecurringScansProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * A database vulnerability assessment.
 */
@JsonFlatten
public class DatabaseVulnerabilityAssessmentInner extends ProxyResourceInner {
    /**
     * A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/).
     */
    @JsonProperty(value = "properties.storageContainerPath", required = true)
    private String storageContainerPath;

    /**
     * A shared access signature (SAS Key) that has write access to the blob
     * container specified in 'storageContainerPath' parameter. If
     * 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is
     * required.
     */
    @JsonProperty(value = "properties.storageContainerSasKey")
    private String storageContainerSasKey;

    /**
     * Specifies the identifier key of the vulnerability assessment storage
     * account. If 'StorageContainerSasKey' isn't specified,
     * storageAccountAccessKey is required.
     */
    @JsonProperty(value = "properties.storageAccountAccessKey")
    private String storageAccountAccessKey;

    /**
     * The recurring scans settings.
     */
    @JsonProperty(value = "properties.recurringScans")
    private VulnerabilityAssessmentRecurringScansProperties recurringScans;

    /**
     * Get the storageContainerPath value.
     *
     * @return the storageContainerPath value
     */
    public String storageContainerPath() {
        return this.storageContainerPath;
    }

    /**
     * Set the storageContainerPath value.
     *
     * @param storageContainerPath the storageContainerPath value to set
     * @return the DatabaseVulnerabilityAssessmentInner object itself.
     */
    public DatabaseVulnerabilityAssessmentInner withStorageContainerPath(String storageContainerPath) {
        this.storageContainerPath = storageContainerPath;
        return this;
    }

    /**
     * Get the storageContainerSasKey value.
     *
     * @return the storageContainerSasKey value
     */
    public String storageContainerSasKey() {
        return this.storageContainerSasKey;
    }

    /**
     * Set the storageContainerSasKey value.
     *
     * @param storageContainerSasKey the storageContainerSasKey value to set
     * @return the DatabaseVulnerabilityAssessmentInner object itself.
     */
    public DatabaseVulnerabilityAssessmentInner withStorageContainerSasKey(String storageContainerSasKey) {
        this.storageContainerSasKey = storageContainerSasKey;
        return this;
    }

    /**
     * Get the storageAccountAccessKey value.
     *
     * @return the storageAccountAccessKey value
     */
    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    /**
     * Set the storageAccountAccessKey value.
     *
     * @param storageAccountAccessKey the storageAccountAccessKey value to set
     * @return the DatabaseVulnerabilityAssessmentInner object itself.
     */
    public DatabaseVulnerabilityAssessmentInner withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    /**
     * Get the recurringScans value.
     *
     * @return the recurringScans value
     */
    public VulnerabilityAssessmentRecurringScansProperties recurringScans() {
        return this.recurringScans;
    }

    /**
     * Set the recurringScans value.
     *
     * @param recurringScans the recurringScans value to set
     * @return the DatabaseVulnerabilityAssessmentInner object itself.
     */
    public DatabaseVulnerabilityAssessmentInner withRecurringScans(VulnerabilityAssessmentRecurringScansProperties recurringScans) {
        this.recurringScans = recurringScans;
        return this;
    }

}
