/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * A backup long term retention vault.
 */
@JsonFlatten
public class BackupLongTermRetentionVaultInner extends ProxyResourceInner {
    /**
     * The geo-location where the resource lives.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /**
     * The azure recovery services vault resource id.
     */
    @JsonProperty(value = "properties.recoveryServicesVaultResourceId", required = true)
    private String recoveryServicesVaultResourceId;

    /**
     * Get the location value.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the recoveryServicesVaultResourceId value.
     *
     * @return the recoveryServicesVaultResourceId value
     */
    public String recoveryServicesVaultResourceId() {
        return this.recoveryServicesVaultResourceId;
    }

    /**
     * Set the recoveryServicesVaultResourceId value.
     *
     * @param recoveryServicesVaultResourceId the recoveryServicesVaultResourceId value to set
     * @return the BackupLongTermRetentionVaultInner object itself.
     */
    public BackupLongTermRetentionVaultInner withRecoveryServicesVaultResourceId(String recoveryServicesVaultResourceId) {
        this.recoveryServicesVaultResourceId = recoveryServicesVaultResourceId;
        return this;
    }

}
