/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.servicebus.NamespaceAuthorizationRule;
import com.microsoft.azure.management.servicebus.Policykey;
import com.microsoft.azure.management.servicebus.implementation.AuthorizationRuleBaseImpl;
import com.microsoft.azure.management.servicebus.implementation.ResourceListKeysInner;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusNamespaceImpl;
import com.microsoft.azure.management.servicebus.implementation.SharedAccessAuthorizationRuleInner;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class NamespaceAuthorizationRuleImpl
extends AuthorizationRuleBaseImpl<NamespaceAuthorizationRule, ServiceBusNamespaceImpl, SharedAccessAuthorizationRuleInner, NamespaceAuthorizationRuleImpl, ServiceBusManager>
implements NamespaceAuthorizationRule,
NamespaceAuthorizationRule.Definition,
NamespaceAuthorizationRule.Update {
    private final Region region;

    NamespaceAuthorizationRuleImpl(String resourceGroupName, String namespaceName, String name, Region region, SharedAccessAuthorizationRuleInner inner, ServiceBusManager manager) {
        super(name, inner, manager);
        this.region = region;
        this.withExistingParentResource(resourceGroupName, namespaceName);
        if (inner.location() == null) {
            inner.withLocation(this.region.toString());
        }
    }

    @Override
    public String namespaceName() {
        return this.parentName;
    }

    protected Observable<SharedAccessAuthorizationRuleInner> getInnerAsync() {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).namespaces().getAuthorizationRuleAsync(this.resourceGroupName(), this.namespaceName(), this.name());
    }

    protected Observable<NamespaceAuthorizationRule> createChildResourceAsync() {
        final NamespaceAuthorizationRuleImpl self = this;
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).namespaces().createOrUpdateAuthorizationRuleAsync(this.resourceGroupName(), this.namespaceName(), this.name(), ((SharedAccessAuthorizationRuleInner)((Object)this.inner())).rights()).map((Func1)new Func1<SharedAccessAuthorizationRuleInner, NamespaceAuthorizationRule>(){

            public NamespaceAuthorizationRule call(SharedAccessAuthorizationRuleInner inner) {
                NamespaceAuthorizationRuleImpl.this.setInner((Object)inner);
                return self;
            }
        });
    }

    @Override
    protected Observable<ResourceListKeysInner> getKeysInnerAsync() {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).namespaces().listKeysAsync(this.resourceGroupName(), this.namespaceName(), this.name());
    }

    @Override
    protected Observable<ResourceListKeysInner> regenerateKeysInnerAsync(Policykey policykey) {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).namespaces().regenerateKeysAsync(this.resourceGroupName(), this.namespaceName(), this.name(), policykey);
    }
}

