/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChildResource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.servicebus.EntityStatus;
import com.microsoft.azure.management.servicebus.QueueAuthorizationRules;
import com.microsoft.azure.management.servicebus.implementation.QueueInner;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import org.joda.time.DateTime;
import org.joda.time.Period;

@Fluent
public interface Queue
extends IndependentChildResource<ServiceBusManager, QueueInner>,
Refreshable<Queue>,
Updatable<Update> {
    public DateTime createdAt();

    public DateTime accessedAt();

    public DateTime updatedAt();

    public long maxSizeInMB();

    public long currentSizeInBytes();

    public boolean isBatchedOperationsEnabled();

    public boolean isDeadLetteringEnabledForExpiredMessages();

    public boolean isExpressEnabled();

    public boolean isPartitioningEnabled();

    public boolean isSessionEnabled();

    public boolean isDuplicateDetectionEnabled();

    public long lockDurationInSeconds();

    public long deleteOnIdleDurationInMinutes();

    public Period defaultMessageTtlDuration();

    public Period duplicateMessageDetectionHistoryDuration();

    public int maxDeliveryCountBeforeDeadLetteringMessage();

    public long messageCount();

    public long activeMessageCount();

    public long deadLetterMessageCount();

    public long scheduledMessageCount();

    public long transferDeadLetterMessageCount();

    public long transferMessageCount();

    public EntityStatus status();

    public QueueAuthorizationRules authorizationRules();

    public static interface UpdateStages {

        public static interface WithAuthorizationRule {
            public Update withNewSendRule(String var1);

            public Update withNewListenRule(String var1);

            public Update withNewManageRule(String var1);

            public Update withoutAuthorizationRule(String var1);
        }

        public static interface WithMessageMovedToDeadLetterQueueOnMaxDeliveryCount {
            public Update withMessageMovedToDeadLetterQueueOnMaxDeliveryCount(int var1);
        }

        public static interface WithExpiredMessageMovedToDeadLetterQueue {
            public Update withExpiredMessageMovedToDeadLetterQueue();

            public Update withoutExpiredMessageMovedToDeadLetterQueue();
        }

        public static interface WithDuplicateMessageDetection {
            public Update withDuplicateMessageDetectionHistoryDuration(Period var1);

            public Update withoutDuplicateMessageDetection();
        }

        public static interface WithMessageBatching {
            public Update withMessageBatching();

            public Update withoutMessageBatching();
        }

        public static interface WithExpressMessage {
            public Update withExpressMessage();

            public Update withoutExpressMessage();
        }

        public static interface WithSession {
            public Update withSession();

            public Update withoutSession();
        }

        public static interface WithDefaultMessageTTL {
            public Update withDefaultMessageTTL(Period var1);
        }

        public static interface WithMessageLockDuration {
            public Update withMessageLockDurationInSeconds(int var1);
        }

        public static interface WithDeleteOnIdle {
            public Update withDeleteOnIdleDurationInMinutes(int var1);
        }

        public static interface WithSize {
            public Update withSizeInMB(long var1);
        }
    }

    public static interface Update
    extends Appliable<Queue>,
    UpdateStages.WithSize,
    UpdateStages.WithDeleteOnIdle,
    UpdateStages.WithMessageLockDuration,
    UpdateStages.WithDefaultMessageTTL,
    UpdateStages.WithSession,
    UpdateStages.WithExpressMessage,
    UpdateStages.WithMessageBatching,
    UpdateStages.WithDuplicateMessageDetection,
    UpdateStages.WithExpiredMessageMovedToDeadLetterQueue,
    UpdateStages.WithMessageMovedToDeadLetterQueueOnMaxDeliveryCount,
    UpdateStages.WithAuthorizationRule {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Queue>,
        WithSize,
        WithPartitioning,
        WithDeleteOnIdle,
        WithMessageLockDuration,
        WithDefaultMessageTTL,
        WithSession,
        WithExpressMessage,
        WithMessageBatching,
        WithDuplicateMessageDetection,
        WithExpiredMessageMovedToDeadLetterQueue,
        WithMessageMovedToDeadLetterQueueOnMaxDeliveryCount,
        WithAuthorizationRule {
        }

        public static interface WithAuthorizationRule {
            public WithCreate withNewSendRule(String var1);

            public WithCreate withNewListenRule(String var1);

            public WithCreate withNewManageRule(String var1);
        }

        public static interface WithMessageMovedToDeadLetterQueueOnMaxDeliveryCount {
            public WithCreate withMessageMovedToDeadLetterQueueOnMaxDeliveryCount(int var1);
        }

        public static interface WithExpiredMessageMovedToDeadLetterQueue {
            public WithCreate withExpiredMessageMovedToDeadLetterQueue();
        }

        public static interface WithDuplicateMessageDetection {
            public WithCreate withDuplicateMessageDetection(Period var1);
        }

        public static interface WithMessageBatching {
            public WithCreate withoutMessageBatching();
        }

        public static interface WithExpressMessage {
            public WithCreate withExpressMessage();
        }

        public static interface WithSession {
            public WithCreate withSession();
        }

        public static interface WithDefaultMessageTTL {
            public WithCreate withDefaultMessageTTL(Period var1);
        }

        public static interface WithMessageLockDuration {
            public WithCreate withMessageLockDurationInSeconds(int var1);
        }

        public static interface WithDeleteOnIdle {
            public WithCreate withDeleteOnIdleDurationInMinutes(int var1);
        }

        public static interface WithPartitioning {
            public WithCreate withPartitioning();

            public WithCreate withoutPartitioning();
        }

        public static interface WithSize {
            public WithCreate withSizeInMB(long var1);
        }

        public static interface Blank
        extends WithCreate {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate {
    }
}

