/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.utils;

import com.microsoft.azure.credentials.AzureTokenCredentials;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class AuxiliaryCredentialsInterceptor
implements Interceptor {
    private static final String AUTHORIZATION_AUXILIARY_HEADER = "x-ms-authorization-auxiliary";
    private static final String LINKED_AUTHORIZATION_FAILED = "LinkedAuthorizationFailed";
    private static final String SCHEMA = "Bearer";
    private final AzureTokenCredentials[] tokenCredentials;

    public AuxiliaryCredentialsInterceptor(AzureTokenCredentials ... credentials) {
        this.tokenCredentials = credentials;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (this.tokenCredentials != null && this.tokenCredentials.length > 0) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < this.tokenCredentials.length; ++i) {
                buff.append(SCHEMA);
                buff.append(" ");
                buff.append(this.tokenCredentials[i].getToken(chain.request().url().scheme() + "://" + chain.request().url().host()));
                if (i >= this.tokenCredentials.length - 1) continue;
                buff.append(",");
            }
            Request request = chain.request().newBuilder().header(AUTHORIZATION_AUXILIARY_HEADER, buff.toString()).build();
            return chain.proceed(request);
        }
        return chain.proceed(chain.request());
    }
}

