/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm;

import com.microsoft.azure.management.resources.Provider;
import com.microsoft.azure.management.resources.ProviderResourceType;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static String groupFromResourceId(String id) {
        return id != null ? ResourceId.fromString(id).resourceGroupName() : null;
    }

    public static String subscriptionFromResourceId(String id) {
        return id != null ? ResourceId.fromString(id).subscriptionId() : null;
    }

    public static String resourceProviderFromResourceId(String id) {
        return id != null ? ResourceId.fromString(id).providerNamespace() : null;
    }

    public static String resourceTypeFromResourceId(String id) {
        return id != null ? ResourceId.fromString(id).resourceType() : null;
    }

    public static String parentResourceIdFromResourceId(String id) {
        if (id == null) {
            return null;
        }
        ResourceId resourceId = ResourceId.fromString(id);
        if (resourceId != null && resourceId.parent() != null) {
            return ResourceId.fromString(id).parent().id();
        }
        return null;
    }

    public static String parentRelativePathFromResourceId(String id) {
        if (id == null) {
            return null;
        }
        ResourceId parent = ResourceId.fromString(id).parent();
        if (parent != null) {
            return parent.resourceType() + "/" + parent.name();
        }
        return "";
    }

    public static String relativePathFromResourceId(String id) {
        if (id == null) {
            return null;
        }
        String[] paths = id.split("/providers/" + ResourceUtils.resourceProviderFromResourceId(id) + "/", 2);
        if (paths.length == 1) {
            return "";
        }
        return paths[1];
    }

    public static String extractFromResourceId(String id, String identifier) {
        if (id == null || identifier == null) {
            return id;
        }
        Pattern pattern = Pattern.compile(identifier + "/[-\\w._]+");
        Matcher matcher = pattern.matcher(id);
        if (matcher.find()) {
            return matcher.group().split("/")[1];
        }
        return null;
    }

    public static String nameFromResourceId(String id) {
        return id != null ? ResourceId.fromString(id).name() : null;
    }

    public static String defaultApiVersion(String id, Provider provider) {
        if (id == null) {
            return null;
        }
        String resourceType = ResourceUtils.resourceTypeForApiVersion(id);
        for (ProviderResourceType prt : provider.resourceTypes()) {
            if (!prt.resourceType().equalsIgnoreCase(resourceType)) continue;
            return prt.apiVersions().get(0);
        }
        return ResourceUtils.defaultApiVersion(ResourceUtils.parentResourceIdFromResourceId(id), provider);
    }

    private static String resourceTypeForApiVersion(String id) {
        String type = ResourceUtils.resourceTypeFromResourceId(id);
        String parent = ResourceUtils.parentResourceIdFromResourceId(id);
        while (parent != null) {
            type = ResourceUtils.resourceTypeFromResourceId(parent) + "/" + type;
            parent = ResourceUtils.parentResourceIdFromResourceId(parent);
        }
        return type;
    }

    public static String constructResourceId(String subscriptionId, String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName, String parentResourcePath) {
        String prefixedParentPath = parentResourcePath;
        if (parentResourcePath != null && !parentResourcePath.isEmpty()) {
            prefixedParentPath = "/" + parentResourcePath;
        }
        return String.format("/subscriptions/%s/resourcegroups/%s/providers/%s%s/%s/%s", subscriptionId, resourceGroupName, resourceProviderNamespace, prefixedParentPath, resourceType, resourceName);
    }
}

