/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for PropertyChangeType.
 */
public enum PropertyChangeType {
    /** The property does not exist in the current state but is present in the desired state. The property will be created when the deployment is executed. */
    CREATE("Create"),

    /** The property exists in the current state and is missing from the desired state. It will be deleted when the deployment is executed. */
    DELETE("Delete"),

    /** The property exists in both current and desired state and is different. The value of the property will change when the deployment is executed. */
    MODIFY("Modify"),

    /** The property is an array and contains nested changes. */
    ARRAY("Array");

    /** The actual serialized value for a PropertyChangeType instance. */
    private String value;

    PropertyChangeType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a PropertyChangeType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed PropertyChangeType object, or null if unable to parse.
     */
    @JsonCreator
    public static PropertyChangeType fromString(String value) {
        PropertyChangeType[] items = PropertyChangeType.values();
        for (PropertyChangeType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
