/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.Location;
import com.microsoft.azure.management.resources.Subscription;
import com.microsoft.azure.management.resources.SubscriptionPolicies;
import com.microsoft.azure.management.resources.SubscriptionState;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.implementation.LocationImpl;
import com.microsoft.azure.management.resources.implementation.LocationInner;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.SubscriptionInner;
import com.microsoft.azure.management.resources.implementation.SubscriptionsInner;
import java.util.List;
import rx.Observable;

final class SubscriptionImpl
extends IndexableWrapperImpl<SubscriptionInner>
implements Subscription {
    private final SubscriptionsInner client;

    SubscriptionImpl(SubscriptionInner innerModel, SubscriptionsInner client) {
        super(innerModel);
        this.client = client;
    }

    @Override
    public String subscriptionId() {
        return ((SubscriptionInner)this.inner()).subscriptionId();
    }

    @Override
    public String displayName() {
        return ((SubscriptionInner)this.inner()).displayName();
    }

    @Override
    public SubscriptionState state() {
        return ((SubscriptionInner)this.inner()).state();
    }

    @Override
    public SubscriptionPolicies subscriptionPolicies() {
        return ((SubscriptionInner)this.inner()).subscriptionPolicies();
    }

    @Override
    public PagedList<Location> listLocations() {
        PagedListConverter<LocationInner, Location> converter = new PagedListConverter<LocationInner, Location>(){

            @Override
            public Observable<Location> typeConvertAsync(LocationInner locationInner) {
                return Observable.just((Object)new LocationImpl(locationInner));
            }
        };
        return converter.convert(this.toPagedList(this.client.listLocations(this.subscriptionId())));
    }

    @Override
    public Location getLocationByRegion(Region region) {
        if (region != null) {
            PagedList<Location> locations = this.listLocations();
            for (Location location : locations) {
                if (!region.equals(location.region())) continue;
                return location;
            }
        }
        return null;
    }

    private PagedList<LocationInner> toPagedList(List<LocationInner> list) {
        PageImpl<LocationInner> page = new PageImpl<LocationInner>();
        page.setItems(list);
        page.setNextPageLink(null);
        return new PagedList<LocationInner>(page){

            public Page<LocationInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }
}

