/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.dag;

import com.microsoft.azure.management.resources.fluentcore.dag.DAGNode;
import com.microsoft.azure.management.resources.fluentcore.dag.Graph;
import com.microsoft.azure.management.resources.fluentcore.dag.Node;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.StringUtils;

public class DAGraph<DataT, NodeT extends DAGNode<DataT, NodeT>>
extends Graph<DataT, NodeT> {
    private final NodeT rootNode;
    protected List<DAGraph<DataT, NodeT>> parentDAGs = new ArrayList<DAGraph<DataT, NodeT>>();
    protected ConcurrentLinkedQueue<String> queue;

    public DAGraph(NodeT rootNode) {
        this.rootNode = rootNode;
        this.queue = new ConcurrentLinkedQueue();
        ((DAGNode)this.rootNode).setPreparer(true);
        this.addNode(rootNode);
    }

    public boolean hasParents() {
        return this.parentDAGs.size() > 0;
    }

    protected NodeT root() {
        return this.rootNode;
    }

    public boolean isRootNode(NodeT node) {
        return this.rootNode == node;
    }

    public boolean isPreparer() {
        return ((DAGNode)this.rootNode).isPreparer();
    }

    public NodeT getNode(String key) {
        return (NodeT)((DAGNode)this.nodeTable.get(key));
    }

    public void addDependencyGraph(DAGraph<DataT, NodeT> dependencyGraph) {
        ((DAGNode)this.rootNode).addDependency(((Node)dependencyGraph.rootNode).key());
        Map sourceNodeTable = dependencyGraph.nodeTable;
        Map targetNodeTable = this.nodeTable;
        this.merge(sourceNodeTable, targetNodeTable);
        dependencyGraph.parentDAGs.add(this);
        if (this.hasParents()) {
            this.bubbleUpNodeTable(this, new LinkedList<String>());
        }
    }

    public void addDependentGraph(DAGraph<DataT, NodeT> dependentGraph) {
        dependentGraph.addDependencyGraph(this);
    }

    public void prepareForEnumeration() {
        if (this.isPreparer()) {
            for (DAGNode node : this.nodeTable.values()) {
                node.initialize();
                if (this.isRootNode(node)) continue;
                node.setPreparer(false);
            }
            this.initializeDependentKeys();
            this.initializeQueue();
        }
    }

    public NodeT getNext() {
        String nextItemKey = this.queue.poll();
        if (nextItemKey == null) {
            return null;
        }
        return (NodeT)((DAGNode)this.nodeTable.get(nextItemKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCompletion(NodeT completed) {
        ((DAGNode)completed).setPreparer(true);
        String dependency = ((Node)completed).key();
        for (String dependentKey : ((DAGNode)this.nodeTable.get(dependency)).dependentKeys()) {
            DAGNode dependent = (DAGNode)this.nodeTable.get(dependentKey);
            dependent.lock().lock();
            try {
                dependent.onSuccessfulResolution(dependency);
                if (!dependent.hasAllResolved()) continue;
                this.queue.add(dependent.key());
            }
            finally {
                dependent.lock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportError(NodeT faulted, Throwable throwable) {
        ((DAGNode)faulted).setPreparer(true);
        String dependency = ((Node)faulted).key();
        for (String dependentKey : ((DAGNode)this.nodeTable.get(dependency)).dependentKeys()) {
            DAGNode dependent = (DAGNode)this.nodeTable.get(dependentKey);
            dependent.lock().lock();
            try {
                dependent.onFaultedResolution(dependency, throwable);
                if (!dependent.hasAllResolved()) continue;
                this.queue.add(dependent.key());
            }
            finally {
                dependent.lock().unlock();
            }
        }
    }

    private void initializeDependentKeys() {
        this.visit(new Graph.Visitor<NodeT>(){

            @Override
            public void visitNode(NodeT node) {
                if (((DAGNode)node).dependencyKeys().isEmpty()) {
                    return;
                }
                String dependentKey = ((Node)node).key();
                for (String dependencyKey : ((DAGNode)node).dependencyKeys()) {
                    ((DAGNode)DAGraph.this.nodeTable.get(dependencyKey)).addDependent(dependentKey);
                }
            }

            @Override
            public void visitEdge(String fromKey, String toKey, Graph.EdgeType edgeType) {
                if (edgeType == Graph.EdgeType.BACK) {
                    throw new IllegalStateException("Detected circular dependency: " + DAGraph.this.findPath(fromKey, toKey));
                }
            }
        });
    }

    private void initializeQueue() {
        this.queue.clear();
        for (Map.Entry entry : this.nodeTable.entrySet()) {
            if (((DAGNode)entry.getValue()).hasDependencies()) continue;
            this.queue.add((String)entry.getKey());
        }
        if (this.queue.isEmpty()) {
            throw new IllegalStateException("Detected circular dependency");
        }
    }

    private void merge(Map<String, NodeT> source, Map<String, NodeT> target) {
        for (Map.Entry<String, NodeT> entry : source.entrySet()) {
            String key = entry.getKey();
            if (target.containsKey(key)) continue;
            target.put(key, entry.getValue());
        }
    }

    private void bubbleUpNodeTable(DAGraph<DataT, NodeT> from, LinkedList<String> path) {
        if (path.contains(((Node)from.rootNode).key())) {
            path.push(((Node)from.rootNode).key());
            throw new IllegalStateException("Detected circular dependency: " + StringUtils.join(path, (String)" -> "));
        }
        path.push(((Node)from.rootNode).key());
        for (DAGraph<DataT, NodeT> to : from.parentDAGs) {
            this.merge(from.nodeTable, to.nodeTable);
            this.bubbleUpNodeTable(to, path);
        }
        path.pop();
    }
}

