/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.redis.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.redis.ScheduleEntry;
import com.microsoft.azure.management.redis.implementation.PageImpl;
import com.microsoft.azure.management.redis.implementation.RedisManagementClientImpl;
import com.microsoft.azure.management.redis.implementation.RedisPatchScheduleInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PatchSchedulesInner
implements InnerSupportsDelete<Void> {
    private PatchSchedulesService service;
    private RedisManagementClientImpl client;

    public PatchSchedulesInner(Retrofit retrofit, RedisManagementClientImpl client) {
        this.service = (PatchSchedulesService)retrofit.create(PatchSchedulesService.class);
        this.client = client;
    }

    public PagedList<RedisPatchScheduleInner> listByRedisResource(String resourceGroupName, String cacheName) {
        ServiceResponse response = (ServiceResponse)this.listByRedisResourceSinglePageAsync(resourceGroupName, cacheName).toBlocking().single();
        return new PagedList<RedisPatchScheduleInner>((Page)response.body()){

            public Page<RedisPatchScheduleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PatchSchedulesInner.this.listByRedisResourceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RedisPatchScheduleInner>> listByRedisResourceAsync(String resourceGroupName, String cacheName, ListOperationCallback<RedisPatchScheduleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByRedisResourceSinglePageAsync(resourceGroupName, cacheName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RedisPatchScheduleInner>>>>(){

            public Observable<ServiceResponse<Page<RedisPatchScheduleInner>>> call(String nextPageLink) {
                return PatchSchedulesInner.this.listByRedisResourceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RedisPatchScheduleInner>> listByRedisResourceAsync(String resourceGroupName, String cacheName) {
        return this.listByRedisResourceWithServiceResponseAsync(resourceGroupName, cacheName).map((Func1)new Func1<ServiceResponse<Page<RedisPatchScheduleInner>>, Page<RedisPatchScheduleInner>>(){

            public Page<RedisPatchScheduleInner> call(ServiceResponse<Page<RedisPatchScheduleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisPatchScheduleInner>>> listByRedisResourceWithServiceResponseAsync(String resourceGroupName, String cacheName) {
        return this.listByRedisResourceSinglePageAsync(resourceGroupName, cacheName).concatMap((Func1)new Func1<ServiceResponse<Page<RedisPatchScheduleInner>>, Observable<ServiceResponse<Page<RedisPatchScheduleInner>>>>(){

            public Observable<ServiceResponse<Page<RedisPatchScheduleInner>>> call(ServiceResponse<Page<RedisPatchScheduleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PatchSchedulesInner.this.listByRedisResourceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisPatchScheduleInner>>> listByRedisResourceSinglePageAsync(String resourceGroupName, String cacheName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (cacheName == null) {
            throw new IllegalArgumentException("Parameter cacheName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByRedisResource(this.client.subscriptionId(), resourceGroupName, cacheName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RedisPatchScheduleInner>>>>(){

            public Observable<ServiceResponse<Page<RedisPatchScheduleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PatchSchedulesInner.this.listByRedisResourceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RedisPatchScheduleInner>> listByRedisResourceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RedisPatchScheduleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RedisPatchScheduleInner createOrUpdate(String resourceGroupName, String name, List<ScheduleEntry> scheduleEntries) {
        return (RedisPatchScheduleInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, name, scheduleEntries).toBlocking().single()).body();
    }

    public ServiceFuture<RedisPatchScheduleInner> createOrUpdateAsync(String resourceGroupName, String name, List<ScheduleEntry> scheduleEntries, ServiceCallback<RedisPatchScheduleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, name, scheduleEntries), serviceCallback);
    }

    public Observable<RedisPatchScheduleInner> createOrUpdateAsync(String resourceGroupName, String name, List<ScheduleEntry> scheduleEntries) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, name, scheduleEntries).map((Func1)new Func1<ServiceResponse<RedisPatchScheduleInner>, RedisPatchScheduleInner>(){

            public RedisPatchScheduleInner call(ServiceResponse<RedisPatchScheduleInner> response) {
                return (RedisPatchScheduleInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RedisPatchScheduleInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String name, List<ScheduleEntry> scheduleEntries) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (scheduleEntries == null) {
            throw new IllegalArgumentException("Parameter scheduleEntries is required and cannot be null.");
        }
        Validator.validate(scheduleEntries);
        String defaultParameter = "default";
        RedisPatchScheduleInner parameters = new RedisPatchScheduleInner();
        parameters.withScheduleEntries(scheduleEntries);
        return this.service.createOrUpdate(resourceGroupName, name, "default", this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisPatchScheduleInner>>>(){

            public Observable<ServiceResponse<RedisPatchScheduleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PatchSchedulesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RedisPatchScheduleInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RedisPatchScheduleInner>(){}.getType()).register(201, new TypeToken<RedisPatchScheduleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String name) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, name).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String name, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String name) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, name).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String defaultParameter = "default";
        return this.service.delete(resourceGroupName, name, "default", this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PatchSchedulesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RedisPatchScheduleInner get(String resourceGroupName, String name) {
        return (RedisPatchScheduleInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, name).toBlocking().single()).body();
    }

    public ServiceFuture<RedisPatchScheduleInner> getAsync(String resourceGroupName, String name, ServiceCallback<RedisPatchScheduleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    public Observable<RedisPatchScheduleInner> getAsync(String resourceGroupName, String name) {
        return this.getWithServiceResponseAsync(resourceGroupName, name).map((Func1)new Func1<ServiceResponse<RedisPatchScheduleInner>, RedisPatchScheduleInner>(){

            public RedisPatchScheduleInner call(ServiceResponse<RedisPatchScheduleInner> response) {
                return (RedisPatchScheduleInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RedisPatchScheduleInner>> getWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String defaultParameter = "default";
        return this.service.get(resourceGroupName, name, "default", this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisPatchScheduleInner>>>(){

            public Observable<ServiceResponse<RedisPatchScheduleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PatchSchedulesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RedisPatchScheduleInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RedisPatchScheduleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RedisPatchScheduleInner> listByRedisResourceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByRedisResourceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RedisPatchScheduleInner>((Page)response.body()){

            public Page<RedisPatchScheduleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PatchSchedulesInner.this.listByRedisResourceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RedisPatchScheduleInner>> listByRedisResourceNextAsync(String nextPageLink, ServiceFuture<List<RedisPatchScheduleInner>> serviceFuture, ListOperationCallback<RedisPatchScheduleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByRedisResourceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RedisPatchScheduleInner>>>>(){

            public Observable<ServiceResponse<Page<RedisPatchScheduleInner>>> call(String nextPageLink) {
                return PatchSchedulesInner.this.listByRedisResourceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RedisPatchScheduleInner>> listByRedisResourceNextAsync(String nextPageLink) {
        return this.listByRedisResourceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RedisPatchScheduleInner>>, Page<RedisPatchScheduleInner>>(){

            public Page<RedisPatchScheduleInner> call(ServiceResponse<Page<RedisPatchScheduleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisPatchScheduleInner>>> listByRedisResourceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByRedisResourceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RedisPatchScheduleInner>>, Observable<ServiceResponse<Page<RedisPatchScheduleInner>>>>(){

            public Observable<ServiceResponse<Page<RedisPatchScheduleInner>>> call(ServiceResponse<Page<RedisPatchScheduleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PatchSchedulesInner.this.listByRedisResourceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisPatchScheduleInner>>> listByRedisResourceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByRedisResourceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RedisPatchScheduleInner>>>>(){

            public Observable<ServiceResponse<Page<RedisPatchScheduleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PatchSchedulesInner.this.listByRedisResourceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RedisPatchScheduleInner>> listByRedisResourceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RedisPatchScheduleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PatchSchedulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.PatchSchedules listByRedisResource"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{cacheName}/patchSchedules")
        public Observable<Response<ResponseBody>> listByRedisResource(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="cacheName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.PatchSchedules createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/patchSchedules/{default}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="default") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body RedisPatchScheduleInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.PatchSchedules delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/patchSchedules/{default}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="default") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.PatchSchedules get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/patchSchedules/{default}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="default") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.PatchSchedules listByRedisResourceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByRedisResourceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

