/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayBackend;
import com.microsoft.azure.management.network.ApplicationGatewayBackendAddress;
import com.microsoft.azure.management.network.ApplicationGatewayProtocol;
import com.microsoft.azure.management.network.ApplicationGatewayRedirectConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayRequestRoutingRule;
import com.microsoft.azure.management.network.ApplicationGatewayRequestRoutingRuleType;
import com.microsoft.azure.management.network.ApplicationGatewaySslCertificate;
import com.microsoft.azure.management.network.ApplicationGatewayUrlPathMap;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendHttpConfigurationImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayListenerImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayRequestRoutingRuleInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

@LangDefinition
class ApplicationGatewayRequestRoutingRuleImpl
extends ChildResourceImpl<ApplicationGatewayRequestRoutingRuleInner, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayRequestRoutingRule,
ApplicationGatewayRequestRoutingRule.Definition<ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate>,
ApplicationGatewayRequestRoutingRule.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayRequestRoutingRule.Update {
    private Boolean associateWithPublicFrontend = null;

    ApplicationGatewayRequestRoutingRuleImpl(ApplicationGatewayRequestRoutingRuleInner inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    @Override
    public Collection<ApplicationGatewayBackendAddress> backendAddresses() {
        Collection<Object> addresses = new ArrayList();
        ApplicationGatewayBackend backend = this.backend();
        if (backend != null && backend.addresses() != null) {
            addresses = backend.addresses();
        }
        return Collections.unmodifiableCollection(addresses);
    }

    @Override
    public ApplicationGatewayUrlPathMap urlPathMap() {
        SubResource urlMapRef = ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).urlPathMap();
        if (urlMapRef != null) {
            String urlMapName = ResourceUtils.nameFromResourceId((String)urlMapRef.id());
            return ((ApplicationGatewayImpl)this.parent()).urlPathMaps().get(urlMapName);
        }
        return null;
    }

    @Override
    public boolean cookieBasedAffinity() {
        ApplicationGatewayBackendHttpConfigurationImpl backendConfig = this.backendHttpConfiguration();
        return backendConfig != null ? backendConfig.cookieBasedAffinity() : false;
    }

    @Override
    public int backendPort() {
        ApplicationGatewayBackendHttpConfigurationImpl backendConfig = this.backendHttpConfiguration();
        return backendConfig != null ? backendConfig.port() : 0;
    }

    @Override
    public boolean requiresServerNameIndication() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? listener.requiresServerNameIndication() : false;
    }

    @Override
    public String hostName() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? listener.hostName() : null;
    }

    @Override
    public int frontendPort() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? listener.frontendPortNumber() : 0;
    }

    @Override
    public ApplicationGatewaySslCertificate sslCertificate() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? (ApplicationGatewaySslCertificate)listener.sslCertificate() : null;
    }

    @Override
    public ApplicationGatewayProtocol frontendProtocol() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? (ApplicationGatewayProtocol)((Object)listener.protocol()) : null;
    }

    @Override
    public String publicIPAddressId() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? listener.publicIPAddressId() : null;
    }

    @Override
    public PublicIPAddress getPublicIPAddress() {
        String pipId = this.publicIPAddressId();
        return pipId != null ? (PublicIPAddress)((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).publicIPAddresses().getById(pipId) : null;
    }

    public String name() {
        return ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).name();
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleType ruleType() {
        return ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).ruleType();
    }

    @Override
    public ApplicationGatewayBackend backend() {
        SubResource backendRef = ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).backendAddressPool();
        if (backendRef != null) {
            String backendName = ResourceUtils.nameFromResourceId((String)backendRef.id());
            return ((ApplicationGatewayImpl)this.parent()).backends().get(backendName);
        }
        return null;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl backendHttpConfiguration() {
        SubResource configRef = ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).backendHttpSettings();
        if (configRef != null) {
            String configName = ResourceUtils.nameFromResourceId((String)configRef.id());
            return (ApplicationGatewayBackendHttpConfigurationImpl)((ApplicationGatewayImpl)this.parent()).backendHttpConfigurations().get(configName);
        }
        return null;
    }

    @Override
    public ApplicationGatewayListenerImpl listener() {
        SubResource listenerRef = ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).httpListener();
        if (listenerRef != null) {
            String listenerName = ResourceUtils.nameFromResourceId((String)listenerRef.id());
            return (ApplicationGatewayListenerImpl)((ApplicationGatewayImpl)this.parent()).listeners().get(listenerName);
        }
        return null;
    }

    @Override
    public ApplicationGatewayRedirectConfiguration redirectConfiguration() {
        SubResource ref = ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).redirectConfiguration();
        if (ref == null) {
            return null;
        }
        return ((ApplicationGatewayImpl)this.parent()).redirectConfigurations().get(ResourceUtils.nameFromResourceId((String)ref.id()));
    }

    public ApplicationGatewayImpl attach() {
        return ((ApplicationGatewayImpl)this.parent()).withRequestRoutingRule(this);
    }

    public ApplicationGatewayRequestRoutingRuleImpl fromPublicFrontend() {
        this.associateWithPublicFrontend = true;
        return this;
    }

    public ApplicationGatewayRequestRoutingRuleImpl fromPrivateFrontend() {
        this.associateWithPublicFrontend = false;
        return this;
    }

    public ApplicationGatewayRequestRoutingRuleImpl fromFrontendHttpPort(int portNumber) {
        return this.fromFrontendPort(portNumber, ApplicationGatewayProtocol.HTTP, null);
    }

    public ApplicationGatewayRequestRoutingRuleImpl fromFrontendHttpsPort(int portNumber) {
        return this.fromFrontendPort(portNumber, ApplicationGatewayProtocol.HTTPS, null);
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl toBackendHttpConfiguration(String name) {
        SubResource httpConfigRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/backendHttpSettingsCollection/" + name);
        ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).withBackendHttpSettings(httpConfigRef);
        return this;
    }

    private ApplicationGatewayBackendHttpConfigurationImpl ensureBackendHttpConfig() {
        ApplicationGatewayBackendHttpConfigurationImpl config = this.backendHttpConfiguration();
        if (config == null) {
            String name = SdkContext.randomResourceName((String)"bckcfg", (int)11);
            config = ((ApplicationGatewayImpl)this.parent()).defineBackendHttpConfiguration(name);
            config.attach();
            this.toBackendHttpConfiguration(name);
        }
        return config;
    }

    public ApplicationGatewayRequestRoutingRuleImpl toBackendHttpPort(int portNumber) {
        String name = SdkContext.randomResourceName((String)"backcfg", (int)12);
        ((ApplicationGatewayImpl)this.parent()).defineBackendHttpConfiguration(name).withPort(portNumber).attach();
        return this.toBackendHttpConfiguration(name);
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withCookieBasedAffinity() {
        ((ApplicationGatewayImpl)this.parent()).updateBackendHttpConfiguration(this.ensureBackendHttpConfig().name()).withCookieBasedAffinity();
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withoutCookieBasedAffinity() {
        ((ApplicationGatewayImpl)this.parent()).updateBackendHttpConfiguration(this.ensureBackendHttpConfig().name()).withoutCookieBasedAffinity();
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl fromListener(String name) {
        SubResource listenerRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/HTTPListeners/" + name);
        ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).withHttpListener(listenerRef);
        return this;
    }

    private ApplicationGatewayRequestRoutingRuleImpl fromFrontendPort(int portNumber, ApplicationGatewayProtocol protocol, String name) {
        Boolean needToCreate;
        ApplicationGatewayListenerImpl listenerByPort = (ApplicationGatewayListenerImpl)((ApplicationGatewayImpl)this.parent()).listenerByPortNumber(portNumber);
        ApplicationGatewayListenerImpl listenerByName = null;
        if (name != null) {
            listenerByName = (ApplicationGatewayListenerImpl)((ApplicationGatewayImpl)this.parent()).listeners().get(name);
        }
        if (Boolean.TRUE.equals(needToCreate = ((ApplicationGatewayImpl)this.parent()).needToCreate(listenerByName, listenerByPort, name))) {
            if (name == null) {
                name = SdkContext.randomResourceName((String)"listener", (int)13);
            }
            listenerByPort = ((ApplicationGatewayImpl)this.parent()).defineListener(name).withFrontendPort(portNumber);
            if (ApplicationGatewayProtocol.HTTP.equals((Object)protocol)) {
                listenerByPort.withHttp();
            } else if (ApplicationGatewayProtocol.HTTPS.equals((Object)protocol)) {
                listenerByPort.withHttps();
            }
            if (Boolean.TRUE.equals(this.associateWithPublicFrontend)) {
                listenerByPort.withPublicFrontend();
                ((ApplicationGatewayImpl)this.parent()).withNewPublicIPAddress();
            } else if (Boolean.FALSE.equals(this.associateWithPublicFrontend)) {
                listenerByPort.withPrivateFrontend();
            }
            this.associateWithPublicFrontend = null;
            listenerByPort.attach();
            return this.fromListener(listenerByPort.name());
        }
        return null;
    }

    private ApplicationGatewayListenerImpl ensureListener() {
        ApplicationGatewayListenerImpl listener = this.listener();
        if (listener == null) {
            String name = SdkContext.randomResourceName((String)"listener", (int)13);
            listener = ((ApplicationGatewayImpl)this.parent()).defineListener(name);
            listener.attach();
            this.fromListener(name);
        }
        return listener;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withSslCertificate(String name) {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withSslCertificate(name);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withSslCertificateFromKeyVaultSecretId(String keyVaultSecretId) {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withSslCertificateFromKeyVaultSecretId(keyVaultSecretId);
        return this;
    }

    public ApplicationGatewayRequestRoutingRuleImpl withSslCertificateFromPfxFile(File pfxFile) throws IOException {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withSslCertificateFromPfxFile(pfxFile);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withSslCertificatePassword(String password) {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withSslCertificatePassword(password);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withHostName(String hostName) {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withHostName(hostName);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withServerNameIndication() {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withServerNameIndication();
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withoutServerNameIndication() {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withoutServerNameIndication();
        return this;
    }

    private ApplicationGatewayBackendImpl ensureBackend() {
        ApplicationGatewayBackendImpl backend = (ApplicationGatewayBackendImpl)this.backend();
        if (backend == null) {
            backend = ((ApplicationGatewayImpl)this.parent()).ensureUniqueBackend();
            this.toBackend(backend.name());
        }
        return backend;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl toBackend(String name) {
        ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).withBackendAddressPool(((ApplicationGatewayImpl)this.parent()).ensureBackendRef(name));
        return this;
    }

    public ApplicationGatewayRequestRoutingRuleImpl toBackendIPAddress(String ipAddress) {
        ((ApplicationGatewayImpl)this.parent()).updateBackend(this.ensureBackend().name()).withIPAddress(ipAddress);
        return this;
    }

    public ApplicationGatewayRequestRoutingRuleImpl toBackendIPAddresses(String ... ipAddresses) {
        if (ipAddresses != null) {
            for (String ipAddress : ipAddresses) {
                this.toBackendIPAddress(ipAddress);
            }
        }
        return this;
    }

    public ApplicationGatewayRequestRoutingRuleImpl toBackendFqdn(String fqdn) {
        ((ApplicationGatewayImpl)this.parent()).updateBackend(this.ensureBackend().name()).withFqdn(fqdn);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withRedirectConfiguration(String name) {
        if (name == null) {
            ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).withRedirectConfiguration(null);
        } else {
            SubResource ref = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/redirectConfigurations/" + name);
            ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).withRedirectConfiguration(ref).withBackendAddressPool(null).withBackendHttpSettings(null);
        }
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withoutRedirectConfiguration() {
        ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).withRedirectConfiguration(null);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRule.DefinitionStages.WithAttach<ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate> withUrlPathMap(String urlPathMapName) {
        if (urlPathMapName == null) {
            ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).withUrlPathMap(null);
        } else {
            SubResource ref = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/urlPathMaps/" + urlPathMapName);
            ((ApplicationGatewayRequestRoutingRuleInner)((Object)this.inner())).withUrlPathMap(ref);
        }
        return this;
    }
}

