/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in VirtualHubs.
 */
public class VirtualHubsInner implements InnerSupportsGet<VirtualHubInner>, InnerSupportsDelete<Void>, InnerSupportsListing<VirtualHubInner> {
    /** The Retrofit service to perform REST calls. */
    private VirtualHubsService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of VirtualHubsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VirtualHubsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(VirtualHubsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for VirtualHubs to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VirtualHubsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualHubName") String virtualHubName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualHubName") String virtualHubName, @Query("api-version") String apiVersion, @Body VirtualHubInner virtualHubParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualHubName") String virtualHubName, @Query("api-version") String apiVersion, @Body VirtualHubInner virtualHubParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs updateTags" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}")
        Observable<Response<ResponseBody>> updateTags(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualHubName") String virtualHubName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject virtualHubParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualHubName") String virtualHubName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualHubName") String virtualHubName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/virtualHubs")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Retrieves the details of a VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualHubInner object if successful.
     */
    public VirtualHubInner getByResourceGroup(String resourceGroupName, String virtualHubName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualHubName).toBlocking().single().body();
    }

    /**
     * Retrieves the details of a VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualHubInner> getByResourceGroupAsync(String resourceGroupName, String virtualHubName, final ServiceCallback<VirtualHubInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualHubName), serviceCallback);
    }

    /**
     * Retrieves the details of a VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualHubInner object
     */
    public Observable<VirtualHubInner> getByResourceGroupAsync(String resourceGroupName, String virtualHubName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualHubName).map(new Func1<ServiceResponse<VirtualHubInner>, VirtualHubInner>() {
            @Override
            public VirtualHubInner call(ServiceResponse<VirtualHubInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the details of a VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualHubInner object
     */
    public Observable<ServiceResponse<VirtualHubInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, virtualHubName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualHubInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualHubInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualHubInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualHubInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualHubInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualHubInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a VirtualHub resource if it doesn't exist else updates the existing VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param virtualHubParameters Parameters supplied to create or update VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualHubInner object if successful.
     */
    public VirtualHubInner createOrUpdate(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, virtualHubParameters).toBlocking().last().body();
    }

    /**
     * Creates a VirtualHub resource if it doesn't exist else updates the existing VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param virtualHubParameters Parameters supplied to create or update VirtualHub.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualHubInner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters, final ServiceCallback<VirtualHubInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, virtualHubParameters), serviceCallback);
    }

    /**
     * Creates a VirtualHub resource if it doesn't exist else updates the existing VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param virtualHubParameters Parameters supplied to create or update VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualHubInner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, virtualHubParameters).map(new Func1<ServiceResponse<VirtualHubInner>, VirtualHubInner>() {
            @Override
            public VirtualHubInner call(ServiceResponse<VirtualHubInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a VirtualHub resource if it doesn't exist else updates the existing VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param virtualHubParameters Parameters supplied to create or update VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualHubInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (virtualHubParameters == null) {
            throw new IllegalArgumentException("Parameter virtualHubParameters is required and cannot be null.");
        }
        Validator.validate(virtualHubParameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualHubName, apiVersion, virtualHubParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualHubInner>() { }.getType());
    }

    /**
     * Creates a VirtualHub resource if it doesn't exist else updates the existing VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param virtualHubParameters Parameters supplied to create or update VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualHubInner object if successful.
     */
    public VirtualHubInner beginCreateOrUpdate(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, virtualHubParameters).toBlocking().single().body();
    }

    /**
     * Creates a VirtualHub resource if it doesn't exist else updates the existing VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param virtualHubParameters Parameters supplied to create or update VirtualHub.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualHubInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters, final ServiceCallback<VirtualHubInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, virtualHubParameters), serviceCallback);
    }

    /**
     * Creates a VirtualHub resource if it doesn't exist else updates the existing VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param virtualHubParameters Parameters supplied to create or update VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualHubInner object
     */
    public Observable<VirtualHubInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, virtualHubParameters).map(new Func1<ServiceResponse<VirtualHubInner>, VirtualHubInner>() {
            @Override
            public VirtualHubInner call(ServiceResponse<VirtualHubInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a VirtualHub resource if it doesn't exist else updates the existing VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param virtualHubParameters Parameters supplied to create or update VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualHubInner object
     */
    public Observable<ServiceResponse<VirtualHubInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (virtualHubParameters == null) {
            throw new IllegalArgumentException("Parameter virtualHubParameters is required and cannot be null.");
        }
        Validator.validate(virtualHubParameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualHubName, apiVersion, virtualHubParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualHubInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualHubInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualHubInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualHubInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualHubInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualHubInner>() { }.getType())
                .register(201, new TypeToken<VirtualHubInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates VirtualHub tags.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualHubInner object if successful.
     */
    public VirtualHubInner updateTags(String resourceGroupName, String virtualHubName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, virtualHubName).toBlocking().single().body();
    }

    /**
     * Updates VirtualHub tags.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualHubInner> updateTagsAsync(String resourceGroupName, String virtualHubName, final ServiceCallback<VirtualHubInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, virtualHubName), serviceCallback);
    }

    /**
     * Updates VirtualHub tags.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualHubInner object
     */
    public Observable<VirtualHubInner> updateTagsAsync(String resourceGroupName, String virtualHubName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, virtualHubName).map(new Func1<ServiceResponse<VirtualHubInner>, VirtualHubInner>() {
            @Override
            public VirtualHubInner call(ServiceResponse<VirtualHubInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates VirtualHub tags.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualHubInner object
     */
    public Observable<ServiceResponse<VirtualHubInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final Map<String, String> tags = null;
        TagsObject virtualHubParameters = new TagsObject();
        virtualHubParameters.withTags(null);
        return service.updateTags(this.client.subscriptionId(), resourceGroupName, virtualHubName, apiVersion, this.client.acceptLanguage(), virtualHubParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualHubInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualHubInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualHubInner> clientResponse = updateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates VirtualHub tags.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualHubInner object if successful.
     */
    public VirtualHubInner updateTags(String resourceGroupName, String virtualHubName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, virtualHubName, tags).toBlocking().single().body();
    }

    /**
     * Updates VirtualHub tags.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualHubInner> updateTagsAsync(String resourceGroupName, String virtualHubName, Map<String, String> tags, final ServiceCallback<VirtualHubInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, virtualHubName, tags), serviceCallback);
    }

    /**
     * Updates VirtualHub tags.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualHubInner object
     */
    public Observable<VirtualHubInner> updateTagsAsync(String resourceGroupName, String virtualHubName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, virtualHubName, tags).map(new Func1<ServiceResponse<VirtualHubInner>, VirtualHubInner>() {
            @Override
            public VirtualHubInner call(ServiceResponse<VirtualHubInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates VirtualHub tags.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualHubInner object
     */
    public Observable<ServiceResponse<VirtualHubInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String virtualHubName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2019-11-01";
        TagsObject virtualHubParameters = new TagsObject();
        virtualHubParameters.withTags(tags);
        return service.updateTags(this.client.subscriptionId(), resourceGroupName, virtualHubName, apiVersion, this.client.acceptLanguage(), virtualHubParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualHubInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualHubInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualHubInner> clientResponse = updateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualHubInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualHubInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualHubInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String virtualHubName) {
        deleteWithServiceResponseAsync(resourceGroupName, virtualHubName).toBlocking().last().body();
    }

    /**
     * Deletes a VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualHubName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, virtualHubName), serviceCallback);
    }

    /**
     * Deletes a VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String virtualHubName) {
        return deleteWithServiceResponseAsync(resourceGroupName, virtualHubName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, virtualHubName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String virtualHubName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, virtualHubName).toBlocking().single().body();
    }

    /**
     * Deletes a VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualHubName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, virtualHubName), serviceCallback);
    }

    /**
     * Deletes a VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualHubName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, virtualHubName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, virtualHubName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the VirtualHubs in a resource group.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualHubInner&gt; object if successful.
     */
    public PagedList<VirtualHubInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<VirtualHubInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VirtualHubInner>(response.body()) {
            @Override
            public Page<VirtualHubInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the VirtualHubs in a resource group.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualHubInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<VirtualHubInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<VirtualHubInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the VirtualHubs in a resource group.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualHubInner&gt; object
     */
    public Observable<Page<VirtualHubInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<VirtualHubInner>>, Page<VirtualHubInner>>() {
                @Override
                public Page<VirtualHubInner> call(ServiceResponse<Page<VirtualHubInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the VirtualHubs in a resource group.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualHubInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualHubInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<VirtualHubInner>>, Observable<ServiceResponse<Page<VirtualHubInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubInner>>> call(ServiceResponse<Page<VirtualHubInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the VirtualHubs in a resource group.
     *
    ServiceResponse<PageImpl<VirtualHubInner>> * @param resourceGroupName The resource group name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualHubInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualHubInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualHubInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualHubInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualHubInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualHubInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualHubInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualHubInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the VirtualHubs in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualHubInner&gt; object if successful.
     */
    public PagedList<VirtualHubInner> list() {
        ServiceResponse<Page<VirtualHubInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<VirtualHubInner>(response.body()) {
            @Override
            public Page<VirtualHubInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the VirtualHubs in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualHubInner>> listAsync(final ListOperationCallback<VirtualHubInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<VirtualHubInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the VirtualHubs in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualHubInner&gt; object
     */
    public Observable<Page<VirtualHubInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<VirtualHubInner>>, Page<VirtualHubInner>>() {
                @Override
                public Page<VirtualHubInner> call(ServiceResponse<Page<VirtualHubInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the VirtualHubs in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualHubInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualHubInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<VirtualHubInner>>, Observable<ServiceResponse<Page<VirtualHubInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubInner>>> call(ServiceResponse<Page<VirtualHubInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the VirtualHubs in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualHubInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualHubInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualHubInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualHubInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualHubInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualHubInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualHubInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualHubInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the VirtualHubs in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualHubInner&gt; object if successful.
     */
    public PagedList<VirtualHubInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualHubInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualHubInner>(response.body()) {
            @Override
            public Page<VirtualHubInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the VirtualHubs in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualHubInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualHubInner>> serviceFuture, final ListOperationCallback<VirtualHubInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualHubInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the VirtualHubs in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualHubInner&gt; object
     */
    public Observable<Page<VirtualHubInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualHubInner>>, Page<VirtualHubInner>>() {
                @Override
                public Page<VirtualHubInner> call(ServiceResponse<Page<VirtualHubInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the VirtualHubs in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualHubInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualHubInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualHubInner>>, Observable<ServiceResponse<Page<VirtualHubInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubInner>>> call(ServiceResponse<Page<VirtualHubInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the VirtualHubs in a resource group.
     *
    ServiceResponse<PageImpl<VirtualHubInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualHubInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualHubInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualHubInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualHubInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualHubInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualHubInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualHubInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualHubInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the VirtualHubs in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualHubInner&gt; object if successful.
     */
    public PagedList<VirtualHubInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualHubInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualHubInner>(response.body()) {
            @Override
            public Page<VirtualHubInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the VirtualHubs in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualHubInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualHubInner>> serviceFuture, final ListOperationCallback<VirtualHubInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualHubInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the VirtualHubs in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualHubInner&gt; object
     */
    public Observable<Page<VirtualHubInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualHubInner>>, Page<VirtualHubInner>>() {
                @Override
                public Page<VirtualHubInner> call(ServiceResponse<Page<VirtualHubInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the VirtualHubs in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualHubInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualHubInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualHubInner>>, Observable<ServiceResponse<Page<VirtualHubInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubInner>>> call(ServiceResponse<Page<VirtualHubInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the VirtualHubs in a subscription.
     *
    ServiceResponse<PageImpl<VirtualHubInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualHubInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualHubInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualHubInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualHubInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualHubInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualHubInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualHubInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualHubInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
